/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.File;
import java.net.SocketAddress;
import jnr.constants.platform.ProtocolFamily;
import jnr.unixsocket.SockAddrUnix;

public class UnixSocketAddress
extends SocketAddress {
    private final SockAddrUnix address = SockAddrUnix.create();

    UnixSocketAddress() {
        this.address.setFamily(ProtocolFamily.PF_UNIX);
    }

    public UnixSocketAddress(File path2) {
        this.address.setFamily(ProtocolFamily.PF_UNIX);
        this.address.setPath(path2.getAbsolutePath());
    }

    SockAddrUnix getStruct() {
        return this.address;
    }

    int length() {
        return this.address.length();
    }

    public String toString() {
        return "[family=" + this.address.getFamily() + " path=" + this.address.getPath() + "]";
    }

    public boolean equals(Object _other) {
        if (!(_other instanceof UnixSocketAddress)) {
            return false;
        }
        UnixSocketAddress other = (UnixSocketAddress)_other;
        return this.address.getFamily() == other.address.getFamily() && this.address.getPath().equals(other.address.getPath());
    }
}

