/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class YieldInstr
extends TwoOperandResultBaseInstr
implements FixedArityInstr {
    public final boolean unwrapArray;

    public YieldInstr(Variable result2, Operand block, Operand arg2, boolean unwrapArray) {
        super(Operation.YIELD, result2, block, arg2 == null ? UndefinedValue.UNDEFINED : arg2);
        assert (result2 != null) : "YieldInstr result is null";
        this.unwrapArray = unwrapArray;
    }

    public Operand getBlockArg() {
        return this.getOperand1();
    }

    public Operand getYieldArg() {
        return this.getOperand2();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new YieldInstr(ii.getRenamedVariable(this.result), this.getBlockArg().cloneForInlining(ii), this.getYieldArg().cloneForInlining(ii), this.unwrapArray);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"unwrap: " + this.unwrapArray};
    }

    public boolean isUnwrapArray() {
        return this.unwrapArray;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getBlockArg());
        e.encode(this.getYieldArg());
        e.encode(this.isUnwrapArray());
    }

    public static YieldInstr decode(IRReaderDecoder d) {
        return new YieldInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Block blk = (Block)this.getBlockArg().retrieve(context, self2, currScope, currDynScope, temp);
        if (this.getYieldArg() == UndefinedValue.UNDEFINED) {
            return IRRuntimeHelpers.yieldSpecific(context, blk);
        }
        IRubyObject yieldVal = (IRubyObject)this.getYieldArg().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.yield(context, blk, yieldVal, this.unwrapArray);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.YieldInstr(this);
    }
}

