/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public class UppercaseSentenceStartRule
extends Rule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|(m{0,4}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3}))$");
    private static final Pattern WHITESPACE_OR_QUOTE = Pattern.compile("[ \"'\u201e\u00ab\u00bb\u2018\u2019\u201c\u201d\\n]");
    private static final Pattern QUOTE_START = Pattern.compile("[\"'\u201e\u00bb\u00ab\u201c\u2018]");
    private static final Pattern SENTENCE_END1 = Pattern.compile("[.?!\u2026]|");
    private static final Pattern SENTENCE_END2 = Pattern.compile("[.?!\u2026]");
    private static final Pattern DUTCH_SPECIAL_CASE = Pattern.compile("k|m|n|r|s|t");
    private final Language language;
    private String lastParagraphString = "";

    public UppercaseSentenceStartRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_case")));
        this.language = language;
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    @Override
    public final String getId() {
        return "UPPERCASE_SENTENCE_START";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_uppercase_sentence");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        String firstDutchToken;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        if (tokens.length < 2) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int matchTokenPos = 1;
        String firstToken = tokens[matchTokenPos].getToken();
        String secondToken = null;
        String thirdToken = null;
        if (tokens.length >= 3 && QUOTE_START.matcher(firstToken).matches()) {
            matchTokenPos = 2;
            secondToken = tokens[matchTokenPos].getToken();
        }
        if ((firstDutchToken = this.dutchSpecialCase(firstToken, secondToken, tokens)) != null) {
            thirdToken = firstDutchToken;
            matchTokenPos = 3;
        }
        String checkToken = firstToken;
        if (thirdToken != null) {
            checkToken = thirdToken;
        } else if (secondToken != null) {
            checkToken = secondToken;
        }
        String lastToken = tokens[tokens.length - 1].getToken();
        if (tokens.length >= 2 && WHITESPACE_OR_QUOTE.matcher(lastToken).matches()) {
            lastToken = tokens[tokens.length - 2].getToken();
        }
        boolean preventError = false;
        if (this.lastParagraphString.equals(",") || this.lastParagraphString.equals(";")) {
            preventError = true;
        }
        if (!SENTENCE_END1.matcher(this.lastParagraphString).matches() && !SENTENCE_END2.matcher(lastToken).matches()) {
            preventError = true;
        }
        this.lastParagraphString = lastToken;
        if (matchTokenPos + 1 < tokens.length && NUMERALS_EN.matcher(tokens[matchTokenPos].getToken()).matches() && (tokens[matchTokenPos + 1].getToken().equals(".") || tokens[matchTokenPos + 1].getToken().equals(")"))) {
            preventError = true;
        }
        if (this.isUrl(checkToken)) {
            preventError = true;
        }
        if (checkToken.length() > 0) {
            char firstChar = checkToken.charAt(0);
            if (!preventError && Character.isLowerCase(firstChar)) {
                RuleMatch ruleMatch = new RuleMatch(this, tokens[matchTokenPos].getStartPos(), tokens[matchTokenPos].getEndPos(), this.messages.getString("incorrect_case"));
                ruleMatch.setSuggestedReplacement(StringTools.uppercaseFirstChar(checkToken));
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private String dutchSpecialCase(String firstToken, String secondToken, AnalyzedTokenReadings[] tokens) {
        if (!this.language.getShortName().equals("nl")) {
            return null;
        }
        if (tokens.length >= 3 && firstToken.equals("'") && DUTCH_SPECIAL_CASE.matcher(secondToken).matches()) {
            return tokens[3].getToken();
        }
        return null;
    }

    @Override
    public void reset() {
        this.lastParagraphString = "";
    }

    protected boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }
}

