/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleWithMaxFilter;
import org.languagetool.rules.patterns.PatternRule;

public class RuleWithMaxFilterTest
extends TestCase {
    private static final Language language = TestTools.getDemoLanguage();

    public void testFilter() {
        ArrayList fakePatternTokens = new ArrayList();
        PatternRule rule1 = new PatternRule("id1", language, fakePatternTokens, "desc1", "msg1", "shortMsg1");
        PatternRule rule2 = new PatternRule("id1", language, fakePatternTokens, "desc2", "msg2", "shortMsg2");
        RuleMatch match1 = new RuleMatch((Rule)rule1, 10, 20, "Match1");
        RuleMatch match2 = new RuleMatch((Rule)rule2, 15, 25, "Match2");
        RuleWithMaxFilter filter = new RuleWithMaxFilter();
        List filteredMatches1 = filter.filter(Arrays.asList(match1, match2));
        RuleWithMaxFilterTest.assertEquals((int)2, (int)filteredMatches1.size());
        RuleMatch match3 = new RuleMatch((Rule)rule2, 11, 19, "Match3");
        List filteredMatches2 = filter.filter(Arrays.asList(match1, match3));
        RuleWithMaxFilterTest.assertEquals((int)1, (int)filteredMatches2.size());
    }

    public void testNoFilteringIfNotOverlapping() {
        ArrayList fakePatternTokens = new ArrayList();
        PatternRule rule1 = new PatternRule("id1", language, fakePatternTokens, "desc1", "msg1", "shortMsg1");
        PatternRule rule2 = new PatternRule("id1", language, fakePatternTokens, "desc2", "msg2", "shortMsg2");
        RuleMatch match1 = new RuleMatch((Rule)rule1, 10, 20, "Match1");
        RuleMatch match2 = new RuleMatch((Rule)rule2, 21, 25, "Match2");
        RuleWithMaxFilter filter = new RuleWithMaxFilter();
        List filteredMatches = filter.filter(Arrays.asList(match1, match2));
        RuleWithMaxFilterTest.assertEquals((int)2, (int)filteredMatches.size());
    }

    public void testNoFilteringIfDifferentRulegroups() {
        ArrayList fakePatternTokens = new ArrayList();
        PatternRule rule1 = new PatternRule("id1", language, fakePatternTokens, "desc1", "msg1", "shortMsg1");
        PatternRule rule2 = new PatternRule("id2", language, fakePatternTokens, "desc2", "msg2", "shortMsg2");
        RuleMatch match1 = new RuleMatch((Rule)rule1, 10, 20, "Match1");
        RuleMatch match2 = new RuleMatch((Rule)rule2, 15, 25, "Match2");
        RuleWithMaxFilter filter = new RuleWithMaxFilter();
        List filteredMatches1 = filter.filter(Arrays.asList(match1, match2));
        RuleWithMaxFilterTest.assertEquals((int)2, (int)filteredMatches1.size());
        RuleMatch match3 = new RuleMatch((Rule)rule2, 11, 19, "Match3");
        List filteredMatches2 = filter.filter(Arrays.asList(match1, match3));
        RuleWithMaxFilterTest.assertEquals((int)2, (int)filteredMatches2.size());
    }

    public void testOverlaps() {
        RuleWithMaxFilter filter = new RuleWithMaxFilter();
        RuleWithMaxFilterTest.assertTrue((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(10, 20)));
        RuleWithMaxFilterTest.assertFalse((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(5, 11)));
        RuleWithMaxFilterTest.assertFalse((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(11, 21)));
        RuleWithMaxFilterTest.assertTrue((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(11, 19)));
        RuleWithMaxFilterTest.assertFalse((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(1, 10)));
        RuleWithMaxFilterTest.assertTrue((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(19, 20)));
        RuleWithMaxFilterTest.assertFalse((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(21, 30)));
        RuleWithMaxFilterTest.assertFalse((boolean)filter.includes(this.makeRuleMatch(10, 20), this.makeRuleMatch(1, 9)));
    }

    private RuleMatch makeRuleMatch(int fromPos, int toPos) {
        return new RuleMatch(null, fromPos, toPos, "FakeMatch1");
    }
}

