/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.XMLValidator;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternTestTools;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RegexPatternRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class PatternRuleTest
extends TestCase {
    private static final boolean CHECK_WITH_SENTENCE_SPLITTING = false;
    private static final Pattern PATTERN_MARKER_START = Pattern.compile(".*<pattern[^>]*>\\s*<marker>.*", 32);
    private static final Pattern PATTERN_MARKER_END = Pattern.compile(".*</marker>\\s*</pattern>.*", 32);

    public void testFake() {
    }

    public void testSupportsLanguage() {
        FakeLanguage fakeLanguage1 = new FakeLanguage("yy");
        FakeLanguage fakeLanguage2 = new FakeLanguage("zz");
        PatternRule patternRule1 = new PatternRule("ID", (Language)fakeLanguage1, Collections.emptyList(), "", "", "");
        PatternRuleTest.assertTrue((boolean)patternRule1.supportsLanguage((Language)fakeLanguage1));
        PatternRuleTest.assertFalse((boolean)patternRule1.supportsLanguage((Language)fakeLanguage2));
        FakeLanguage fakeLanguage1WithVariant1 = new FakeLanguage("zz", "VAR1");
        FakeLanguage fakeLanguage1WithVariant2 = new FakeLanguage("zz", "VAR2");
        PatternRule patternRuleVariant1 = new PatternRule("ID", (Language)fakeLanguage1WithVariant1, Collections.emptyList(), "", "", "");
        PatternRuleTest.assertTrue((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1WithVariant1));
        PatternRuleTest.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1));
        PatternRuleTest.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage2));
        PatternRuleTest.assertFalse((boolean)patternRuleVariant1.supportsLanguage((Language)fakeLanguage1WithVariant2));
    }

    protected void runGrammarRulesFromXmlTest(Language ignoredLanguage) throws IOException {
        int count = 0;
        for (Language lang : Languages.get()) {
            if (ignoredLanguage.getShortNameWithCountryAndVariant().equals(lang.getShortNameWithCountryAndVariant())) continue;
            this.runGrammarRuleForLanguage(lang);
            ++count;
        }
        if (count == 0) {
            System.err.println("Warning: no languages found in classpath - cannot run any grammar rule tests");
        }
    }

    protected void runGrammarRulesFromXmlTest() throws IOException {
        for (Language lang : Languages.get()) {
            this.runGrammarRuleForLanguage(lang);
        }
        if (Languages.get().size() == 0) {
            System.err.println("Warning: no languages found in classpath - cannot run any grammar rule tests");
        }
    }

    private void runGrammarRuleForLanguage(Language lang) throws IOException {
        if (this.skipCountryVariant(lang)) {
            System.out.println("Skipping " + lang + " because there are no specific rules for that variant");
            return;
        }
        this.runTestForLanguage(lang);
    }

    private boolean skipCountryVariant(Language lang) {
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        boolean hasGrammarFiles = false;
        for (String grammarFile : this.getGrammarFileNames(lang)) {
            if (!dataBroker.ruleFileExists(grammarFile)) continue;
            hasGrammarFiles = true;
        }
        return !hasGrammarFiles && Languages.get().size() > 1;
    }

    private List<String> getGrammarFileNames(Language lang) {
        String shortNameWithVariant = lang.getShortNameWithCountryAndVariant();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String ruleFile : lang.getRuleFileNames()) {
            String nameOnly = new File(ruleFile).getName();
            String fileName = shortNameWithVariant.contains("-x-") ? lang.getShortName() + "/" + nameOnly : (shortNameWithVariant.contains("-") && !shortNameWithVariant.equals("xx-XX") && !shortNameWithVariant.endsWith("-ANY") && Languages.get().size() > 1 ? lang.getShortName() + "/" + shortNameWithVariant + "/" + nameOnly : lang.getShortName() + "/" + nameOnly);
            if (fileNames.contains(fileName)) continue;
            fileNames.add(fileName);
        }
        return fileNames;
    }

    private void runGrammarRulesFromXmlTestIgnoringLanguages(Set<Language> ignoredLanguages) throws IOException {
        System.out.println("Known languages: " + Languages.getWithDemoLanguage());
        for (Language lang : Languages.getWithDemoLanguage()) {
            if (ignoredLanguages != null && ignoredLanguages.contains(lang)) continue;
            this.runTestForLanguage(lang);
        }
    }

    public void runTestForLanguage(Language lang) throws IOException {
        this.validatePatternFile(lang);
        System.out.print("Running pattern rule tests for " + lang.getName() + "... ");
        MultiThreadedJLanguageTool languageTool = new MultiThreadedJLanguageTool(lang);
        MultiThreadedJLanguageTool allRulesLanguageTool = new MultiThreadedJLanguageTool(lang);
        this.validateRuleIds(lang, (JLanguageTool)allRulesLanguageTool);
        ArrayList<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
        for (String patternRuleFileName : lang.getRuleFileNames()) {
            rules.addAll(languageTool.loadPatternRules(patternRuleFileName));
        }
        for (AbstractPatternRule rule : rules) {
            PatternTestTools.warnIfRegexpSyntaxNotKosher(rule.getPatternTokens(), rule.getId(), rule.getSubId(), lang);
            List antiPatterns = rule.getAntiPatterns();
            for (DisambiguationPatternRule antiPattern : antiPatterns) {
                PatternTestTools.warnIfRegexpSyntaxNotKosher(antiPattern.getPatternTokens(), antiPattern.getId(), antiPattern.getSubId(), lang);
            }
            if (rule.getCorrectExamples().size() != 0) continue;
            boolean correctionExists = false;
            for (IncorrectExample incorrectExample : rule.getIncorrectExamples()) {
                if (incorrectExample.getCorrections().size() <= 0) continue;
                correctionExists = true;
                break;
            }
            if (correctionExists) continue;
            PatternRuleTest.fail((String)("Rule " + rule.getFullId() + " in language " + lang + " needs at least one <example> with a 'correction' attribute" + " or one <example> of type='correct'."));
        }
        this.testGrammarRulesFromXML(rules, (JLanguageTool)languageTool, (JLanguageTool)allRulesLanguageTool, lang);
        System.out.println(rules.size() + " rules tested.");
        allRulesLanguageTool.shutdown();
        languageTool.shutdown();
    }

    private void validatePatternFile(Language lang) throws IOException {
        XMLValidator validator = new XMLValidator();
        List<String> grammarFiles = this.getGrammarFileNames(lang);
        for (String grammarFile : grammarFiles) {
            System.out.println("Running XML validation for " + grammarFile + "...");
            String rulesDir = JLanguageTool.getDataBroker().getRulesDir();
            String ruleFilePath = rulesDir + "/" + grammarFile;
            InputStream xmlStream = ((Object)((Object)this)).getClass().getResourceAsStream(ruleFilePath);
            Throwable throwable = null;
            try {
                if (xmlStream == null) {
                    System.out.println("No rule file found at " + ruleFilePath + " in classpath");
                    continue;
                }
                if (grammarFiles.size() > 1 && !grammarFiles.get(0).equals(grammarFile)) {
                    validator.validateWithXmlSchema(rulesDir + "/" + grammarFiles.get(0), ruleFilePath, rulesDir + "/rules.xsd");
                    continue;
                }
                validator.validateWithXmlSchema(ruleFilePath, rulesDir + "/rules.xsd");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (xmlStream == null) continue;
                if (throwable != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                xmlStream.close();
            }
        }
    }

    private void validateRuleIds(Language lang, JLanguageTool languageTool) {
        List allRules = languageTool.getAllRules();
        HashSet<String> ids = new HashSet<String>();
        HashSet<Class> ruleClasses = new HashSet<Class>();
        for (Rule rule : allRules) {
            this.assertIdUniqueness(ids, ruleClasses, lang, rule);
            if (!rule.getId().equalsIgnoreCase("ID")) continue;
            System.err.println("WARNING: " + lang.getShortNameWithCountryAndVariant() + " has a rule with id 'ID', this should probably be changed");
        }
    }

    private void assertIdUniqueness(Set<String> ids, Set<Class> ruleClasses, Language language, Rule rule) {
        String ruleId = rule.getId();
        if (ids.contains(ruleId) && !ruleClasses.contains(rule.getClass())) {
            throw new RuntimeException("Rule id occurs more than once: '" + ruleId + "', language: " + language);
        }
        ids.add(ruleId);
        ruleClasses.add(rule.getClass());
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allRules = languageTool.getAllRules();
        for (Rule rule : allRules) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            languageTool.disableRule(rule.getId());
        }
    }

    public void testGrammarRulesFromXML(List<AbstractPatternRule> rules, JLanguageTool languageTool, JLanguageTool allRulesLanguageTool, Language lang) throws IOException {
        HashMap<String, AbstractPatternRule> complexRules = new HashMap<String, AbstractPatternRule>();
        for (AbstractPatternRule rule : rules) {
            this.testCorrectSentences(languageTool, allRulesLanguageTool, lang, rule);
            this.testBadSentences(languageTool, allRulesLanguageTool, lang, complexRules, rule);
        }
        if (!complexRules.isEmpty()) {
            Set set = complexRules.keySet();
            ArrayList<AbstractPatternRule> badRules = new ArrayList<AbstractPatternRule>();
            for (String aSet : set) {
                AbstractPatternRule badRule = (AbstractPatternRule)complexRules.get(aSet);
                if (badRule == null || !(badRule instanceof PatternRule)) continue;
                ((PatternRule)badRule).notComplexPhrase();
                badRule.setMessage("The rule contains a phrase that never matched any incorrect example.");
                badRules.add(badRule);
            }
            if (!badRules.isEmpty()) {
                this.testGrammarRulesFromXML(badRules, languageTool, allRulesLanguageTool, lang);
            }
        }
    }

    private void testBadSentences(JLanguageTool languageTool, JLanguageTool allRulesLanguageTool, Language lang, Map<String, AbstractPatternRule> complexRules, AbstractPatternRule rule) throws IOException {
        List badSentences = rule.getIncorrectExamples();
        if (badSentences.size() == 0) {
            PatternRuleTest.fail((String)("No incorrect examples found for rule " + rule.getFullId()));
        }
        List rules = allRulesLanguageTool.getPatternRulesByIdAndSubId(rule.getId(), rule.getSubId());
        for (IncorrectExample origBadExample : badSentences) {
            String badSentence;
            String origBadSentence = origBadExample.getExample().replaceAll("[\\n\\t]+", "");
            List expectedCorrections = origBadExample.getCorrections();
            int expectedMatchStart = origBadSentence.indexOf("<marker>");
            int expectedMatchEnd = origBadSentence.indexOf("</marker>") - "<marker>".length();
            if (expectedMatchStart == -1 || expectedMatchEnd == -1) {
                PatternRuleTest.fail((String)(lang + ": No error position markup ('<marker>...</marker>') in bad example in rule " + rule.getFullId()));
            }
            PatternRuleTest.assertTrue(((badSentence = this.cleanXML(origBadSentence)).trim().length() > 0 ? 1 : 0) != 0);
            List<Object> matches = new ArrayList<RuleMatch>();
            for (Rule auxRule : rules) {
                matches.addAll(this.getMatches(auxRule, badSentence, languageTool));
            }
            if (rule instanceof RegexPatternRule || rule instanceof PatternRule && !((PatternRule)rule).isWithComplexPhrase()) {
                if (matches.size() != 1) {
                    AnalyzedSentence analyzedSentence = languageTool.getAnalyzedSentence(badSentence);
                    StringBuilder sb = new StringBuilder("Analyzed token readings:");
                    for (AnalyzedTokenReadings atr : analyzedSentence.getTokens()) {
                        sb.append(" ").append(atr);
                    }
                    String info = "";
                    if (rule instanceof RegexPatternRule) {
                        info = "\nRegexp: " + ((RegexPatternRule)rule).getPattern().toString();
                    }
                    PatternRuleTest.fail((String)(lang + " rule " + rule.getFullId() + ":\n\"" + badSentence + "\"\n" + "Errors expected: 1\n" + "Errors found   : " + matches.size() + "\n" + "Message: " + rule.getMessage() + "\n" + sb + "\nMatches: " + matches + info));
                }
                PatternRuleTest.assertEquals((String)(lang + ": Incorrect match position markup (start) for rule " + rule.getFullId() + ", sentence: " + badSentence), (int)expectedMatchStart, (int)((RuleMatch)matches.get(0)).getFromPos());
                PatternRuleTest.assertEquals((String)(lang + ": Incorrect match position markup (end) for rule " + rule.getFullId() + ", sentence: " + badSentence), (int)expectedMatchEnd, (int)((RuleMatch)matches.get(0)).getToPos());
                this.assertSuggestions(badSentence, lang, expectedCorrections, rule, matches);
                if (((RuleMatch)matches.get(0)).getSuggestedReplacements().size() <= 0) continue;
                int fromPos = ((RuleMatch)matches.get(0)).getFromPos();
                int toPos = ((RuleMatch)matches.get(0)).getToPos();
                for (String replacement : ((RuleMatch)matches.get(0)).getSuggestedReplacements()) {
                    String fixedSentence = badSentence.substring(0, fromPos) + replacement + badSentence.substring(toPos);
                    matches = this.getMatches((Rule)rule, fixedSentence, languageTool);
                    if (matches.size() <= 0) continue;
                    PatternRuleTest.fail((String)("Incorrect input:\n  " + badSentence + "\nCorrected sentence:\n" + "  " + fixedSentence + "\nBy Rule:\n" + "  " + rule.getFullId() + "\nThe correction triggered an error itself:\n" + "  " + matches.get(0) + "\n"));
                }
                continue;
            }
            matches = this.getMatches((Rule)rule, badSentence, languageTool);
            if (matches.size() == 0 && !complexRules.containsKey(rule.getId() + badSentence)) {
                complexRules.put(rule.getId() + badSentence, rule);
            }
            if (matches.size() == 0) continue;
            complexRules.put(rule.getId() + badSentence, null);
            PatternRuleTest.assertTrue((String)(lang + ": Did expect one error in: \"" + badSentence + "\" (Rule: " + rule.getFullId() + "), got " + matches.size()), (matches.size() == 1 ? 1 : 0) != 0);
            PatternRuleTest.assertEquals((String)(lang + ": Incorrect match position markup (start) for rule " + rule.getFullId()), (int)expectedMatchStart, (int)((RuleMatch)matches.get(0)).getFromPos());
            PatternRuleTest.assertEquals((String)(lang + ": Incorrect match position markup (end) for rule " + rule.getFullId()), (int)expectedMatchEnd, (int)((RuleMatch)matches.get(0)).getToPos());
            this.assertSuggestions(badSentence, lang, expectedCorrections, rule, matches);
            this.assertSuggestionsDoNotCreateErrors(badSentence, languageTool, rule, matches);
        }
    }

    private boolean rangeIsOverlapping(int a, int b, int x, int y) {
        if (a < x) {
            return x <= b;
        }
        return a <= y;
    }

    private void assertSuggestions(String sentence, Language lang, List<String> expectedCorrections, AbstractPatternRule rule, List<RuleMatch> matches) {
        if (expectedCorrections != null && expectedCorrections.size() > 0) {
            List realSuggestions;
            boolean expectedNonEmptyCorrection;
            boolean bl = expectedNonEmptyCorrection = expectedCorrections.get(0).length() > 0;
            if (expectedNonEmptyCorrection) {
                PatternRuleTest.assertTrue((String)("You specified a correction but your message has no suggestions in rule " + rule.getFullId()), (rule.getMessage().contains("<suggestion>") || rule.getSuggestionsOutMsg().contains("<suggestion>") ? 1 : 0) != 0);
            }
            if ((realSuggestions = matches.get(0).getSuggestedReplacements()).size() == 0) {
                boolean expectedEmptyCorrection = expectedCorrections.size() == 1 && expectedCorrections.get(0).length() == 0;
                PatternRuleTest.assertTrue((String)(lang + ": Incorrect suggestions: " + expectedCorrections + " != " + " <no suggestion> for rule " + rule.getFullId() + " on input: " + sentence), (boolean)expectedEmptyCorrection);
            } else {
                PatternRuleTest.assertEquals((String)(lang + ": Incorrect suggestions: " + expectedCorrections + " != " + realSuggestions + " for rule " + rule.getFullId() + " on input: " + sentence), expectedCorrections, (Object)realSuggestions);
            }
        }
    }

    private void assertSuggestionsDoNotCreateErrors(String badSentence, JLanguageTool languageTool, AbstractPatternRule rule, List<RuleMatch> matches) throws IOException {
        if (matches.get(0).getSuggestedReplacements().size() > 0) {
            int fromPos = matches.get(0).getFromPos();
            int toPos = matches.get(0).getToPos();
            for (String replacement : matches.get(0).getSuggestedReplacements()) {
                String fixedSentence = badSentence.substring(0, fromPos) + replacement + badSentence.substring(toPos);
                List<RuleMatch> tempMatches = this.getMatches((Rule)rule, fixedSentence, languageTool);
                PatternRuleTest.assertEquals((String)("Corrected sentence for rule " + rule.getFullId() + " triggered error: " + fixedSentence), (int)0, (int)tempMatches.size());
            }
        }
    }

    private void testCorrectSentences(JLanguageTool languageTool, JLanguageTool allRulesLanguageTool, Language lang, AbstractPatternRule rule) throws IOException {
        List goodSentences = rule.getCorrectExamples();
        List rules = allRulesLanguageTool.getPatternRulesByIdAndSubId(rule.getId(), rule.getSubId());
        for (String goodSentence : goodSentences) {
            goodSentence = goodSentence.replaceAll("[\\n\\t]+", "");
            goodSentence = this.cleanXML(goodSentence);
            PatternRuleTest.assertTrue((String)(lang + ": Empty correct example in rule " + rule.getFullId()), (goodSentence.trim().length() > 0 ? 1 : 0) != 0);
            boolean isMatched = false;
            for (Rule auxRule : rules) {
                isMatched = isMatched || this.match(auxRule, goodSentence, languageTool);
            }
            PatternRuleTest.assertFalse((String)(lang + ": Did not expect error in:\n" + "  " + goodSentence + "\n" + "Matching Rule: " + rule.getFullId()), (boolean)isMatched);
        }
    }

    protected String cleanXML(String str) {
        return str.replaceAll("<([^<].*?)>", "");
    }

    private boolean match(Rule rule, String sentence, JLanguageTool languageTool) throws IOException {
        AnalyzedSentence analyzedSentence = languageTool.getAnalyzedSentence(sentence);
        RuleMatch[] matches = rule.match(analyzedSentence);
        return matches.length > 0;
    }

    private List<RuleMatch> getMatches(Rule rule, String sentence, JLanguageTool languageTool) throws IOException {
        AnalyzedSentence analyzedSentence = languageTool.getAnalyzedSentence(sentence);
        RuleMatch[] matches = rule.match(analyzedSentence);
        return Arrays.asList(matches);
    }

    protected PatternRule makePatternRule(String s, boolean caseSensitive, boolean regex) {
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        String[] parts = s.split(" ");
        boolean pos = false;
        for (String element : parts) {
            if (element.equals("SENT_START")) {
                pos = true;
            }
            PatternToken pToken = !pos ? new PatternToken(element, caseSensitive, regex, false) : new PatternToken("", caseSensitive, regex, false);
            if (pos) {
                pToken.setPosToken(new PatternToken.PosToken(element, false, false));
            }
            patternTokens.add(pToken);
            pos = false;
        }
        PatternRule rule = new PatternRule("ID1", TestTools.getDemoLanguage(), patternTokens, "test rule", "user visible message", "short comment");
        return rule;
    }

    public static void main(String[] args) throws IOException {
        PatternRuleTest test = new PatternRuleTest();
        System.out.println("Running XML pattern tests...");
        if (args.length == 0) {
            test.runGrammarRulesFromXmlTestIgnoringLanguages(null);
        } else {
            Set<Language> ignoredLanguages = TestTools.getLanguagesExcept(args);
            test.runGrammarRulesFromXmlTestIgnoringLanguages(ignoredLanguages);
        }
        System.out.println("Tests finished!");
    }
}

