/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

public class SDCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private SentenceDetectorEvaluationMonitor[] listeners;
    private SentenceDetectorFactory sdFactory;

    public SDCrossValidator(String languageCode, TrainingParameters params, SentenceDetectorFactory sdFactory, SentenceDetectorEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = params;
        this.listeners = listeners;
        this.sdFactory = sdFactory;
    }

    public SDCrossValidator(String languageCode, TrainingParameters params) {
        this(languageCode, params, new SentenceDetectorFactory(languageCode, true, null, null), new SentenceDetectorEvaluationMonitor[0]);
    }

    public SDCrossValidator(String languageCode, TrainingParameters params, SentenceDetectorEvaluationMonitor ... listeners) {
        this(languageCode, params, new SentenceDetectorFactory(languageCode, true, null, null), listeners);
    }

    public SDCrossValidator(String languageCode) {
        this(languageCode, ModelUtil.createDefaultTrainingParameters());
    }

    public void evaluate(ObjectStream<SentenceSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<SentenceSample> partitioner = new CrossValidationPartitioner<SentenceSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<SentenceSample> trainingSampleStream = partitioner.next();
            SentenceModel model = SentenceDetectorME.train(this.languageCode, trainingSampleStream, this.sdFactory, this.params);
            SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

