/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;

class LanguageComboBoxRenderer
extends JLabel
implements ListCellRenderer<Language> {
    private static final Border BORDER = new EmptyBorder(1, 3, 1, 1);
    private final ResourceBundle messages;
    private final String extLangSuffix;

    LanguageComboBoxRenderer(ResourceBundle messages, String extLangSuffix) {
        this.setOpaque(true);
        this.setBorder(BORDER);
        this.messages = messages;
        this.extLangSuffix = extLangSuffix;
    }

    private String getTranslatedName(Language language) {
        if (language.isExternal()) {
            return language.getName() + this.extLangSuffix;
        }
        return language.getTranslatedName(this.messages);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Language lang, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setText(this.getTranslatedName(lang));
        String langTag = lang.getLocaleWithCountryAndVariant().toLanguageTag();
        String country = lang.getLocaleWithCountryAndVariant().getCountry().toLowerCase();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String filename = "flags/bytag/" + langTag + ".png";
        if (!dataBroker.resourceExists(filename)) {
            filename = "flags/" + country + ".png";
        }
        if (!dataBroker.resourceExists(filename)) {
            filename = "flags/empty.png";
        }
        ImageIcon icon = new ImageIcon(dataBroker.getFromResourceDirAsUrl(filename));
        this.setIcon(icon);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(BORDER);
        return this;
    }
}

