/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import java.io.File;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.validation.constraint.FileExtension;

public class FileExtensionValidator
implements ConstraintValidator<FileExtension, File> {
    private String expectedExtension;

    @Override
    public void initialize(FileExtension constraintAnnotation) {
        this.expectedExtension = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(File value, ConstraintValidatorContext context) {
        if (value != null && value.isFile()) {
            String extension = FilenameUtils.getExtension(value.getName());
            return StringUtils.equalsIgnoreCase(this.expectedExtension, extension) && FilenameUtils.indexOfExtension(value.getName()) > 0;
        }
        return true;
    }
}

