/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.AESEncryptionAlgorithmEngine;
import org.sejda.sambox.encryption.AESEngineNoPadding;
import org.sejda.sambox.encryption.Algorithm2AHash;
import org.sejda.sambox.encryption.MessageDigests;

class Algorithm2B
implements Algorithm2AHash {
    private static final BigInteger THREE = new BigInteger("3");
    private static final Map<Integer, MessageDigest> HASHES = new HashMap<Integer, MessageDigest>();
    private AESEncryptionAlgorithmEngine aes128 = AESEngineNoPadding.cbc();
    private final byte[] u;

    Algorithm2B(byte[] u) {
        this.u = Optional.ofNullable(u).orElse(new byte[0]);
    }

    Algorithm2B() {
        this.u = new byte[0];
    }

    @Override
    public byte[] computeHash(byte[] input, byte[] password) {
        byte[] k = Arrays.copyOf(HASHES.get(0).digest(input), 32);
        byte[] e = new byte[]{};
        for (int round = 0; round < 64 || (e[e.length - 1] & 0xFF) > round - 32; ++round) {
            byte[] k1Element = Arrays.concatenate(password, k, this.u);
            byte[] k1 = new byte[]{};
            for (int i = 0; i < 64; ++i) {
                k1 = Arrays.concatenate(k1, k1Element);
            }
            e = this.aes128.encryptBytes(k1, Arrays.copyOf(k, 16), Arrays.copyOfRange(k, 16, 32));
            k = HASHES.get(new BigInteger(1, Arrays.copyOf(e, 16)).mod(THREE).intValue()).digest(e);
        }
        return Arrays.copyOf(k, 32);
    }

    static {
        HASHES.put(0, MessageDigests.sha256());
        HASHES.put(1, MessageDigests.sha384());
        HASHES.put(2, MessageDigests.sha512());
    }
}

