/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.Selector;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.AddElement;
import com.baselet.gui.listener.GridElementListener;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PaletteEntityListener
extends GridElementListener {
    Map<GridElement, Rectangle> previousDraggingLocation = new Hashtable<GridElement, Rectangle>();
    private static HashMap<DiagramHandler, PaletteEntityListener> entitylistener = new HashMap();
    private Vector<GridElement> copiedEntities = new Vector();

    public static PaletteEntityListener getInstance(DiagramHandler handler) {
        if (!entitylistener.containsKey(handler)) {
            entitylistener.put(handler, new PaletteEntityListener(handler));
        }
        return entitylistener.get(handler);
    }

    protected PaletteEntityListener(DiagramHandler handler) {
        super(handler);
    }

    @Override
    public void mouseDoubleClicked(GridElement me) {
        this.selector.deselectAll();
        this.copyEntity(me);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        List<GridElement> selectedEntities = this.handler.getDrawPanel().getSelector().getSelectedElements();
        for (GridElement currentEntity : selectedEntities) {
            if (!this.IS_DRAGGING) continue;
            this.previousDraggingLocation.put(currentEntity, currentEntity.getRectangle());
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        super.mouseDragged(me);
        GridElement entity = this.handler.getDrawPanel().getElementToComponent(me.getComponent());
        if (this.IS_DRAGGED_FROM_PALETTE) {
            this.moveDraggedEntities();
        } else if (entity.getRectangle().x + entity.getRectangle().width <= 0) {
            this.resetEntities();
            this.insertDraggedEntities(me);
            this.handler.getDrawPanel().getSelector().deselectAllWithoutUpdatePropertyPanel();
        }
    }

    private void moveDraggedEntities() {
        for (GridElement copiedEntity : this.copiedEntities) {
            int x = this.getNewCoordinate().x - this.getOldCoordinate().x;
            int y = this.getNewCoordinate().y - this.getOldCoordinate().y;
            x = CurrentDiagram.getInstance().getDiagramHandler().realignToGrid(false, x);
            y = CurrentDiagram.getInstance().getDiagramHandler().realignToGrid(false, y);
            copiedEntity.setLocationDifference(x, y);
        }
    }

    private void resetEntities() {
        List<GridElement> selectedEntities = this.handler.getDrawPanel().getSelector().getSelectedElements();
        for (GridElement currentEntity : selectedEntities) {
            Rectangle previousLocation = this.previousDraggingLocation.get(currentEntity);
            currentEntity.setLocation(previousLocation.x, previousLocation.y);
        }
    }

    private void insertDraggedEntities(MouseEvent me) {
        GridElement entity = this.handler.getDrawPanel().getElementToComponent(me.getComponent());
        DrawPanel currentDiagram = CurrentGui.getInstance().getGui().getCurrentDiagram();
        List<GridElement> selectedEntities = this.handler.getDrawPanel().getSelector().getSelectedElements();
        if (!this.allowCopyEntity()) {
            return;
        }
        this.copiedEntities.clear();
        int oldZoomDiagram = currentDiagram.getHandler().getGridSize();
        int oldZoomPalette = this.handler.getGridSize();
        currentDiagram.getHandler().setGridAndZoom(10, false);
        this.handler.setGridAndZoom(10, false);
        this.IS_DRAGGING = false;
        this.IS_DRAGGED_FROM_PALETTE = true;
        for (GridElement currentEntity : selectedEntities) {
            GridElement copiedEntity = this.copyEntity(currentEntity);
            this.copiedEntities.add(copiedEntity);
            int x = currentEntity.getRectangle().x - entity.getRectangle().x;
            int y = currentEntity.getRectangle().y - entity.getRectangle().y;
            copiedEntity.setLocation(x -= entity.getRectangle().width / 2, y -= entity.getRectangle().height / 2);
        }
        Selector.replaceGroupsWithNewGroups(this.copiedEntities, (Selector)this.selector);
        currentDiagram.getHandler().setGridAndZoom(oldZoomDiagram, false);
        this.handler.setGridAndZoom(oldZoomPalette, false);
        this.updateEntityPositions(me);
    }

    private void updateEntityPositions(MouseEvent me) {
        DiagramHandler currentHandler = CurrentDiagram.getInstance().getDiagramHandler();
        Point mousePosition = me.getLocationOnScreen();
        int mouseX = mousePosition.x - currentHandler.getDrawPanel().getLocationOnScreen().x;
        int mouseY = mousePosition.y - currentHandler.getDrawPanel().getLocationOnScreen().y;
        for (GridElement copiedEntity : this.copiedEntities) {
            int x = copiedEntity.getRectangle().x;
            int y = copiedEntity.getRectangle().y;
            x += mouseX;
            y += mouseY;
            x = CurrentDiagram.getInstance().getDiagramHandler().realignToGrid(false, x);
            y = CurrentDiagram.getInstance().getDiagramHandler().realignToGrid(false, y);
            copiedEntity.setLocation(x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        super.mouseReleased(me);
        CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().updatePanelAndScrollbars();
    }

    protected boolean allowCopyEntity() {
        return true;
    }

    protected GridElement copyEntity(GridElement me) {
        DrawPanel currentDiagram = CurrentGui.getInstance().getGui().getCurrentDiagram();
        int oldZoomDiagram = currentDiagram.getHandler().getGridSize();
        int oldZoomPalette = this.handler.getGridSize();
        currentDiagram.getHandler().setGridAndZoom(10, false);
        this.handler.setGridAndZoom(10, false);
        GridElement e = ElementFactorySwing.createCopy(me);
        e.setProperty("group", null);
        Point viewp = currentDiagram.getScrollPane().getViewport().getViewPosition();
        int upperLeftX = (int)(viewp.getX() - viewp.getX() % (double)oldZoomDiagram);
        int upperLeftY = (int)(viewp.getY() - viewp.getY() % (double)oldZoomDiagram);
        AddElement cmd = new AddElement(e, this.handler.realignToGrid((upperLeftX / oldZoomDiagram + 2) * 10), this.handler.realignToGrid((upperLeftY / oldZoomDiagram + 2) * 10));
        currentDiagram.getHandler().getController().executeCommand(cmd);
        currentDiagram.getSelector().selectOnly(e);
        currentDiagram.getHandler().setGridAndZoom(oldZoomDiagram, false);
        this.handler.setGridAndZoom(oldZoomPalette, false);
        return e;
    }
}

