/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import java.util.HashMap;
import java.util.Map;

public class Continuation
implements LifelineSpanningTickSpanningOccurrence {
    private static final double ROUND_PART_WIDTH = 20.0;
    private static final double VERTICAL_BORDER_PADDING = 5.0;
    private final int tick;
    private final String[] textLines;
    private final Lifeline[] coveredLifelines;

    public Continuation(int tick, String text, Lifeline[] coveredLifelines) {
        this(tick, text.split("\n"), coveredLifelines);
    }

    public Continuation(int tick, String[] textLines, Lifeline[] coveredLifelines) {
        this.tick = tick;
        this.textLines = textLines;
        this.coveredLifelines = coveredLifelines;
    }

    @Override
    public Lifeline getFirstLifeline() {
        return this.coveredLifelines[0];
    }

    @Override
    public Lifeline getLastLifeline() {
        return this.coveredLifelines[this.coveredLifelines.length - 1];
    }

    @Override
    public void draw(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        double width = drawingInfo.getSymmetricWidth(this.getFirstLifeline(), this.getLastLifeline(), this.tick);
        double height = TextSplitter.getSplitStringHeight(this.textLines, width - 40.0, drawHandler) + 10.0;
        double topY = drawingInfo.getVerticalStart(this.tick);
        double leftX = drawingInfo.getHDrawingInfo(this.getFirstLifeline()).getSymmetricHorizontalStart(this.tick);
        drawHandler.drawArc(leftX, topY += (drawingInfo.getTickHeight(this.tick) - height) / 2.0, 40.0, height, 90.0, 180.0, true);
        drawHandler.drawArc(leftX + (width -= 40.0), topY, 40.0, height, 270.0, 180.0, true);
        drawHandler.drawLine(leftX + 20.0, topY, leftX + width + 20.0, topY);
        drawHandler.drawLine(leftX + 20.0, topY + height, leftX + width + 20.0, topY + height);
        TextSplitter.drawText(drawHandler, this.textLines, leftX + 20.0, topY, width, height, AlignHorizontal.CENTER, AlignVertical.CENTER);
        for (Lifeline ll : this.coveredLifelines) {
            drawingInfo.getDrawingInfo(ll).addInterruptedArea(new Line1D(topY, topY + height));
        }
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        return TextSplitter.getTextMinWidth(this.textLines, drawHandler) + 40.0;
    }

    @Override
    public Map<Integer, Double> getEveryAdditionalYHeight(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight) {
        HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        double neededHeight = TextSplitter.getSplitStringHeight(this.textLines, hInfo.getSymmetricWidth(this.getFirstLifeline(), this.getLastLifeline(), this.tick) - 40.0, drawHandler) + 10.0;
        if (neededHeight > defaultTickHeight) {
            ret.put(this.tick, neededHeight - defaultTickHeight);
        }
        return ret;
    }

    @Override
    public LifelineSpanningTickSpanningOccurrence.ContainerPadding getPaddingInformation() {
        return null;
    }
}

