/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher.nio2;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.netbeans.modules.masterfs.providers.Notifier;

public class NioNotifier
extends Notifier<WatchKey> {
    private final WatchService watcher = FileSystems.getDefault().newWatchService();

    protected WatchKey addWatch(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        try {
            WatchKey watchKey = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            return watchKey;
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            throw new IOException(closedWatchServiceException);
        }
    }

    protected void removeWatch(WatchKey watchKey) throws IOException {
        try {
            watchKey.cancel();
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            throw new IOException(closedWatchServiceException);
        }
    }

    protected String nextEvent() throws IOException, InterruptedException {
        WatchKey watchKey;
        try {
            watchKey = this.watcher.take();
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            InterruptedException interruptedException = new InterruptedException();
            throw (InterruptedException)interruptedException.initCause(closedWatchServiceException);
        }
        Path path = (Path)watchKey.watchable();
        String string = path.toAbsolutePath().toString();
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            if (watchEvent.kind() != StandardWatchEventKinds.OVERFLOW) continue;
            string = null;
        }
        watchKey.reset();
        return string;
    }

    protected void start() throws IOException {
    }

    protected void stop() throws IOException {
        this.watcher.close();
    }
}

