/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkByScrollTask;

public class BulkIndexByScrollResponse
extends ActionResponse
implements ToXContent {
    private TimeValue took;
    private BulkByScrollTask.Status status;
    private List<BulkItemResponse.Failure> indexingFailures;
    private List<ShardSearchFailure> searchFailures;
    private boolean timedOut;

    public BulkIndexByScrollResponse() {
    }

    public BulkIndexByScrollResponse(TimeValue took, BulkByScrollTask.Status status, List<BulkItemResponse.Failure> indexingFailures, List<ShardSearchFailure> searchFailures, boolean timedOut) {
        this.took = took;
        this.status = Objects.requireNonNull(status, "Null status not supported");
        this.indexingFailures = indexingFailures;
        this.searchFailures = searchFailures;
        this.timedOut = timedOut;
    }

    public TimeValue getTook() {
        return this.took;
    }

    protected BulkByScrollTask.Status getStatus() {
        return this.status;
    }

    public long getUpdated() {
        return this.status.getUpdated();
    }

    public int getBatches() {
        return this.status.getBatches();
    }

    public long getVersionConflicts() {
        return this.status.getVersionConflicts();
    }

    public long getNoops() {
        return this.status.getNoops();
    }

    public String getReasonCancelled() {
        return this.status.getReasonCancelled();
    }

    public List<BulkItemResponse.Failure> getIndexingFailures() {
        return this.indexingFailures;
    }

    public List<ShardSearchFailure> getSearchFailures() {
        return this.searchFailures;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.took.writeTo(out);
        this.status.writeTo(out);
        out.writeVInt(this.indexingFailures.size());
        for (BulkItemResponse.Failure failure : this.indexingFailures) {
            failure.writeTo(out);
        }
        out.writeVInt(this.searchFailures.size());
        for (ShardSearchFailure shardSearchFailure : this.searchFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.took = TimeValue.readTimeValue((StreamInput)in);
        this.status = new BulkByScrollTask.Status(in);
        int indexingFailuresCount = in.readVInt();
        ArrayList<BulkItemResponse.Failure> indexingFailures = new ArrayList<BulkItemResponse.Failure>(indexingFailuresCount);
        for (int i = 0; i < indexingFailuresCount; ++i) {
            indexingFailures.add(BulkItemResponse.Failure.PROTOTYPE.readFrom(in));
        }
        this.indexingFailures = Collections.unmodifiableList(indexingFailures);
        int searchFailuresCount = in.readVInt();
        ArrayList<ShardSearchFailure> searchFailures = new ArrayList<ShardSearchFailure>(searchFailuresCount);
        for (int i = 0; i < searchFailuresCount; ++i) {
            searchFailures.add(ShardSearchFailure.readShardSearchFailure((StreamInput)in));
        }
        this.searchFailures = Collections.unmodifiableList(searchFailures);
        this.timedOut = in.readBoolean();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("took", this.took.millis());
        builder.field("timed_out", this.timedOut);
        this.status.innerXContent(builder, params, false, false);
        builder.startArray("failures");
        for (BulkItemResponse.Failure failure : this.indexingFailures) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        for (ShardSearchFailure shardSearchFailure : this.searchFailures) {
            builder.startObject();
            shardSearchFailure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BulkIndexByScrollResponse[");
        builder.append("took=").append(this.took).append(',');
        this.status.innerToString(builder, false, false);
        builder.append(",indexing_failures=").append(this.getIndexingFailures().subList(0, Math.min(3, this.getIndexingFailures().size())));
        builder.append(",search_failures=").append(this.getSearchFailures().subList(0, Math.min(3, this.getSearchFailures().size())));
        return builder.append(']').toString();
    }
}

