/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class SegmentsStats
implements Streamable,
ToXContent {
    private long count;
    private long memoryInBytes;
    private long termsMemoryInBytes;
    private long storedFieldsMemoryInBytes;
    private long termVectorsMemoryInBytes;
    private long normsMemoryInBytes;
    private long docValuesMemoryInBytes;
    private long indexWriterMemoryInBytes;
    private long indexWriterMaxMemoryInBytes;
    private long versionMapMemoryInBytes;
    private long bitsetMemoryInBytes;

    public void add(long count, long memoryInBytes) {
        this.count += count;
        this.memoryInBytes += memoryInBytes;
    }

    public void addTermsMemoryInBytes(long termsMemoryInBytes) {
        this.termsMemoryInBytes += termsMemoryInBytes;
    }

    public void addStoredFieldsMemoryInBytes(long storedFieldsMemoryInBytes) {
        this.storedFieldsMemoryInBytes += storedFieldsMemoryInBytes;
    }

    public void addTermVectorsMemoryInBytes(long termVectorsMemoryInBytes) {
        this.termVectorsMemoryInBytes += termVectorsMemoryInBytes;
    }

    public void addNormsMemoryInBytes(long normsMemoryInBytes) {
        this.normsMemoryInBytes += normsMemoryInBytes;
    }

    public void addDocValuesMemoryInBytes(long docValuesMemoryInBytes) {
        this.docValuesMemoryInBytes += docValuesMemoryInBytes;
    }

    public void addIndexWriterMemoryInBytes(long indexWriterMemoryInBytes) {
        this.indexWriterMemoryInBytes += indexWriterMemoryInBytes;
    }

    public void addIndexWriterMaxMemoryInBytes(long indexWriterMaxMemoryInBytes) {
        this.indexWriterMaxMemoryInBytes += indexWriterMaxMemoryInBytes;
    }

    public void addVersionMapMemoryInBytes(long versionMapMemoryInBytes) {
        this.versionMapMemoryInBytes += versionMapMemoryInBytes;
    }

    public void addBitsetMemoryInBytes(long bitsetMemoryInBytes) {
        this.bitsetMemoryInBytes += bitsetMemoryInBytes;
    }

    public void add(SegmentsStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.add(mergeStats.count, mergeStats.memoryInBytes);
        this.addTermsMemoryInBytes(mergeStats.termsMemoryInBytes);
        this.addStoredFieldsMemoryInBytes(mergeStats.storedFieldsMemoryInBytes);
        this.addTermVectorsMemoryInBytes(mergeStats.termVectorsMemoryInBytes);
        this.addNormsMemoryInBytes(mergeStats.normsMemoryInBytes);
        this.addDocValuesMemoryInBytes(mergeStats.docValuesMemoryInBytes);
        this.addIndexWriterMemoryInBytes(mergeStats.indexWriterMemoryInBytes);
        this.addIndexWriterMaxMemoryInBytes(mergeStats.indexWriterMaxMemoryInBytes);
        this.addVersionMapMemoryInBytes(mergeStats.versionMapMemoryInBytes);
        this.addBitsetMemoryInBytes(mergeStats.bitsetMemoryInBytes);
    }

    public long getCount() {
        return this.count;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public ByteSizeValue getMemory() {
        return new ByteSizeValue(this.memoryInBytes);
    }

    public long getTermsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    public ByteSizeValue getTermsMemory() {
        return new ByteSizeValue(this.termsMemoryInBytes);
    }

    public long getStoredFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    public ByteSizeValue getStoredFieldsMemory() {
        return new ByteSizeValue(this.storedFieldsMemoryInBytes);
    }

    public long getTermVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    public ByteSizeValue getTermVectorsMemory() {
        return new ByteSizeValue(this.termVectorsMemoryInBytes);
    }

    public long getNormsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    public ByteSizeValue getNormsMemory() {
        return new ByteSizeValue(this.normsMemoryInBytes);
    }

    public long getDocValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    public ByteSizeValue getDocValuesMemory() {
        return new ByteSizeValue(this.docValuesMemoryInBytes);
    }

    public long getIndexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMemory() {
        return new ByteSizeValue(this.indexWriterMemoryInBytes);
    }

    public long getIndexWriterMaxMemoryInBytes() {
        return this.indexWriterMaxMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMaxMemory() {
        return new ByteSizeValue(this.indexWriterMaxMemoryInBytes);
    }

    public long getVersionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    public ByteSizeValue getVersionMapMemory() {
        return new ByteSizeValue(this.versionMapMemoryInBytes);
    }

    public long getBitsetMemoryInBytes() {
        return this.bitsetMemoryInBytes;
    }

    public ByteSizeValue getBitsetMemory() {
        return new ByteSizeValue(this.bitsetMemoryInBytes);
    }

    public static SegmentsStats readSegmentsStats(StreamInput in) throws IOException {
        SegmentsStats stats = new SegmentsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SEGMENTS);
        builder.field(Fields.COUNT, this.count);
        builder.byteSizeField(Fields.MEMORY_IN_BYTES, Fields.MEMORY, this.memoryInBytes);
        builder.byteSizeField(Fields.TERMS_MEMORY_IN_BYTES, Fields.TERMS_MEMORY, this.termsMemoryInBytes);
        builder.byteSizeField(Fields.STORED_FIELDS_MEMORY_IN_BYTES, Fields.STORED_FIELDS_MEMORY, this.storedFieldsMemoryInBytes);
        builder.byteSizeField(Fields.TERM_VECTORS_MEMORY_IN_BYTES, Fields.TERM_VECTORS_MEMORY, this.termVectorsMemoryInBytes);
        builder.byteSizeField(Fields.NORMS_MEMORY_IN_BYTES, Fields.NORMS_MEMORY, this.normsMemoryInBytes);
        builder.byteSizeField(Fields.DOC_VALUES_MEMORY_IN_BYTES, Fields.DOC_VALUES_MEMORY, this.docValuesMemoryInBytes);
        builder.byteSizeField(Fields.INDEX_WRITER_MEMORY_IN_BYTES, Fields.INDEX_WRITER_MEMORY, this.indexWriterMemoryInBytes);
        builder.byteSizeField(Fields.INDEX_WRITER_MAX_MEMORY_IN_BYTES, Fields.INDEX_WRITER_MAX_MEMORY, this.indexWriterMaxMemoryInBytes);
        builder.byteSizeField(Fields.VERSION_MAP_MEMORY_IN_BYTES, Fields.VERSION_MAP_MEMORY, this.versionMapMemoryInBytes);
        builder.byteSizeField(Fields.FIXED_BIT_SET_MEMORY_IN_BYTES, Fields.FIXED_BIT_SET, this.bitsetMemoryInBytes);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.memoryInBytes = in.readLong();
        this.termsMemoryInBytes = in.readLong();
        this.storedFieldsMemoryInBytes = in.readLong();
        this.termVectorsMemoryInBytes = in.readLong();
        this.normsMemoryInBytes = in.readLong();
        this.docValuesMemoryInBytes = in.readLong();
        this.indexWriterMemoryInBytes = in.readLong();
        this.versionMapMemoryInBytes = in.readLong();
        this.indexWriterMaxMemoryInBytes = in.readLong();
        this.bitsetMemoryInBytes = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeLong(this.memoryInBytes);
        out.writeLong(this.termsMemoryInBytes);
        out.writeLong(this.storedFieldsMemoryInBytes);
        out.writeLong(this.termVectorsMemoryInBytes);
        out.writeLong(this.normsMemoryInBytes);
        out.writeLong(this.docValuesMemoryInBytes);
        out.writeLong(this.indexWriterMemoryInBytes);
        out.writeLong(this.versionMapMemoryInBytes);
        out.writeLong(this.indexWriterMaxMemoryInBytes);
        out.writeLong(this.bitsetMemoryInBytes);
    }

    static final class Fields {
        static final XContentBuilderString SEGMENTS = new XContentBuilderString("segments");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString MEMORY = new XContentBuilderString("memory");
        static final XContentBuilderString MEMORY_IN_BYTES = new XContentBuilderString("memory_in_bytes");
        static final XContentBuilderString TERMS_MEMORY = new XContentBuilderString("terms_memory");
        static final XContentBuilderString TERMS_MEMORY_IN_BYTES = new XContentBuilderString("terms_memory_in_bytes");
        static final XContentBuilderString STORED_FIELDS_MEMORY = new XContentBuilderString("stored_fields_memory");
        static final XContentBuilderString STORED_FIELDS_MEMORY_IN_BYTES = new XContentBuilderString("stored_fields_memory_in_bytes");
        static final XContentBuilderString TERM_VECTORS_MEMORY = new XContentBuilderString("term_vectors_memory");
        static final XContentBuilderString TERM_VECTORS_MEMORY_IN_BYTES = new XContentBuilderString("term_vectors_memory_in_bytes");
        static final XContentBuilderString NORMS_MEMORY = new XContentBuilderString("norms_memory");
        static final XContentBuilderString NORMS_MEMORY_IN_BYTES = new XContentBuilderString("norms_memory_in_bytes");
        static final XContentBuilderString DOC_VALUES_MEMORY = new XContentBuilderString("doc_values_memory");
        static final XContentBuilderString DOC_VALUES_MEMORY_IN_BYTES = new XContentBuilderString("doc_values_memory_in_bytes");
        static final XContentBuilderString INDEX_WRITER_MEMORY = new XContentBuilderString("index_writer_memory");
        static final XContentBuilderString INDEX_WRITER_MEMORY_IN_BYTES = new XContentBuilderString("index_writer_memory_in_bytes");
        static final XContentBuilderString INDEX_WRITER_MAX_MEMORY = new XContentBuilderString("index_writer_max_memory");
        static final XContentBuilderString INDEX_WRITER_MAX_MEMORY_IN_BYTES = new XContentBuilderString("index_writer_max_memory_in_bytes");
        static final XContentBuilderString VERSION_MAP_MEMORY = new XContentBuilderString("version_map_memory");
        static final XContentBuilderString VERSION_MAP_MEMORY_IN_BYTES = new XContentBuilderString("version_map_memory_in_bytes");
        static final XContentBuilderString FIXED_BIT_SET = new XContentBuilderString("fixed_bit_set");
        static final XContentBuilderString FIXED_BIT_SET_MEMORY_IN_BYTES = new XContentBuilderString("fixed_bit_set_memory_in_bytes");

        Fields() {
        }
    }
}

