/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.derivative;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.derivative.Derivative;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalDerivative
extends InternalSimpleValue
implements Derivative {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("derivative");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalDerivative readResult(StreamInput in) throws IOException {
            InternalDerivative result = new InternalDerivative();
            result.readFrom(in);
            return result;
        }
    };
    private double normalizationFactor;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalDerivative() {
    }

    public InternalDerivative(String name, double value, double normalizationFactor, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, value, formatter, pipelineAggregators, metaData);
        this.normalizationFactor = normalizationFactor;
    }

    @Override
    public double normalizedValue() {
        return this.normalizationFactor > 0.0 ? this.value() / this.normalizationFactor : this.value();
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.value();
        }
        if (path.size() == 1 && "normalized_value".equals(path.get(0))) {
            return this.normalizedValue();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.normalizationFactor);
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        super.doReadFrom(in);
        this.normalizationFactor = in.readDouble();
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, params);
        if (this.normalizationFactor > 0.0) {
            boolean hasValue = !Double.isInfinite(this.normalizedValue()) && !Double.isNaN(this.normalizedValue());
            builder.field("normalized_value", hasValue ? Double.valueOf(this.normalizedValue()) : null);
            if (hasValue && !(this.valueFormatter instanceof ValueFormatter.Raw)) {
                builder.field("normalized_value_as_string", this.valueFormatter.format(this.normalizedValue()));
            }
        }
        return builder;
    }
}

