/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedqueries;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedQueriesFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return !context.parsedQuery().namedFilters().isEmpty() || context.parsedPostFilter() != null && !context.parsedPostFilter().namedFilters().isEmpty();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        ArrayList<String> matchedQueries = new ArrayList<String>(2);
        try {
            this.addMatchedQueries(hitContext, context.parsedQuery().namedFilters(), matchedQueries);
            if (context.parsedPostFilter() != null) {
                this.addMatchedQueries(hitContext, context.parsedPostFilter().namedFilters(), matchedQueries);
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        finally {
            SearchContext.current().clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
        hitContext.hit().matchedQueries(matchedQueries.toArray(new String[matchedQueries.size()]));
    }

    private void addMatchedQueries(FetchSubPhase.HitContext hitContext, ImmutableMap<String, Query> namedQueries, List<String> matchedQueries) throws IOException {
        for (Map.Entry entry : namedQueries.entrySet()) {
            String name = (String)entry.getKey();
            Query filter = (Query)entry.getValue();
            Weight weight = hitContext.topLevelSearcher().createNormalizedWeight(filter, false);
            Scorer scorer = weight.scorer(hitContext.readerContext());
            if (scorer == null) continue;
            TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
            if (twoPhase == null) {
                if (scorer.iterator().advance(hitContext.docId()) != hitContext.docId()) continue;
                matchedQueries.add(name);
                continue;
            }
            if (twoPhase.approximation().advance(hitContext.docId()) != hitContext.docId() || !twoPhase.matches()) continue;
            matchedQueries.add(name);
        }
    }
}

