/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.ListListSetting;
import org.openstreetmap.josm.data.preferences.ListSetting;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.data.preferences.StringSetting;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class PreferencesReader {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private final SortedMap<String, Setting<?>> settings = new TreeMap();
    private XMLStreamReader parser;
    private int version;
    private Reader reader;
    private File file;
    private final boolean defaults;

    public PreferencesReader(File file, boolean bl) throws IOException, XMLStreamException {
        this.defaults = bl;
        this.reader = null;
        this.file = file;
    }

    public PreferencesReader(Reader reader, boolean bl) throws XMLStreamException {
        this.defaults = bl;
        this.reader = reader;
        this.file = null;
    }

    public static void validateXML(File file) throws IOException, SAXException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            PreferencesReader.validateXML(bufferedReader);
        }
    }

    public static void validateXML(Reader reader) throws IOException, SAXException {
        try (CachedFile cachedFile = new CachedFile("resource://data/preferences.xsd");
             InputStream inputStream = cachedFile.getInputStream();){
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(inputStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(reader));
        }
    }

    public SortedMap<String, Setting<?>> getSettings() {
        return this.settings;
    }

    public int getVersion() {
        return this.version;
    }

    public void parse() throws XMLStreamException, IOException {
        if (this.reader != null) {
            this.parser = XMLInputFactory.newInstance().createXMLStreamReader(this.reader);
            this.doParse();
        } else {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
                this.parser = XMLInputFactory.newInstance().createXMLStreamReader(bufferedReader);
                this.doParse();
            }
        }
    }

    private void doParse() throws XMLStreamException {
        int n = this.parser.getEventType();
        while (true) {
            if (n == 1) {
                block7: {
                    String string;
                    String string2 = this.defaults ? "preferences-defaults" : "preferences";
                    if (!string2.equals(string = this.parser.getLocalName())) {
                        throw new XMLStreamException(I18n.tr("Expected element ''{0}'', but got ''{1}''", string2, string), this.parser.getLocation());
                    }
                    try {
                        this.version = Integer.parseInt(this.parser.getAttributeValue(null, "version"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Main.isDebugEnabled()) break block7;
                        Main.debug(numberFormatException.getMessage());
                    }
                }
                this.parseRoot();
            } else if (n == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            n = this.parser.next();
        }
        this.parser.close();
    }

    private void parseRoot() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                String string;
                switch (string = this.parser.getLocalName()) {
                    case "tag": {
                        StringSetting stringSetting;
                        if (this.defaults && this.isNil()) {
                            stringSetting = new StringSetting(null);
                        } else {
                            String string2 = this.parser.getAttributeValue(null, "value");
                            if (string2 == null) {
                                throw new XMLStreamException(I18n.tr("value expected", new Object[0]), this.parser.getLocation());
                            }
                            stringSetting = new StringSetting(string2);
                        }
                        if (this.defaults) {
                            stringSetting.setTime(Math.round(Double.parseDouble(this.parser.getAttributeValue(null, "time"))));
                        }
                        this.settings.put(this.parser.getAttributeValue(null, "key"), stringSetting);
                        this.jumpToEnd();
                        break;
                    }
                    case "list": 
                    case "lists": 
                    case "maps": {
                        this.parseToplevelList();
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + string);
                        break;
                    }
                }
                continue;
            }
            if (n == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.jumpToEnd();
                continue;
            }
            if (n == 2) break;
        }
    }

    private void parseToplevelList() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "key");
        Long l = null;
        if (this.defaults) {
            l = Math.round(Double.parseDouble(this.parser.getAttributeValue(null, "time")));
        }
        String string2 = this.parser.getLocalName();
        ArrayList<String> arrayList = null;
        ArrayList<List<String>> arrayList2 = null;
        ArrayList<Map<String, String>> arrayList3 = null;
        if (this.defaults && this.isNil()) {
            AbstractSetting abstractSetting;
            switch (string2) {
                case "lists": {
                    abstractSetting = new ListListSetting(null);
                    break;
                }
                case "maps": {
                    abstractSetting = new MapListSetting(null);
                    break;
                }
                default: {
                    abstractSetting = new ListSetting(null);
                }
            }
            abstractSetting.setTime(l);
            this.settings.put(string, abstractSetting);
            this.jumpToEnd();
        } else {
            AbstractSetting abstractSetting;
            while (true) {
                int n;
                if ((n = this.parser.next()) == 1) {
                    String string3;
                    switch (string3 = this.parser.getLocalName()) {
                        case "entry": {
                            if (arrayList == null) {
                                arrayList = new ArrayList<String>();
                            }
                            arrayList.add(this.parser.getAttributeValue(null, "value"));
                            this.jumpToEnd();
                            break;
                        }
                        case "list": {
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<List<String>>();
                            }
                            arrayList2.add(this.parseInnerList());
                            break;
                        }
                        case "map": {
                            if (arrayList3 == null) {
                                arrayList3 = new ArrayList<Map<String, String>>();
                            }
                            arrayList3.add(this.parseMap());
                            break;
                        }
                        default: {
                            this.throwException("Unexpected element: " + string3);
                            break;
                        }
                    }
                    continue;
                }
                if (n == 2) break;
            }
            if (arrayList != null) {
                abstractSetting = new ListSetting(Collections.unmodifiableList(arrayList));
            } else if (arrayList2 != null) {
                abstractSetting = new ListListSetting(Collections.unmodifiableList(arrayList2));
            } else if (arrayList3 != null) {
                abstractSetting = new MapListSetting(Collections.unmodifiableList(arrayList3));
            } else {
                switch (string2) {
                    case "lists": {
                        abstractSetting = new ListListSetting(Collections.emptyList());
                        break;
                    }
                    case "maps": {
                        abstractSetting = new MapListSetting(Collections.emptyList());
                        break;
                    }
                    default: {
                        abstractSetting = new ListSetting(Collections.emptyList());
                    }
                }
            }
            if (this.defaults) {
                abstractSetting.setTime(l);
            }
            this.settings.put(string, abstractSetting);
        }
    }

    private List<String> parseInnerList() throws XMLStreamException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if ("entry".equals(this.parser.getLocalName())) {
                    arrayList.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Map<String, String> parseMap() throws XMLStreamException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if ("tag".equals(this.parser.getLocalName())) {
                    linkedHashMap.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private boolean isNil() {
        String string = this.parser.getAttributeValue(XSI_NS, "nil");
        return "true".equals(string) || "1".equals(string);
    }

    private void throwException(String string) {
        throw new RuntimeException(string + I18n.tr(" (at line {0}, column {1})", this.parser.getLocation().getLineNumber(), this.parser.getLocation().getColumnNumber()));
    }
}

