/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerWritePostprocessor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerWriter {
    private Collection<OsmPrimitive> processed;
    private static volatile List<OsmServerWritePostprocessor> postprocessors;
    private final OsmApi api = OsmApi.getOsmApi();
    private boolean canceled;
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    private long uploadStartTime;

    public static void registerPostprocessor(OsmServerWritePostprocessor osmServerWritePostprocessor) {
        if (postprocessors == null) {
            postprocessors = new ArrayList<OsmServerWritePostprocessor>();
        }
        postprocessors.add(osmServerWritePostprocessor);
    }

    public static void unregisterPostprocessor(OsmServerWritePostprocessor osmServerWritePostprocessor) {
        if (postprocessors != null) {
            postprocessors.remove(osmServerWritePostprocessor);
        }
    }

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        double d = (double)n / (double)l2;
        double d2 = n2 - n;
        long l3 = (long)(d2 / d);
        long l4 = l3 / 60000L;
        long l5 = l3 / 1000L % 60L;
        StringBuilder stringBuilder = new StringBuilder().append(l4).append(':');
        if (l5 < 10L) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(l5).toString();
    }

    protected void uploadChangesIndividually(Collection<? extends OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ...", new Object[0]));
            progressMonitor.setTicksCount(collection.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osmPrimitive : collection) {
                int n = progressMonitor.getTicks();
                String string = this.timeLeft(n, collection.size());
                String string2 = "";
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                    }
                }
                progressMonitor.subTask(I18n.tr(string2, Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string, osmPrimitive.getName() == null ? Long.valueOf(osmPrimitive.getId()) : osmPrimitive.getName(), osmPrimitive.getId()));
                this.makeApiRequest(osmPrimitive, progressMonitor);
                this.processed.add(osmPrimitive);
                progressMonitor.worked(1);
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<? extends OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ...", new Object[0]));
            this.processed.addAll(this.api.uploadDiff(collection, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesInChunks(Collection<? extends OsmPrimitive> collection, ProgressMonitor progressMonitor, int n) throws OsmTransferException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Value >0 expected for parameter ''{0}'', got {1}", "chunkSize", n));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in chunks...", new Object[0]));
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(n);
            Iterator<? extends OsmPrimitive> iterator = collection.iterator();
            int n2 = (int)Math.ceil((double)collection.size() / (double)n);
            int n3 = 0;
            while (iterator.hasNext()) {
                ++n3;
                if (this.canceled) {
                    return;
                }
                arrayList.clear();
                for (int i = 0; iterator.hasNext() && i < n; ++i) {
                    if (this.canceled) {
                        return;
                    }
                    arrayList.add(iterator.next());
                }
                progressMonitor.setCustomText(I18n.trn("({0}/{1}) Uploading {2} object...", "({0}/{1}) Uploading {2} objects...", arrayList.size(), n3, n2, arrayList.size()));
                this.processed.addAll(this.api.uploadDiff(arrayList, progressMonitor.createSubTaskMonitor(-1, false)));
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uploadOsm(UploadStrategySpecification uploadStrategySpecification, Collection<? extends OsmPrimitive> collection, Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.processed = new LinkedList<OsmPrimitive>();
        progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        progressMonitor.beginTask(I18n.tr("Uploading data ...", new Object[0]));
        try {
            this.api.initialize(progressMonitor);
            if (changeset.getId() == 0) {
                this.api.openChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
                changeset.setUser(JosmUserIdentityManager.getInstance().asUser());
            } else {
                this.api.updateChangeset(changeset, progressMonitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            switch (uploadStrategySpecification.getStrategy()) {
                case SINGLE_REQUEST_STRATEGY: {
                    this.uploadChangesAsDiffUpload(collection, progressMonitor.createSubTaskMonitor(0, false));
                    return;
                }
                case INDIVIDUAL_OBJECTS_STRATEGY: {
                    this.uploadChangesIndividually(collection, progressMonitor.createSubTaskMonitor(0, false));
                    return;
                }
                case CHUNKED_DATASET_STRATEGY: {
                    this.uploadChangesInChunks(collection, progressMonitor.createSubTaskMonitor(0, false), uploadStrategySpecification.getChunkSize());
                    return;
                }
            }
            return;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        finally {
            this.executePostprocessors(progressMonitor);
            progressMonitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osmPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osmPrimitive.isDeleted()) {
            this.api.deletePrimitive(osmPrimitive, progressMonitor);
        } else if (osmPrimitive.isNew()) {
            this.api.createPrimitive(osmPrimitive, progressMonitor);
        } else {
            this.api.modifyPrimitive(osmPrimitive, progressMonitor);
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }

    public void executePostprocessors(ProgressMonitor progressMonitor) {
        if (postprocessors != null) {
            for (OsmServerWritePostprocessor osmServerWritePostprocessor : postprocessors) {
                osmServerWritePostprocessor.postprocessUploadedPrimitives(this.processed, progressMonitor);
            }
        }
    }
}

