/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot;

import com.baselet.control.Matrix;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.NewGridElement;
import com.baselet.element.elementnew.plot.drawer.PlotGridDrawConfig;
import com.baselet.element.elementnew.plot.elements.AbstractPlot;
import com.baselet.element.elementnew.plot.elements.BarPlot;
import com.baselet.element.elementnew.plot.elements.LinePlot;
import com.baselet.element.elementnew.plot.elements.PiePlot;
import com.baselet.element.elementnew.plot.elements.ScatterPlot;
import com.baselet.element.elementnew.plot.parser.Parser;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.ParserResult;
import com.baselet.element.elementnew.plot.parser.PlotConstants;
import com.baselet.element.elementnew.plot.parser.PlotState;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.settings.SettingsManualresizeCenter;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotGrid
extends NewGridElement {
    private static final Logger log = LoggerFactory.getLogger(PlotGrid.class);
    private Matrix<List<AbstractPlot>> matrix;
    private Integer gridWidth;
    private Double minValue;
    private Double maxValue;
    public static final Facet PSEUDO_PLOT_FACET = new Facet(){

        @Override
        public void handleLine(String line, PropertiesParserState propConfig) {
        }

        @Override
        public List<AutocompletionText> getAutocompletionStrings() {
            return PlotConstants.AUTOCOMPLETION_LIST;
        }

        @Override
        public boolean checkStart(String line, PropertiesParserState propConfig) {
            return true;
        }
    };

    private void fillWithPlots(ParserResult parserState) {
        ArrayList<PlotState> plotStateList = parserState.getPlotStateList();
        DrawHandler drawer = parserState.getDrawer();
        this.setOverallMinMaxValue(plotStateList);
        for (PlotState plotState : plotStateList) {
            List<List<AbstractPlot>> xCoordinateList;
            Integer xPos = plotState.getValueAsInt("pos.x", null);
            Integer yPos = plotState.getValueAsInt("pos.y", null);
            if (xPos != null) {
                xPos = xPos - 1;
            }
            if (yPos != null) {
                yPos = yPos - 1;
            }
            if (xPos != null && yPos != null) {
                this.setMatrixHeightMinimum(yPos);
                xCoordinateList = this.matrix.row(yPos);
                this.setMinimumListSize(xPos, xCoordinateList);
                xCoordinateList.set(xPos, this.createPlots(drawer, plotState, xPos, yPos, "x and y are specified"));
                continue;
            }
            if (xPos != null) {
                this.putPlotInFirstFreeVerticalSpaceOrAddPlot(drawer, xPos, plotState, "only x is specified -> space replaced");
                continue;
            }
            if (yPos != null) {
                this.setMatrixHeightMinimum(yPos);
                xCoordinateList = this.matrix.row(yPos);
                this.putPlotInFirstFreeHorizontalSpaceOrAddPlot(drawer, xCoordinateList, yPos, plotState, "only y specified -> ");
                continue;
            }
            this.putPlotInFirstFreeMatrixSpace(drawer, plotState);
        }
        this.gridWidth = this.matrix.cols();
        log.debug("\n" + this.toString() + "\n");
    }

    private void setOverallMinMaxValue(List<PlotState> plotStateList) {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        for (PlotState state : plotStateList) {
            Double[][] data;
            Double[][] doubleArray = data = state.getDataSet().data();
            int n = doubleArray.length;
            for (int i = 0; i < n; ++i) {
                Double[] dArray;
                for (Double d : dArray = doubleArray[i]) {
                    if (d > this.maxValue) {
                        this.maxValue = d;
                    }
                    if (!(d < this.minValue)) continue;
                    this.minValue = d;
                }
            }
        }
    }

    private void setMatrixHeightMinimum(Integer minHeight) {
        while (minHeight > this.matrix.rows() - 1) {
            this.matrix.addLine(new ArrayList());
        }
    }

    private void setMinimumListSize(Integer minWidth, List<List<AbstractPlot>> lineToSet) {
        while (minWidth > lineToSet.size() - 1) {
            lineToSet.add(null);
        }
    }

    private void putPlotInFirstFreeVerticalSpaceOrAddPlot(DrawHandler drawer, Integer xFix, PlotState plotState, String info) {
        boolean plotFilledInFreeSpace = false;
        for (int ySeq = 0; ySeq < this.matrix.rows(); ++ySeq) {
            List<List<AbstractPlot>> xCoordinateList = this.matrix.row(ySeq);
            if (xFix >= xCoordinateList.size()) {
                this.setMinimumListSize(xFix, xCoordinateList);
            }
            if (xCoordinateList.get(xFix) != null) continue;
            xCoordinateList.set(xFix, this.createPlots(drawer, plotState, xFix, ySeq, info));
            plotFilledInFreeSpace = true;
            break;
        }
        if (!plotFilledInFreeSpace) {
            ArrayList<List<AbstractPlot>> newColumn = new ArrayList<List<AbstractPlot>>();
            this.setMinimumListSize(xFix, newColumn);
            newColumn.set(xFix, this.createPlots(drawer, plotState, xFix, this.matrix.rows(), "only x is specified -> expanded y-list"));
            this.matrix.addLine(newColumn);
        }
    }

    private void putPlotInFirstFreeHorizontalSpaceOrAddPlot(DrawHandler drawer, List<List<AbstractPlot>> xCoordinateList, Integer yFix, PlotState plotState, String info) {
        int xSeq = 0;
        while (true) {
            if (xSeq == xCoordinateList.size()) {
                xCoordinateList.add(this.createPlots(drawer, plotState, xSeq, yFix, info + "added new x-entry"));
                return;
            }
            if (xCoordinateList.get(xSeq) == null) {
                xCoordinateList.set(xSeq, this.createPlots(drawer, plotState, xSeq, yFix, info + "replaced x-entry"));
                return;
            }
            ++xSeq;
        }
    }

    private void putPlotInFirstFreeMatrixSpace(DrawHandler drawer, PlotState plotState) {
        for (int ySeq = 0; ySeq < this.matrix.rows(); ++ySeq) {
            List<List<AbstractPlot>> oneLine = this.matrix.row(ySeq);
            for (int xSeq = 0; xSeq < oneLine.size(); ++xSeq) {
                List<AbstractPlot> oneValue = oneLine.get(xSeq);
                if (oneValue != null) continue;
                oneLine.set(xSeq, this.createPlots(drawer, plotState, xSeq, ySeq, "no coordinate specified -> free space found"));
                return;
            }
            if (oneLine.size() >= this.gridWidth) continue;
            oneLine.add(this.createPlots(drawer, plotState, oneLine.size(), ySeq, "no coordinate specified -> expanded x-list"));
            return;
        }
        ArrayList<List<AbstractPlot>> newLine = new ArrayList<List<AbstractPlot>>();
        newLine.add(this.createPlots(drawer, plotState, 0, this.matrix.rows(), "no coordinate specified -> every matrix space occupied, expanded y-list"));
        this.matrix.addLine(newLine);
    }

    private List<AbstractPlot> createPlots(DrawHandler drawer, PlotState plotState, Integer xPos, Integer yPos, String info) {
        ArrayList<AbstractPlot> plotList = new ArrayList<AbstractPlot>();
        plotList.add(this.createPlot(drawer, plotState, xPos, yPos, info));
        for (PlotState subPlotState : plotState.getSubplots()) {
            plotList.add(this.createPlot(drawer, subPlotState, xPos, yPos, info));
        }
        return plotList;
    }

    private AbstractPlot createPlot(DrawHandler drawer, PlotState plotState, int xPos, int yPos, String info) {
        String type = plotState.getValueValidated(PlotConstants.PlotType.getKey(), PlotConstants.PlotType.Bar.getValue(), PlotConstants.toStringList(PlotConstants.PlotType.values()));
        log.debug("PlotGrid insert : " + type + " (" + xPos + ";" + yPos + ") " + info);
        PlotGridDrawConfig plotDrawConfig = new PlotGridDrawConfig(this.getRealSize(), new Dimension(this.getRectangle().width, this.getRectangle().height), this.minValue, this.maxValue);
        if (PlotConstants.PlotType.Pie.getValue().equals(type)) {
            return new PiePlot(drawer, plotDrawConfig, plotState, xPos, yPos);
        }
        if (PlotConstants.PlotType.Line.getValue().equals(type)) {
            return new LinePlot(drawer, plotDrawConfig, plotState, xPos, yPos);
        }
        if (PlotConstants.PlotType.Scatter.getValue().equals(type)) {
            return new ScatterPlot(drawer, plotDrawConfig, plotState, xPos, yPos);
        }
        return new BarPlot(drawer, plotDrawConfig, plotState, xPos, yPos);
    }

    public void drawPlots() {
        for (int row = 0; row < this.matrix.rows(); ++row) {
            for (int col = 0; col < this.matrix.row(row).size(); ++col) {
                List<AbstractPlot> oneCell = this.matrix.cell(row, col);
                for (AbstractPlot onePlot : oneCell) {
                    if (onePlot == null) continue;
                    if (col != onePlot.getXPosition()) {
                        log.error("Plot contains wrong coordinates: " + col + " != " + onePlot.getXPosition());
                    }
                    if (row != onePlot.getYPosition()) {
                        log.error("Plot contains wrong coordinates: " + row + " != " + onePlot.getYPosition());
                    }
                    onePlot.plot(this.matrix.cols(), this.matrix.rows());
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("------------------------------\n");
        for (int i = 0; i < this.matrix.rows(); ++i) {
            List<List<AbstractPlot>> row = this.matrix.row(i);
            for (List<AbstractPlot> oneCell : row) {
                for (AbstractPlot onePlot : oneCell) {
                    if (onePlot == null) {
                        sb.append("null\t");
                        continue;
                    }
                    sb.append(onePlot.getPlotLineNr()).append("\t");
                }
            }
            sb.append("\n");
        }
        return sb.append("------------------------------").toString();
    }

    @Override
    protected void drawCommonContent(PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        try {
            this.matrix = new Matrix();
            ParserResult parserState = new Parser().parse(this.getPanelAttributes());
            parserState.setDrawer(drawer);
            log.debug(parserState.toString());
            this.gridWidth = Integer.parseInt(parserState.getPlotGridValue("grid.width", "3"));
            this.fillWithPlots(parserState);
            this.drawPlots();
        }
        catch (ParserException e) {
            drawer.setForegroundColor(ColorOwn.RED);
            drawer.setBackgroundColor(ColorOwn.WHITE);
            drawer.drawRectangle(0.0, 0.0, this.getRectangle().width - 1, this.getRectangle().height - 1);
            float x = (float)this.getRectangle().getWidth() / 2.0f;
            drawer.print(e.getMessage(), (double)x, (double)this.getRealSize().height / 2.0, AlignHorizontal.CENTER);
        }
    }

    @Override
    protected Settings createSettings() {
        return new SettingsManualresizeCenter(){

            @Override
            protected List<Facet> createFacets() {
                return 2.listOf(PSEUDO_PLOT_FACET);
            }
        };
    }

    @Override
    public ElementId getId() {
        return ElementId.PlotGrid;
    }
}

