/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.relation.helper.RelationPointHandlerUtils;
import com.baselet.element.relation.helper.RelationPointHolder;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.relation.helper.RelationSelection;
import com.baselet.element.relation.helper.ResizableObject;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelationPointHandler
implements ResizableObject {
    private RelationPointList points = new RelationPointList();
    private final RelationPointHolder relation;
    private PointDoubleIndexed relationPointOfCurrentDrag = null;

    public RelationPointHandler(RelationPointHolder relation, RelationPointList points) {
        this.relation = relation;
        this.points = points;
    }

    public RelationSelection getSelection(Point point) {
        if (this.isPointOverDragBox(point)) {
            return RelationSelection.DRAG_BOX;
        }
        if (RelationPointHandlerUtils.getRelationPointContaining(point, this.points) != null) {
            return RelationSelection.RELATION_POINT;
        }
        if (this.getLineContaining(point) != null) {
            return RelationSelection.LINE;
        }
        return RelationSelection.NOTHING;
    }

    public RelationSelection getSelectionAndMovePointsIfNecessary(Point point, Integer diffX, Integer diffY, boolean firstDrag) {
        if (!firstDrag && this.relationPointOfCurrentDrag != null) {
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(this.relationPointOfCurrentDrag, diffX, diffY);
            return RelationSelection.RELATION_POINT;
        }
        this.relationPointOfCurrentDrag = null;
        if (this.isPointOverDragBox(point)) {
            return RelationSelection.DRAG_BOX;
        }
        PointDoubleIndexed pointOverRelationPoint = RelationPointHandlerUtils.getRelationPointContaining(point, this.points);
        if (pointOverRelationPoint != null) {
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(pointOverRelationPoint, diffX, diffY);
            return RelationSelection.RELATION_POINT;
        }
        Line lineOnPoint = this.getLineContaining(point);
        if (lineOnPoint != null) {
            this.relationPointOfCurrentDrag = this.points.addPointOnLine(lineOnPoint, SharedUtils.realignToGridRoundToNearest(false, point.x), SharedUtils.realignToGridRoundToNearest(false, point.y));
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(this.relationPointOfCurrentDrag, diffX, diffY);
            return RelationSelection.LINE;
        }
        return RelationSelection.NOTHING;
    }

    private boolean isPointOverDragBox(Point point) {
        return this.getDragBox().contains(point);
    }

    private Line getLineContaining(Point point) {
        for (Line line : this.points.getRelationPointLines()) {
            double distanceToPoint = line.getDistanceToPoint(point.toPointDouble());
            if (!(distanceToPoint < 7.0)) continue;
            return line;
        }
        return null;
    }

    public List<PointDoubleIndexed> movePointAndResizeRectangle(List<PointChange> changedPoints) {
        this.points.applyChangesToPoints(changedPoints);
        this.resizeRectAndReposPoints();
        ArrayList<PointDoubleIndexed> updatedChangedPoint = new ArrayList<PointDoubleIndexed>();
        for (PointChange c : changedPoints) {
            updatedChangedPoint.add(this.points.get(c.getIndex()));
        }
        return updatedChangedPoint;
    }

    private PointDoubleIndexed movePointAndResizeRectangle(PointDoubleIndexed point, Integer diffX, Integer diffY) {
        return this.movePointAndResizeRectangle(Arrays.asList(new PointChange(point.getIndex(), diffX, diffY))).get(0);
    }

    public void resizeRectAndReposPoints() {
        Rectangle newRect = RelationPointHandlerUtils.calculateRelationRectangleBasedOnPoints(this.relation.getRectangle().getUpperLeftCorner(), this.relation.getGridSize(), this.points);
        this.relation.setRectangle(newRect);
        this.points.moveRelationPointsAndTextSpacesByToUpperLeftCorner();
    }

    public boolean removeRelationPointIfOnLineBetweenNeighbourPoints() {
        return this.points.removeRelationPointIfOnLineBetweenNeighbourPoints();
    }

    public Line getFirstLine() {
        return this.points.getFirstLine();
    }

    public Line getMiddleLine() {
        return this.points.getMiddleLine();
    }

    public Line getLastLine() {
        return this.points.getLastLine();
    }

    public Collection<PointDoubleIndexed> getStickablePoints() {
        return this.points.getStickablePoints();
    }

    public Rectangle getDragBox() {
        return this.points.getDragBox();
    }

    public void drawLinesBetweenPoints(DrawHandler drawer, boolean shortFirstLine, boolean shortLastLine) {
        List<Line> lines = this.points.getRelationPointLines();
        for (int i = 0; i < lines.size(); ++i) {
            Line lineToDraw = lines.get(i);
            if (i == 0 && shortFirstLine) {
                lineToDraw = lineToDraw.getShorterVersion(true, 1.0);
            } else if (i == lines.size() - 1 && shortLastLine) {
                lineToDraw = lineToDraw.getShorterVersion(false, 1.0);
            }
            drawer.drawLine(lineToDraw);
        }
    }

    public void drawCirclesAndDragBox(DrawHandler drawer) {
        for (RelationPoint p : this.points.getPointHolders()) {
            drawer.drawCircle(p.getPoint().getX(), p.getPoint().getY(), 10.0);
        }
        drawer.drawRectangle(this.getDragBox());
    }

    public String toAdditionalAttributesString() {
        return this.points.toAdditionalAttributesString();
    }

    public void drawSelectionSpace(DrawHandler drawer) {
        for (RelationPoint rp : this.points.getPointHolders()) {
            drawer.drawRectangle(rp.getSizeAbsolute());
        }
    }

    public void setTextBox(int index, Rectangle size) {
        size = SharedUtils.realignToGrid(size, true);
        this.points.setTextBox(index, size);
    }

    public void resetTextBoxIndexesExcept(Set<Integer> excludedList) {
        HashSet<Integer> unusedTextBoxIndexes = new HashSet<Integer>(this.points.getTextBoxIndexes());
        unusedTextBoxIndexes.removeAll(excludedList);
        for (Integer index : unusedTextBoxIndexes) {
            this.points.setTextBox(index, null);
        }
    }

    @Override
    public void setPointMinSize(int index, Rectangle size) {
        size = SharedUtils.realignToGrid(size, true);
        this.points.setSize(index, size);
    }

    @Override
    public void resetPointMinSize(int index) {
        this.points.setSize(index, RelationPoint.DEFAULT_SIZE);
    }

    public String toString() {
        return this.points.toString();
    }
}

