/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.old.element.Relation;
import com.baselet.element.sticking.StickableMap;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.Move;
import com.baselet.gui.command.OldMoveLinePoint;
import com.baselet.gui.command.RemoveElement;
import com.baselet.gui.listener.GridElementListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;

@Deprecated
public class OldRelationListener
extends GridElementListener {
    private boolean IS_DRAGGING_LINEPOINT = false;
    private boolean IS_DRAGGING_LINE = false;
    private int LINEPOINT = -1;

    public OldRelationListener(DiagramHandler handler) {
        super(handler);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        if (me.getButton() == 1) {
            this.IS_DRAGGING = false;
            Relation rel = (Relation)me.getComponent();
            int where = rel.getLinePoint(new Point(me.getX(), me.getY()));
            if (where >= 0) {
                this.IS_DRAGGING_LINEPOINT = true;
                this.LINEPOINT = where;
            } else if (rel.isWholeLine(me.getX(), me.getY())) {
                this.IS_DRAGGING_LINE = true;
                this.IS_DRAGGING = true;
            } else if (me.getButton() == 2) {
                this.IS_DRAGGING_DIAGRAM = true;
                this.IS_DRAGGING_LINE = false;
                this.IS_DRAGGING_LINEPOINT = false;
                this.IS_DRAGGING = false;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        super.mouseReleased(me);
        if (this.IS_DRAGGING_LINEPOINT & this.LINEPOINT >= 0) {
            Relation rel = (Relation)me.getComponent();
            if (rel.allPointsOnSamePos()) {
                this.controller.undo();
                this.controller.executeCommand(new RemoveElement(rel));
            } else if (rel.isOnLine(this.LINEPOINT)) {
                this.controller.executeCommand(new OldRemoveLinePoint(rel, this.LINEPOINT));
            }
        }
        this.IS_DRAGGING_LINEPOINT = false;
        this.IS_DRAGGING_LINE = false;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
        Relation rel = (Relation)me.getComponent();
        int where = rel.getLinePoint(new Point(me.getX(), me.getY()));
        if (where >= 0) {
            CurrentGui.getInstance().getGui().setCursor(Constants.HAND_CURSOR);
        } else if (rel.isWholeLine(me.getX(), me.getY())) {
            CurrentGui.getInstance().getGui().setCursor(Constants.MOVE_CURSOR);
        } else {
            CurrentGui.getInstance().getGui().setCursor(Constants.CROSS_CURSOR);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        super.mouseDragged(me);
        if (this.disableElementMovement()) {
            return;
        }
        if (this.IS_DRAGGING) {
            return;
        }
        if (this.IS_DRAGGING_DIAGRAM) {
            return;
        }
        Relation r = (Relation)me.getComponent();
        int gridSize = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
        int delta_x = 0;
        int delta_y = 0;
        if (this.IS_DRAGGING_LINEPOINT) {
            Vector<Point> tmp = r.getLinePoints();
            Point p = tmp.elementAt(this.LINEPOINT);
            delta_x = (r.getRectangle().x + p.x) % gridSize;
            delta_y = (r.getRectangle().y + p.y) % gridSize;
        }
        Point newp = this.getNewCoordinate();
        Point oldp = this.getOldCoordinate();
        int diffx = newp.x - oldp.x - delta_x;
        int diffy = newp.y - oldp.y - delta_y;
        if (this.IS_DRAGGING_LINEPOINT & this.LINEPOINT >= 0) {
            this.controller.executeCommand(new OldMoveLinePoint(r, this.LINEPOINT, diffx, diffy));
            return;
        }
        if (this.IS_DRAGGING_LINE) {
            this.controller.executeCommand(new Move(Collections.<Direction>emptySet(), r, diffx, diffy, oldp, me.isShiftDown(), false, true, StickableMap.EMPTY_MAP));
            return;
        }
        int where = r.getLinePoint(new Point(me.getX(), me.getY()));
        if (where >= 0) {
            this.IS_DRAGGING_LINEPOINT = true;
            this.LINEPOINT = where;
            this.controller.executeCommand(new OldMoveLinePoint(r, where, diffx, diffy));
            return;
        }
        Point p = new Point(me.getX(), me.getY());
        int ins = r.getWhereToInsert(p);
        if (ins > 0) {
            this.IS_DRAGGING_LINEPOINT = true;
            this.LINEPOINT = ins;
            this.controller.executeCommand(new OldAddLinePoint(r, ins, me.getX(), me.getY()));
            return;
        }
    }

    private static class OldRemoveLinePoint
    extends Command {
        private final Relation _relation;
        private final int _where;
        private final int _x;
        private final int _y;

        private int getX() {
            return this._x * HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        private int getY() {
            return this._y * HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        public OldRemoveLinePoint(Relation r, int i) {
            this._relation = r;
            this._where = i;
            Point p = r.getLinePoints().elementAt(i);
            this._x = p.x / HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
            this._y = p.y / HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        @Override
        public void execute(DiagramHandler handler) {
            super.execute(handler);
            Vector<Point> tmp = this._relation.getLinePoints();
            tmp.removeElementAt(this._where);
            this._relation.repaint();
        }

        @Override
        public void undo(DiagramHandler handler) {
            super.undo(handler);
            Vector<Point> tmp = this._relation.getLinePoints();
            tmp.insertElementAt(new Point(this.getX(), this.getY()), this._where);
            this._relation.repaint();
        }
    }

    private static class OldAddLinePoint
    extends Command {
        private final Relation _relation;
        private final int _where;
        private final int _x;
        private final int _y;

        private int getX() {
            return this._x * HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        private int getY() {
            return this._y * HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        public OldAddLinePoint(Relation r, int i, int x, int y) {
            this._relation = r;
            this._where = i;
            this._x = x / HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
            this._y = y / HandlerElementMap.getHandlerForElement(this._relation).getGridSize();
        }

        @Override
        public void execute(DiagramHandler handler) {
            super.execute(handler);
            Vector<Point> tmp = this._relation.getLinePoints();
            tmp.insertElementAt(new Point(this.getX(), this.getY()), this._where);
            this._relation.repaint();
        }

        @Override
        public void undo(DiagramHandler handler) {
            super.undo(handler);
            Vector<Point> tmp = this._relation.getLinePoints();
            tmp.removeElementAt(this._where);
            this._relation.repaint();
        }
    }
}

