/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.SiteMapPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.extension.AddonFilesChangedListener;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.TabbedPanel2;

public class ExtensionLoader {
    private final List<Extension> extensionList = new ArrayList<Extension>();
    private final Map<Class<? extends Extension>, Extension> extensionsMap = new HashMap<Class<? extends Extension>, Extension>();
    private final Map<Extension, ExtensionHook> extensionHooks = new HashMap<Extension, ExtensionHook>();
    private Model model = null;
    private View view = null;
    private static final Logger logger = Logger.getLogger(ExtensionLoader.class);

    public ExtensionLoader(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
        this.extensionsMap.put(extension.getClass(), extension);
    }

    public void destroyAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).destroy();
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public Extension getExtension(int n) {
        return this.extensionList.get(n);
    }

    public Extension getExtension(String string) {
        if (string != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension extension = this.getExtension(i);
                if (!extension.getName().equalsIgnoreCase(string)) continue;
                return extension;
            }
        }
        return null;
    }

    public Extension getExtensionByClassName(String string) {
        if (string != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension extension = this.getExtension(i);
                if (!extension.getClass().getName().equals(string)) continue;
                return extension;
            }
        }
        return null;
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        Extension extension;
        if (clazz != null && (extension = this.extensionsMap.get(clazz)) != null) {
            return (T)((Extension)clazz.cast(extension));
        }
        return null;
    }

    public boolean isExtensionEnabled(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter extensionName must not be null.");
        }
        Extension extension = this.getExtension(string);
        if (extension == null) {
            return false;
        }
        return extension.isEnabled();
    }

    public int getExtensionCount() {
        return this.extensionList.size();
    }

    public void hookProxyListener(Proxy proxy) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            ExtensionLoader.hookProxyListeners(proxy, extensionHook.getProxyListenerList());
        }
    }

    private static void hookProxyListeners(Proxy proxy, List<ProxyListener> list) {
        for (ProxyListener proxyListener : list) {
            try {
                if (proxyListener == null) continue;
                proxy.addProxyListener(proxyListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void removeProxyListener(ExtensionHook extensionHook) {
        Proxy proxy = Control.getSingleton().getProxy();
        Vector<ProxyListener> vector = extensionHook.getProxyListenerList();
        for (ProxyListener proxyListener : vector) {
            try {
                if (proxyListener == null) continue;
                proxy.removeProxyListener(proxyListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void hookOverrideMessageProxyListener(Proxy proxy) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            List<OverrideMessageProxyListener> list = extensionHook.getOverrideMessageProxyListenerList();
            for (OverrideMessageProxyListener overrideMessageProxyListener : list) {
                try {
                    if (overrideMessageProxyListener == null) continue;
                    proxy.addOverrideMessageProxyListener(overrideMessageProxyListener);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    private void removeOverrideMessageProxyListener(ExtensionHook extensionHook) {
        Proxy proxy = Control.getSingleton().getProxy();
        List<OverrideMessageProxyListener> list = extensionHook.getOverrideMessageProxyListenerList();
        for (OverrideMessageProxyListener overrideMessageProxyListener : list) {
            try {
                if (overrideMessageProxyListener == null) continue;
                proxy.removeOverrideMessageProxyListener(overrideMessageProxyListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void hookPersistentConnectionListener(Proxy proxy) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            ExtensionLoader.hookPersistentConnectionListeners(proxy, extensionHook.getPersistentConnectionListener());
        }
    }

    private static void hookPersistentConnectionListeners(Proxy proxy, List<PersistentConnectionListener> list) {
        for (PersistentConnectionListener persistentConnectionListener : list) {
            try {
                if (persistentConnectionListener == null) continue;
                proxy.addPersistentConnectionListener(persistentConnectionListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void removePersistentConnectionListener(ExtensionHook extensionHook) {
        Proxy proxy = Control.getSingleton().getProxy();
        Vector<PersistentConnectionListener> vector = extensionHook.getPersistentConnectionListener();
        for (PersistentConnectionListener persistentConnectionListener : vector) {
            try {
                if (persistentConnectionListener == null) continue;
                proxy.removePersistentConnectionListener(persistentConnectionListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void hookSiteMapListener(SiteMapPanel siteMapPanel) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            ExtensionLoader.hookSiteMapListeners(siteMapPanel, extensionHook.getSiteMapListenerList());
        }
    }

    private static void hookSiteMapListeners(SiteMapPanel siteMapPanel, List<SiteMapListener> list) {
        for (SiteMapListener siteMapListener : list) {
            try {
                if (siteMapListener == null) continue;
                siteMapPanel.addSiteMapListener(siteMapListener);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void removeSiteMapListener(ExtensionHook extensionHook) {
        if (this.view != null) {
            SiteMapPanel siteMapPanel = this.view.getSiteTreePanel();
            Vector<SiteMapListener> vector = extensionHook.getSiteMapListenerList();
            for (SiteMapListener siteMapListener : vector) {
                try {
                    if (siteMapListener == null) continue;
                    siteMapPanel.removeSiteMapListener(siteMapListener);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void hookScannerHook(Scanner scanner) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<ScannerHook> vector = extensionHook.getScannerHookList();
            for (ScannerHook scannerHook : vector) {
                try {
                    if (extensionHook == null) continue;
                    scanner.addScannerHook(scannerHook);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void optionsChangedAllPlugin(OptionsParam optionsParam) {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<OptionsChangedListener> vector = extensionHook.getOptionsChangedListenerList();
            for (OptionsChangedListener optionsChangedListener : vector) {
                try {
                    if (optionsChangedListener == null) continue;
                    optionsChangedListener.optionsChanged(optionsParam);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void runCommandLine() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            if (!(extension instanceof CommandLineListener)) continue;
            CommandLineListener commandLineListener = (CommandLineListener)((Object)extension);
            commandLineListener.execute(this.extensionHooks.get(extension).getCommandLineArgument());
        }
    }

    public void sessionChangedAllPlugin(Session session) {
        logger.debug((Object)"sessionChangedAllPlugin");
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> vector = extensionHook.getSessionListenerList();
            for (SessionChangedListener sessionChangedListener : vector) {
                try {
                    if (sessionChangedListener == null) continue;
                    sessionChangedListener.sessionChanged(session);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void databaseOpen(Database database) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                extension.databaseOpen(database);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void sessionAboutToChangeAllPlugin(Session session) {
        logger.debug((Object)"sessionAboutToChangeAllPlugin");
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> vector = extensionHook.getSessionListenerList();
            for (SessionChangedListener sessionChangedListener : vector) {
                try {
                    if (sessionChangedListener == null) continue;
                    sessionChangedListener.sessionAboutToChange(session);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void sessionScopeChangedAllPlugin(Session session) {
        logger.debug((Object)"sessionScopeChangedAllPlugin");
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> vector = extensionHook.getSessionListenerList();
            for (SessionChangedListener sessionChangedListener : vector) {
                try {
                    if (sessionChangedListener == null) continue;
                    sessionChangedListener.sessionScopeChanged(session);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void sessionModeChangedAllPlugin(Control.Mode mode) {
        logger.debug((Object)"sessionModeChangedAllPlugin");
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> vector = extensionHook.getSessionListenerList();
            for (SessionChangedListener sessionChangedListener : vector) {
                try {
                    if (sessionChangedListener == null) continue;
                    sessionChangedListener.sessionModeChanged(mode);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void addonFilesAdded() {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> list = extensionHook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener addonFilesChangedListener : list) {
                try {
                    addonFilesChangedListener.filesAdded();
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void addonFilesRemoved() {
        for (ExtensionHook extensionHook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> list = extensionHook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener addonFilesChangedListener : list) {
                try {
                    addonFilesChangedListener.filesRemoved();
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public void startAllExtension(double d) {
        double d2 = d / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).start();
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(d2);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void startLifeCycle() {
        if (this.view != null) {
            this.view.setSplashScreenLoadingCompletion(0.0);
        }
        this.initAllExtension(5.0);
        this.initModelAllExtension(this.model, 0.0);
        this.initXMLAllExtension(this.model.getSession(), this.model.getOptionsParam(), 0.0);
        this.initViewAllExtension(this.view, 10.0);
        this.hookAllExtension(75.0);
        this.startAllExtension(10.0);
    }

    public void startLifeCycle(Extension extension) throws DatabaseException, DatabaseUnsupportedException {
        extension.init();
        extension.databaseOpen(this.model.getDb());
        extension.initModel(this.model);
        extension.initXML(this.model.getSession(), this.model.getOptionsParam());
        extension.initView(this.view);
        ExtensionHook extensionHook = new ExtensionHook(this.model, this.view);
        try {
            extension.hook(extensionHook);
            this.extensionHooks.put(extension, extensionHook);
            if (this.view != null) {
                this.hookView(this.view, extensionHook);
                this.hookMenu(this.view, extensionHook);
            }
            this.hookOptions(extensionHook);
            extension.optionsLoaded();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        extension.start();
        Proxy proxy = Control.getSingleton().getProxy();
        ExtensionLoader.hookProxyListeners(proxy, extensionHook.getProxyListenerList());
        ExtensionLoader.hookPersistentConnectionListeners(proxy, extensionHook.getPersistentConnectionListener());
        if (this.view != null) {
            ExtensionLoader.hookSiteMapListeners(this.view.getSiteTreePanel(), extensionHook.getSiteMapListenerList());
        }
    }

    public void stopAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).stop();
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void addParamPanel(List<AbstractParamPanel> list, AbstractParamDialog abstractParamDialog) {
        String[] stringArray = new String[]{};
        for (AbstractParamPanel abstractParamPanel : list) {
            try {
                abstractParamDialog.addParamPanel(stringArray, abstractParamPanel, true);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void removeParamPanel(List<AbstractParamPanel> list, AbstractParamDialog abstractParamDialog) {
        for (AbstractParamPanel abstractParamPanel : list) {
            try {
                abstractParamDialog.removeParamPanel(abstractParamPanel);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        abstractParamDialog.revalidate();
    }

    private void addTabPanel(List<AbstractPanel> list, TabbedPanel2 tabbedPanel2) {
        for (AbstractPanel abstractPanel : list) {
            try {
                tabbedPanel2.addTab(abstractPanel);
                if (abstractPanel.getTabIndex() != 0 || tabbedPanel2.indexOfComponent(abstractPanel) == -1) continue;
                tabbedPanel2.setSelectedComponent(abstractPanel);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void removeTabPanel(List<AbstractPanel> list, TabbedPanel2 tabbedPanel2) {
        for (AbstractPanel abstractPanel : list) {
            try {
                tabbedPanel2.removeTab(abstractPanel);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        tabbedPanel2.revalidate();
    }

    private void hookAllExtension(double d) {
        int n;
        final double d2 = d / (double)this.getExtensionCount();
        for (n = 0; n < this.getExtensionCount(); ++n) {
            try {
                Extension extension = this.getExtension(n);
                logger.info((Object)("Initializing " + extension.getDescription()));
                final ExtensionHook extensionHook = new ExtensionHook(this.model, this.view);
                extension.hook(extensionHook);
                this.extensionHooks.put(extension, extensionHook);
                if (this.view != null) {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ExtensionLoader.this.hookView(ExtensionLoader.this.view, extensionHook);
                            ExtensionLoader.this.hookMenu(ExtensionLoader.this.view, extensionHook);
                            ExtensionLoader.this.view.addSplashScreenLoadingCompletion(d2);
                        }
                    });
                }
                this.hookOptions(extensionHook);
                extension.optionsLoaded();
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)throwable.getMessage(), throwable);
            }
        }
        for (n = 0; n < this.getExtensionCount(); ++n) {
            try {
                this.getExtension(n).postInit();
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)throwable.getMessage(), throwable);
            }
        }
        if (this.view != null) {
            this.view.getMainFrame().getMainMenuBar().validate();
            this.view.getMainFrame().validate();
        }
    }

    public void hookCommandLineListener(CommandLine commandLine) throws Exception {
        ArrayList<CommandLineArgument[]> arrayList = new ArrayList<CommandLineArgument[]>();
        HashMap<String, CommandLineListener> hashMap = new HashMap<String, CommandLineListener>();
        for (Map.Entry<Extension, ExtensionHook> entry : this.extensionHooks.entrySet()) {
            CommandLineListener commandLineListener;
            List<String> list;
            Extension extension;
            ExtensionHook extensionHook = entry.getValue();
            CommandLineArgument[] commandLineArgumentArray = extensionHook.getCommandLineArgument();
            if (commandLineArgumentArray.length > 0) {
                arrayList.add(commandLineArgumentArray);
            }
            if (!((extension = entry.getKey()) instanceof CommandLineListener) || (list = (commandLineListener = (CommandLineListener)((Object)extension)).getHandledExtensions()) == null) continue;
            for (String string : list) {
                hashMap.put(string, commandLineListener);
            }
        }
        commandLine.parse(arrayList, hashMap);
    }

    private void hookMenu(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookMenu extensionHookMenu = extensionHook.getHookMenu();
        if (extensionHookMenu == null) {
            return;
        }
        MainMenuBar mainMenuBar = view.getMainFrame().getMainMenuBar();
        this.addMenuHelper(mainMenuBar, extensionHookMenu.getNewMenus(), 2);
        this.addMenuHelper(mainMenuBar.getMenuFile(), extensionHookMenu.getFile(), 2);
        this.addMenuHelper(mainMenuBar.getMenuTools(), extensionHookMenu.getTools(), 2);
        this.addMenuHelper(mainMenuBar.getMenuEdit(), extensionHookMenu.getEdit());
        this.addMenuHelper(mainMenuBar.getMenuView(), extensionHookMenu.getView());
        this.addMenuHelper(mainMenuBar.getMenuAnalyse(), extensionHookMenu.getAnalyse());
        this.addMenuHelper(mainMenuBar.getMenuHelp(), extensionHookMenu.getHelpMenus());
        this.addMenuHelper(mainMenuBar.getMenuReport(), extensionHookMenu.getReportMenus());
        this.addMenuHelper(mainMenuBar.getMenuOnline(), extensionHookMenu.getOnlineMenus());
        this.addMenuHelper(view.getPopupList(), extensionHookMenu.getPopupMenus());
    }

    private void addMenuHelper(JMenu jMenu, List<JMenuItem> list) {
        this.addMenuHelper(jMenu, list, 0);
    }

    private void addMenuHelper(JMenuBar jMenuBar, List<JMenuItem> list, int n) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem == null) continue;
            jMenuBar.add((Component)jMenuItem, jMenuBar.getMenuCount() - n);
        }
        jMenuBar.revalidate();
    }

    private void addMenuHelper(JMenu jMenu, List<JMenuItem> list, int n) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu.addSeparator();
                continue;
            }
            jMenu.add((Component)jMenuItem, jMenu.getItemCount() - n);
        }
        jMenu.revalidate();
    }

    private void addMenuHelper(List<JMenuItem> list, List<JMenuItem> list2) {
        for (JMenuItem jMenuItem : list2) {
            if (jMenuItem == null) continue;
            list.add(jMenuItem);
        }
    }

    private void removeMenu(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookMenu extensionHookMenu = extensionHook.getHookMenu();
        if (extensionHookMenu == null) {
            return;
        }
        MainMenuBar mainMenuBar = view.getMainFrame().getMainMenuBar();
        this.removeMenuHelper(mainMenuBar, extensionHookMenu.getNewMenus());
        this.removeMenuHelper(mainMenuBar.getMenuFile(), extensionHookMenu.getFile());
        this.removeMenuHelper(mainMenuBar.getMenuTools(), extensionHookMenu.getTools());
        this.removeMenuHelper(mainMenuBar.getMenuEdit(), extensionHookMenu.getEdit());
        this.removeMenuHelper(mainMenuBar.getMenuView(), extensionHookMenu.getView());
        this.removeMenuHelper(mainMenuBar.getMenuAnalyse(), extensionHookMenu.getAnalyse());
        this.removeMenuHelper(mainMenuBar.getMenuHelp(), extensionHookMenu.getHelpMenus());
        this.removeMenuHelper(mainMenuBar.getMenuReport(), extensionHookMenu.getReportMenus());
        this.removeMenuHelper(mainMenuBar.getMenuOnline(), extensionHookMenu.getOnlineMenus());
        this.removeMenuHelper(view.getPopupList(), extensionHookMenu.getPopupMenus());
        view.refreshTabViewMenus();
    }

    private void removeMenuHelper(JMenuBar jMenuBar, List<JMenuItem> list) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem == null) continue;
            jMenuBar.remove(jMenuItem);
        }
        jMenuBar.revalidate();
    }

    private void removeMenuHelper(JMenu jMenu, List<JMenuItem> list) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem == null) continue;
            jMenu.remove(jMenuItem);
        }
        jMenu.revalidate();
    }

    private void removeMenuHelper(List<JMenuItem> list, List<JMenuItem> list2) {
        for (JMenuItem jMenuItem : list2) {
            if (jMenuItem == null) continue;
            list.remove(jMenuItem);
        }
    }

    private void hookOptions(ExtensionHook extensionHook) {
        Vector<AbstractParam> vector = extensionHook.getOptionsParamSetList();
        for (AbstractParam abstractParam : vector) {
            try {
                this.model.getOptionsParam().addParamSet(abstractParam);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void unloadOptions(ExtensionHook extensionHook) {
        Vector<AbstractParam> vector = extensionHook.getOptionsParamSetList();
        for (AbstractParam abstractParam : vector) {
            try {
                this.model.getOptionsParam().removeParamSet(abstractParam);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void hookView(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        if (extensionHookView == null) {
            return;
        }
        int n = Model.getSingleton().getOptionsParam().getViewParam().getDisplayOption();
        this.addTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedSelect());
        this.addTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedWork());
        this.addTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
        if (n == 2) {
            view.getWorkbench().setTabbedOldWork(view.getWorkbench().getTabbedWork());
            view.getWorkbench().setTabbedOldSelect(view.getWorkbench().getTabbedSelect());
            view.getWorkbench().setTabbedOldStatus(view.getWorkbench().getTabbedStatus());
            this.addTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedStatus());
            this.addTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedStatus());
            this.addTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
        }
        this.addParamPanel(extensionHookView.getSessionPanel(), view.getSessionDialog());
        this.addParamPanel(extensionHookView.getOptionsPanel(), view.getOptionsDialog(""));
    }

    private void removeView(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        if (extensionHookView == null) {
            return;
        }
        int n = Model.getSingleton().getOptionsParam().getViewParam().getDisplayOption();
        switch (n) {
            case 2: {
                this.removeTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedStatus());
                this.removeTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedStatus());
                this.removeTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
                break;
            }
            default: {
                this.removeTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedSelect());
                this.removeTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedWork());
                this.removeTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
            }
        }
        this.removeParamPanel(extensionHookView.getSessionPanel(), view.getSessionDialog());
        this.removeParamPanel(extensionHookView.getOptionsPanel(), view.getOptionsDialog(""));
    }

    public void removeStatusPanel(AbstractPanel abstractPanel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getWorkbench().getTabbedStatus().remove(abstractPanel);
    }

    public void removeOptionsPanel(AbstractParamPanel abstractParamPanel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getOptionsDialog("").removeParamPanel(abstractParamPanel);
    }

    public void removeOptionsParamSet(AbstractParam abstractParam) {
        this.model.getOptionsParam().removeParamSet(abstractParam);
    }

    public void removeWorkPanel(AbstractPanel abstractPanel) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getWorkbench().getTabbedWork().remove(abstractPanel);
    }

    public void removePopupMenuItem(ExtensionPopupMenuItem extensionPopupMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getPopupList().remove(extensionPopupMenuItem);
    }

    public void removeFileMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuFile().remove(jMenuItem);
    }

    public void removeEditMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuEdit().remove(jMenuItem);
    }

    public void removeViewMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuView().remove(jMenuItem);
    }

    public void removeToolsMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuTools().remove(jMenuItem);
    }

    public void removeHelpMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuHelp().remove(jMenuItem);
    }

    public void removeReportMenuItem(JMenuItem jMenuItem) {
        if (!View.isInitialised()) {
            return;
        }
        View.getSingleton().getMainFrame().getMainMenuBar().getMenuReport().remove(jMenuItem);
    }

    private void initAllExtension(double d) {
        double d2 = d / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).init();
                this.getExtension(i).databaseOpen(Model.getSingleton().getDb());
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(d2);
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)throwable.getMessage(), throwable);
            }
        }
    }

    private void initModelAllExtension(Model model, double d) {
        double d2 = d / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).initModel(model);
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(d2);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void initViewAllExtension(final View view, double d) {
        if (view == null) {
            return;
        }
        final double d2 = d / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                final Extension extension = this.getExtension(i);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        extension.initView(view);
                        view.addSplashScreenLoadingCompletion(d2);
                    }
                });
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void initXMLAllExtension(Session session, OptionsParam optionsParam, double d) {
        double d2 = d / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).initXML(session, optionsParam);
                if (this.view == null) continue;
                this.view.addSplashScreenLoadingCompletion(d2);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void removeExtension(Extension extension, ExtensionHook extensionHook) {
        this.extensionList.remove(extension);
        this.extensionsMap.remove(extension.getClass());
        if (extensionHook == null) {
            logger.info((Object)("ExtensionHook is null for \"" + extension.getClass().getCanonicalName() + "\" the hooked objects will not be automatically removed."));
            return;
        }
        this.extensionHooks.values().remove(extensionHook);
        this.unloadOptions(extensionHook);
        this.removePersistentConnectionListener(extensionHook);
        this.removeProxyListener(extensionHook);
        this.removeOverrideMessageProxyListener(extensionHook);
        this.removeSiteMapListener(extensionHook);
        this.removeViewInEDT(extensionHook);
    }

    private void removeViewInEDT(final ExtensionHook extensionHook) {
        if (this.view == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.removeView(this.view, extensionHook);
            this.removeMenu(this.view, extensionHook);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionLoader.this.removeViewInEDT(extensionHook);
                }
            });
        }
    }

    public List<String> getUnsavedResources() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            List<String> list = this.getExtension(i).getUnsavedResources();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<String> getActiveActions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            List<String> list = this.getExtension(i).getActiveActions();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

