/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.NullType;
import org.hsqldb.types.Type;

public class Expression
implements Cloneable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    static final Expression[] emptyArray = new Expression[0];
    static final Expression EXPR_TRUE = new ExpressionLogical(true);
    static final Expression EXPR_FALSE = new ExpressionLogical(false);
    static final OrderedIntHashSet aggregateFunctionSet = new OrderedIntHashSet();
    static final OrderedIntHashSet columnExpressionSet;
    static final OrderedIntHashSet subqueryExpressionSet;
    static final OrderedIntHashSet subqueryAggregateExpressionSet;
    static final OrderedIntHashSet functionExpressionSet;
    static final OrderedIntHashSet emptyExpressionSet;
    protected int opType;
    protected int exprSubType;
    HsqlNameManager.SimpleName alias;
    private boolean isAggregate;
    protected Object valueData;
    protected Expression[] nodes;
    Type[] nodeDataTypes;
    TableDerived table;
    boolean isCorrelated;
    int columnIndex = -1;
    protected Type dataType;
    int queryTableColumnIndex = -1;
    int parameterIndex = -1;
    int rangePosition = -1;
    boolean isColumnCondition;
    boolean isColumnEqual;
    boolean isSingleColumnCondition;
    boolean isSingleColumnEqual;
    boolean isSingleColumnNull;
    boolean isSingleColumnNotNull;
    byte nullability = (byte)2;
    Collation collation;

    Expression(int n) {
        this.opType = n;
        this.nodes = emptyArray;
    }

    Expression(int n, TableDerived tableDerived) {
        switch (n) {
            case 19: {
                this.opType = 19;
                break;
            }
            case 100: {
                this.opType = 100;
                break;
            }
            case 23: {
                this.opType = 23;
                break;
            }
            case 21: 
            case 22: {
                this.opType = 22;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        this.nodes = emptyArray;
        this.table = tableDerived;
    }

    Expression(int n, Expression[] expressionArray) {
        this(n);
        this.nodes = expressionArray;
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String string = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 93: 
            case 96: {
                return string;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        string = stringBuffer.append('(').append(string).append(')').toString();
        return string;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                stringBuffer.append('(');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.nodes[i].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 26: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.nodes[i].getSQL());
                }
                return stringBuffer.toString();
            }
        }
        switch (this.opType) {
            case 19: {
                stringBuffer.append("ARRAY").append('[');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.nodes[i].getSQL());
                }
                stringBuffer.append(']');
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                stringBuffer.append('(');
                stringBuffer.append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
            case 19: {
                stringBuffer.append("ARRAY ");
                return stringBuffer.toString();
            }
            case 100: {
                stringBuffer.append("ARRAY SUBQUERY");
                return stringBuffer.toString();
            }
            case 22: 
            case 23: {
                stringBuffer.append("QUERY ");
                stringBuffer.append(this.table.queryExpression.describe(session, n));
                return stringBuffer.toString();
            }
            case 25: {
                stringBuffer.append("ROW = ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuffer.append(this.nodes[n2].describe(session, n + 1));
                    stringBuffer.append(' ');
                }
                break;
            }
            case 26: {
                stringBuffer.append("VALUELIST ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuffer.append(this.nodes[n2].describe(session, n + 1));
                    stringBuffer.append(' ');
                }
                break;
            }
        }
        return stringBuffer.toString();
    }

    void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    public boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType || this.exprSubType != expression.exprSubType || !Expression.equals(this.dataType, expression.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == expression.columnIndex;
            }
            case 1: {
                return Expression.equals(this.valueData, expression.valueData);
            }
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                return this.table.queryExpression.isEquivalent(expression.table.queryExpression);
            }
        }
        return Expression.equals(this.nodes, expression.nodes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Expression) {
            return this.equals((Expression)object);
        }
        return false;
    }

    public int hashCode() {
        int n = this.opType + this.exprSubType;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            n += this.nodes[i].hashCode();
        }
        return n;
    }

    static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object == null ? object2 == null : object.equals(object2);
    }

    static boolean equals(Expression[] expressionArray, Expression[] expressionArray2) {
        if (expressionArray == expressionArray2) {
            return true;
        }
        if (expressionArray.length != expressionArray2.length) {
            return false;
        }
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Expression expression = expressionArray[i];
            Expression expression2 = expressionArray2[i];
            boolean bl2 = expression == null ? expression2 == null : (bl = expression.equals(expression2));
            if (bl) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] expressionArray, int n, int n2, OrderedIntHashSet orderedIntHashSet) {
        int n3;
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n3 = n; n3 < n2; n3 += 1) {
            if (!this.equals(expressionArray[n3])) continue;
            return true;
        }
        switch (this.opType) {
            case 19: 
            case 23: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 100: {
                return false;
            }
            case 22: {
                if (this.table == null) break;
                if (!(this.table.getQueryExpression() instanceof QuerySpecification)) {
                    return false;
                }
                QuerySpecification querySpecification = (QuerySpecification)this.table.getQueryExpression();
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                for (int i = n; i < n2; ++i) {
                    if (expressionArray[i].opType != 2) continue;
                    orderedHashSet.add(expressionArray[i]);
                }
                return querySpecification.collectOuterColumnExpressions(null, orderedHashSet) == null;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        n3 = 1;
        for (int i = 0; i < this.nodes.length; ++i) {
            n3 &= this.nodes[i] == null || this.nodes[i].isComposedOf(expressionArray, n, n2, orderedIntHashSet);
        }
        return n3 != 0;
    }

    boolean isComposedOf(OrderedHashSet orderedHashSet, RangeGroup[] rangeGroupArray, OrderedIntHashSet orderedIntHashSet) {
        int n;
        if (this.opType == 1 || this.opType == 8 || this.opType == 7 || this.opType == 6) {
            return true;
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n = 0; n < orderedHashSet.size(); n += 1) {
            if (!this.equals(orderedHashSet.get(n))) continue;
            return true;
        }
        if (this.opType == 2) {
            for (n = 0; n < rangeGroupArray.length; n += 1) {
                RangeVariable[] rangeVariableArray = rangeGroupArray[n].getRangeVariables();
                for (int i = 0; i < rangeVariableArray.length; ++i) {
                    if (rangeVariableArray[i] != this.getRangeVariable()) continue;
                    return true;
                }
            }
        }
        switch (this.opType) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return false;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        n = 1;
        for (int i = 0; i < this.nodes.length; ++i) {
            n &= this.nodes[i] == null || this.nodes[i].isComposedOf(orderedHashSet, rangeGroupArray, orderedIntHashSet);
        }
        return n != 0;
    }

    Expression replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceColumnReferences(rangeVariable, expressionArray);
        }
        return this;
    }

    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    void resetColumnReferences() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resetColumnReferences();
        }
    }

    void convertToSimpleColumn(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        if (this.opType == 1) {
            return;
        }
        if (this.opType == 5) {
            return;
        }
        int n = orderedHashSet.getIndex(this);
        if (n != -1) {
            Expression expression = (Expression)orderedHashSet2.get(n);
            this.nodes = emptyArray;
            this.opType = 5;
            this.columnIndex = expression.columnIndex;
            this.rangePosition = expression.rangePosition;
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].convertToSimpleColumn(orderedHashSet, orderedHashSet2);
        }
        if (this.table != null && this.table.queryExpression != null) {
            OrderedHashSet orderedHashSet3 = new OrderedHashSet();
            this.table.queryExpression.collectAllExpressions(orderedHashSet3, columnExpressionSet, emptyExpressionSet);
            for (int i = 0; i < orderedHashSet3.size(); ++i) {
                Expression expression = (Expression)orderedHashSet3.get(i);
                expression.convertToSimpleColumn(orderedHashSet, orderedHashSet2);
            }
        }
    }

    boolean isAggregate() {
        return this.isAggregate;
    }

    void setAggregate() {
        this.isAggregate = true;
    }

    boolean isSelfAggregate() {
        return false;
    }

    void setAlias(HsqlNameManager.SimpleName simpleName) {
        this.alias = simpleName;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        return null;
    }

    public int getType() {
        return this.opType;
    }

    Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    void setLeftNode(Expression expression) {
        this.nodes[0] = expression;
    }

    void setRightNode(Expression expression) {
        this.nodes[1] = expression;
    }

    void setSubType(int n) {
        this.exprSubType = n;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Session session, Expression[] expressionArray, int n) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(session, expressionArray, n);
        }
        return this;
    }

    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    void collectObjectNames(Set set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectObjectNames(set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.collectObjectNames(set);
        }
    }

    boolean hasReference(RangeVariable rangeVariable) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(rangeVariable)) continue;
            return true;
        }
        return this.table != null && this.table.queryExpression != null && this.table.queryExpression.hasReference(rangeVariable);
    }

    boolean hasReference(RangeVariable[] rangeVariableArray, int n) {
        OrderedHashSet orderedHashSet = this.collectRangeVariables(rangeVariableArray, null);
        if (orderedHashSet == null) {
            return false;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (orderedHashSet.get(i) == rangeVariableArray[n]) continue;
            return true;
        }
        return false;
    }

    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray, HsqlList hsqlList) {
        return this.resolveColumnReferences(session, rangeGroup, rangeGroup.getRangeVariables().length, rangeGroupArray, hsqlList, true);
    }

    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        if (this.opType == 1) {
            return hsqlList;
        }
        switch (this.opType) {
            case 26: 
            case 30: {
                if (this.table != null) {
                    if (rangeGroup.getRangeVariables().length > n) {
                        RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeGroup.getRangeVariables(), n);
                        rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                    }
                    rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                    rangeGroup = new RangeGroup.RangeGroupSimple(this.table);
                    n = 0;
                }
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
                }
                return hsqlList;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
        }
        switch (this.opType) {
            case 19: {
                break;
            }
            case 22: 
            case 23: 
            case 100: {
                Expression expression;
                RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
                if (rangeVariableArray.length > n) {
                    rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeVariableArray, n);
                    rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                }
                rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveReferences(session, rangeGroupArray);
                    if (!queryExpression.areColumnsResolved()) {
                        if (hsqlList == null) {
                            hsqlList = new ArrayListIdentity();
                        }
                        hsqlList.addAll(queryExpression.getUnresolvedExpressions());
                    }
                }
                if ((expression = this.table.dataExpression) == null) break;
                hsqlList = expression.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
                break;
            }
        }
        return hsqlList;
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        if (this.opType == 1) {
            return orderedHashSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].getUnkeyedColumns(orderedHashSet);
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 100: {
                if (this.table == null) break;
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet();
                }
                orderedHashSet.add(this);
            }
        }
        return orderedHashSet;
    }

    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n] == null) continue;
                    this.nodeDataTypes[n] = this.nodes[n].dataType;
                }
                break;
            }
            case 19: {
                int n2;
                Type type = null;
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    type = Type.getAggregateType(type, this.nodes[n2].dataType);
                }
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    this.nodes[n2].dataType = type;
                }
                if (type != null) {
                    for (n2 = 0; n2 < this.nodes.length; ++n2) {
                        if (this.nodes[n2].valueData == null) continue;
                        this.nodes[n2].valueData = type.convertToDefaultType(session, this.nodes[n2].valueData);
                    }
                }
                this.dataType = new ArrayType(type, this.nodes.length);
                return;
            }
            case 100: {
                QueryExpression queryExpression = this.table.queryExpression;
                queryExpression.resolveTypes(session);
                this.table.prepareTable();
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                if (this.nodeDataTypes.length > 1) {
                    throw Error.error(5564);
                }
                this.dataType = new ArrayType(this.dataType, this.nodes.length);
                break;
            }
            case 22: 
            case 23: {
                Expression expression2;
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveTypes(session);
                }
                if ((expression2 = this.table.dataExpression) != null) {
                    expression2.resolveTypes(session, null);
                }
                this.table.prepareTable();
                this.nodeDataTypes = this.table.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session) {
        this.valueData = this.getValue(session);
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void setAsConstantValue(Object object) {
        this.valueData = object;
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void prepareTable(Session session, Expression expression, int n) {
        Cloneable cloneable;
        int n2;
        if (this.nodeDataTypes != null) {
            return;
        }
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            cloneable = this.nodes[n2];
            if (((Expression)cloneable).opType == 25) {
                if (n == ((Expression)cloneable).nodes.length) continue;
                throw Error.error(5564);
            }
            if (n == 1) {
                this.nodes[n2] = new Expression(25);
                this.nodes[n2].nodes = new Expression[]{cloneable};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            cloneable = expression == null ? null : expression.nodes[n2].dataType;
            boolean bl = expression == null ? false : expression.nodes[n2].isUnresolvedParam();
            for (n3 = 0; n3 < this.nodes.length; ++n3) {
                cloneable = Type.getAggregateType(this.nodes[n3].nodes[n2].dataType, (Type)cloneable);
                bl |= this.nodes[n3].nodes[n2].isUnresolvedParam();
            }
            if (cloneable == null) {
                cloneable = Type.SQL_VARCHAR_DEFAULT;
            }
            n3 = ((Type)cloneable).typeCode;
            if (bl && ((Type)cloneable).isCharacterType() && (n3 == 1 || ((Type)cloneable).precision < Type.SQL_VARCHAR_DEFAULT.precision)) {
                if (n3 == 1) {
                    n3 = 12;
                }
                long l = Math.max(Type.SQL_VARCHAR_DEFAULT.precision, ((Type)cloneable).precision);
                cloneable = CharacterType.getCharacterType(n3, l, ((Type)cloneable).getCollation());
            }
            this.nodeDataTypes[n2] = cloneable;
            if (expression != null && expression.nodes[n2].isUnresolvedParam()) {
                expression.nodes[n2].dataType = cloneable;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].nodes[n2].isUnresolvedParam()) {
                    this.nodes[i].nodes[n2].dataType = this.nodeDataTypes[n2];
                    continue;
                }
                if (this.nodes[i].nodes[n2].opType != 1 || this.nodes[i].nodes[n2].valueData != null) continue;
                this.nodes[i].nodes[n2].dataType = this.nodeDataTypes[n2];
            }
            if (this.nodeDataTypes[n2].isCharacterType() && ((CharacterType)this.nodeDataTypes[n2]).isEqualIdentical()) continue;
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Object[] objectArray = this.nodes[i].getRowValue(session);
            for (int j = 0; j < this.nodeDataTypes.length; ++j) {
                objectArray[j] = this.nodeDataTypes[j].convertToType(session, objectArray[j], this.nodes[i].nodes[j].dataType);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
            try {
                persistentStore.indexRow(session, row);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    String getColumnName() {
        return this.getAlias();
    }

    public ColumnSchema getColumn() {
        return null;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    Type getDataType() {
        return this.dataType;
    }

    byte getNullability() {
        return this.nullability;
    }

    Type getNodeDataType(int n) {
        if (this.nodeDataTypes == null) {
            if (n > 0) {
                throw Error.runtimeError(201, "Expression");
            }
            return this.dataType;
        }
        return this.nodeDataTypes[n];
    }

    Type[] getNodeDataTypes() {
        if (this.nodeDataTypes == null) {
            return new Type[]{this.dataType};
        }
        return this.nodeDataTypes;
    }

    int getDegree() {
        switch (this.opType) {
            case 25: {
                return this.nodes.length;
            }
            case 22: 
            case 23: 
            case 30: {
                if (this.table == null) {
                    return this.nodeDataTypes.length;
                }
                return this.table.queryExpression.getColumnCount();
            }
        }
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void materialise(Session session) {
        if (this.table == null) {
            return;
        }
        if (this.table.isCorrelated()) {
            this.table.materialiseCorrelated(session);
        } else {
            this.table.materialise(session);
        }
    }

    Object getValue(Session session, Type type) {
        Object object = this.getValue(session);
        if (object == null || this.dataType == type) {
            return object;
        }
        return type.convertToType(session, object, this.dataType);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object object = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return object;
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 19: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 100: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                int n = rowSetNavigatorData.getSize();
                Object[] objectArray = new Object[n];
                rowSetNavigatorData.beforeFirst();
                int n2 = 0;
                while (rowSetNavigatorData.hasNext()) {
                    Object[] objectArray2 = rowSetNavigatorData.getNextRowData();
                    objectArray[n2] = objectArray2[0];
                    ++n2;
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                this.table.materialiseCorrelated(session);
                Object[] objectArray = this.table.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 19: {
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Object[] objectArray = new Object[rowSetNavigatorData.getSize()];
                rowSetNavigatorData.beforeFirst();
                int n = 0;
                while (rowSetNavigatorData.hasNext()) {
                    Object[] objectArray2 = rowSetNavigatorData.getNext();
                    objectArray[n] = objectArray2[0];
                    ++n;
                }
                return Result.newPSMResult(objectArray);
            }
            case 23: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.table.queryExpression.getMetaData();
                return result;
            }
        }
        Object object = this.getValue(session);
        return Result.newPSMResult(object);
    }

    public boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            ++n;
        }
        return n;
    }

    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    static void convertToType(Session session, Object[] objectArray, Type[] typeArray, Type[] typeArray2) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (typeArray[i].typeComparisonGroup == typeArray2[i].typeComparisonGroup) continue;
            objectArray[i] = typeArray2[i].convertToType(session, objectArray[i], typeArray[i]);
        }
    }

    static QuerySpecification getCheckSelect(Session session, Table table, Expression expression) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session, null);
        compileContext.reset(0);
        QuerySpecification querySpecification = new QuerySpecification(compileContext);
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        RangeVariable[] rangeVariableArray = new RangeVariable[]{rangeVariable};
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray);
        expression.resolveCheckOrGenExpression(session, rangeGroupSimple, true);
        if (Type.SQL_BOOLEAN != expression.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(48, expression);
        querySpecification.addSelectColumnExpression(EXPR_TRUE);
        querySpecification.addRangeVariable(session, rangeVariable);
        querySpecification.addQueryCondition(expressionLogical);
        querySpecification.resolve(session);
        return querySpecification;
    }

    public void resolveCheckOrGenExpression(Session session, RangeGroup rangeGroup, boolean bl) {
        int n;
        Object object;
        boolean bl2 = false;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlList hsqlList = this.resolveColumnReferences(session, rangeGroup, RangeGroup.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        this.resolveTypes(session, null);
        this.collectAllExpressions(orderedHashSet, subqueryAggregateExpressionSet, emptyExpressionSet);
        if (!orderedHashSet.isEmpty()) {
            throw Error.error(5512);
        }
        this.collectAllExpressions(orderedHashSet, functionExpressionSet, emptyExpressionSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Expression expression = (Expression)orderedHashSet.get(i);
            if (expression.opType == 27 && !((FunctionSQLInvoked)expression).isDeterministic()) {
                throw Error.error(5512);
            }
            if (expression.opType != 28 || ((FunctionSQL)expression).isDeterministic()) continue;
            if (bl) {
                bl2 = true;
                continue;
            }
            throw Error.error(5512);
        }
        if (bl && bl2) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            RangeVariableResolver.decomposeAndConditions(session, this, hsqlArrayList);
            block9: for (int i = 0; i < hsqlArrayList.size(); ++i) {
                bl2 = true;
                object = (Expression)hsqlArrayList.get(i);
                if (!(object instanceof ExpressionLogical) || (n = ((ExpressionLogical)object).convertToSmaller()) == 0) break;
                Expression expression = ((Expression)object).getRightNode();
                object = ((Expression)object).getLeftNode();
                if (!((Expression)object).dataType.isDateTimeType()) {
                    bl2 = true;
                    break;
                }
                if (((Expression)object).hasNonDeterministicFunction()) {
                    bl2 = true;
                    break;
                }
                if (expression instanceof ExpressionArithmetic) {
                    if (this.opType == 32) {
                        if (expression.getRightNode().hasNonDeterministicFunction()) {
                            expression.swapLeftAndRightNodes();
                        }
                    } else if (this.opType != 33) break;
                    if (expression.getRightNode().hasNonDeterministicFunction()) break;
                    expression = expression.getLeftNode();
                }
                if (expression.opType != 28) break;
                FunctionSQL functionSQL = (FunctionSQL)expression;
                switch (functionSQL.funcType) {
                    case 43: 
                    case 50: 
                    case 52: {
                        bl2 = false;
                        continue block9;
                    }
                }
            }
            if (bl2) {
                throw Error.error(5512);
            }
        }
        orderedHashSet.clear();
        this.collectObjectNames(orderedHashSet);
        RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
        block10: for (int i = 0; i < orderedHashSet.size(); ++i) {
            object = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            switch (((HsqlNameManager.HsqlName)object).type) {
                case 9: {
                    int n2;
                    ColumnSchema columnSchema;
                    if (bl || !(columnSchema = rangeVariableArray[0].rangeTable.getColumn(n2 = rangeVariableArray[0].rangeTable.findColumn(((HsqlNameManager.HsqlName)object).name))).isGenerated()) continue block10;
                    throw Error.error(5512);
                }
                case 7: {
                    throw Error.error(5512);
                }
                case 24: {
                    Routine routine = (Routine)session.database.schemaManager.getSchemaObject((HsqlNameManager.HsqlName)object);
                    if (!routine.isDeterministic()) {
                        throw Error.error(5512);
                    }
                    n = routine.getDataImpact();
                    if (n != 3 && n != 4) continue block10;
                    throw Error.error(5512);
                }
            }
        }
        orderedHashSet.clear();
    }

    boolean isUnresolvedParam() {
        return false;
    }

    boolean isDynamicParam() {
        return false;
    }

    boolean hasNonDeterministicFunction() {
        OrderedHashSet orderedHashSet = null;
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, functionExpressionSet, emptyExpressionSet)) == null) {
            return false;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Expression expression = (Expression)orderedHashSet.get(i);
            if (!(expression.opType == 27 ? !((FunctionSQLInvoked)expression).isDeterministic() : expression.opType == 28 && !((FunctionSQL)expression).isDeterministic())) continue;
            return true;
        }
        return false;
    }

    void swapLeftAndRightNodes() {
        Expression expression = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = expression;
    }

    void setAttributesAsColumn(ColumnSchema columnSchema, boolean bl) {
        throw Error.runtimeError(201, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n;
        if (orderedIntHashSet2.contains(this.opType)) {
            return orderedHashSet;
        }
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            orderedHashSet = this.nodes[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        n = 0;
        if (orderedIntHashSet.contains(this.opType)) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this);
            n = 1;
        }
        if (n == 0 && this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public OrderedHashSet getSubqueries() {
        return this.collectAllSubqueries(null);
    }

    OrderedHashSet collectAllSubqueries(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectAllSubqueries(orderedHashSet);
        }
        if (this.table != null) {
            OrderedHashSet orderedHashSet2 = null;
            if (this.table.queryExpression != null) {
                orderedHashSet2 = this.table.queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
            }
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this.table);
        }
        return orderedHashSet;
    }

    public boolean isCorrelated() {
        if (this.table == null) {
            return false;
        }
        return this.table.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        OrderedHashSet orderedHashSet = null;
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, subqueryAggregateExpressionSet, emptyExpressionSet)) != null && !orderedHashSet.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    static HsqlList resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, RangeGroup[] rangeGroupArray, HsqlList hsqlList) {
        return Expression.resolveColumnSet(session, rangeVariableArray, rangeVariableArray.length, rangeGroupArray, hsqlList, null);
    }

    static HsqlList resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, HsqlList hsqlList2) {
        if (hsqlList == null) {
            return hsqlList2;
        }
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray);
        for (int i = 0; i < hsqlList.size(); ++i) {
            Expression expression = (Expression)hsqlList.get(i);
            hsqlList2 = expression.resolveColumnReferences(session, rangeGroupSimple, n, rangeGroupArray, hsqlList2, false);
        }
        return hsqlList2;
    }

    boolean isConditionRangeVariable(RangeVariable rangeVariable) {
        return false;
    }

    RangeVariable[] getJoinRangeVariables(RangeVariable[] rangeVariableArray) {
        return RangeVariable.emptyArray;
    }

    double costFactor(Session session, RangeVariable rangeVariable, int n) {
        return 16.0;
    }

    Expression getIndexableExpression(RangeVariable rangeVariable) {
        return null;
    }

    public Expression duplicate() {
        Expression expression = null;
        try {
            expression = (Expression)super.clone();
            expression.nodes = (Expression[])this.nodes.clone();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                expression.nodes[i] = this.nodes[i].duplicate();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
        return expression;
    }

    void replaceNode(Expression expression, Expression expression2) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != expression) continue;
            expression2.alias = this.nodes[i].alias;
            this.nodes[i] = expression2;
            return;
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object updateAggregatingValue(Session session, Object object) {
        throw Error.runtimeError(201, "Expression");
    }

    public Object getAggregatedValue(Session session, Object object) {
        throw Error.runtimeError(201, "Expression");
    }

    public Expression getCondition() {
        return null;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setCondition(Expression expression) {
        throw Error.runtimeError(201, "Expression");
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }

    static {
        aggregateFunctionSet.add(71);
        aggregateFunctionSet.add(72);
        aggregateFunctionSet.add(73);
        aggregateFunctionSet.add(74);
        aggregateFunctionSet.add(75);
        aggregateFunctionSet.add(76);
        aggregateFunctionSet.add(77);
        aggregateFunctionSet.add(78);
        aggregateFunctionSet.add(79);
        aggregateFunctionSet.add(80);
        aggregateFunctionSet.add(81);
        aggregateFunctionSet.add(83);
        aggregateFunctionSet.add(82);
        aggregateFunctionSet.add(85);
        aggregateFunctionSet.add(98);
        columnExpressionSet = new OrderedIntHashSet();
        columnExpressionSet.add(2);
        subqueryExpressionSet = new OrderedIntHashSet();
        subqueryExpressionSet.add(22);
        subqueryExpressionSet.add(23);
        subqueryAggregateExpressionSet = new OrderedIntHashSet();
        subqueryAggregateExpressionSet.add(71);
        subqueryAggregateExpressionSet.add(72);
        subqueryAggregateExpressionSet.add(73);
        subqueryAggregateExpressionSet.add(74);
        subqueryAggregateExpressionSet.add(75);
        subqueryAggregateExpressionSet.add(76);
        subqueryAggregateExpressionSet.add(77);
        subqueryAggregateExpressionSet.add(78);
        subqueryAggregateExpressionSet.add(79);
        subqueryAggregateExpressionSet.add(80);
        subqueryAggregateExpressionSet.add(81);
        subqueryAggregateExpressionSet.add(83);
        subqueryAggregateExpressionSet.add(82);
        subqueryAggregateExpressionSet.add(85);
        subqueryAggregateExpressionSet.add(98);
        subqueryAggregateExpressionSet.add(23);
        subqueryAggregateExpressionSet.add(22);
        functionExpressionSet = new OrderedIntHashSet();
        functionExpressionSet.add(28);
        functionExpressionSet.add(27);
        emptyExpressionSet = new OrderedIntHashSet();
    }
}

