/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BackgroundRepeat;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class BackgroundRepeatReadHandler
implements CSSValueReadHandler {
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        ArrayList<CSSValuePair> arrayList = new ArrayList<CSSValuePair>();
        while (lexicalUnit != null) {
            CSSConstant cSSConstant;
            CSSConstant cSSConstant2;
            if (lexicalUnit.getLexicalUnitType() != 35) {
                return null;
            }
            String string = lexicalUnit.getStringValue();
            if ("repeat-x".equalsIgnoreCase(string)) {
                cSSConstant2 = BackgroundRepeat.REPEAT;
                cSSConstant = BackgroundRepeat.NOREPEAT;
            } else if ("repeat-y".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                cSSConstant2 = BackgroundRepeat.NOREPEAT;
                cSSConstant = BackgroundRepeat.REPEAT;
            } else {
                cSSConstant2 = this.translateRepeat(string);
                if (cSSConstant2 == null) {
                    return null;
                }
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                    cSSConstant = cSSConstant2;
                } else {
                    if (lexicalUnit.getLexicalUnitType() != 35) {
                        return null;
                    }
                    cSSConstant = this.translateRepeat(lexicalUnit.getStringValue());
                    if (cSSConstant == null) {
                        return null;
                    }
                }
            }
            arrayList.add(new CSSValuePair(cSSConstant2, cSSConstant));
            lexicalUnit = CSSValueFactory.parseComma(lexicalUnit);
        }
        return new CSSValueList(arrayList);
    }

    private CSSConstant translateRepeat(String string) {
        if ("repeat".equalsIgnoreCase(string)) {
            return BackgroundRepeat.REPEAT;
        }
        if ("no-repeat".equalsIgnoreCase(string)) {
            return BackgroundRepeat.NOREPEAT;
        }
        if ("space".equalsIgnoreCase(string)) {
            return BackgroundRepeat.SPACE;
        }
        return null;
    }
}

