/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import sun.security.provider.PolicyParser;
import sun.security.util.Debug;

class SubjectCodeSource
extends CodeSource
implements Serializable {
    private static final long serialVersionUID = 6039418085604715275L;
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private Subject subject;
    private LinkedList<PolicyParser.PrincipalEntry> principals;
    private static final Class<?>[] PARAMS = new Class[]{String.class};
    private static final Debug debug = Debug.getInstance("auth", "\t[Auth Access]");
    private ClassLoader sysClassLoader;

    SubjectCodeSource(Subject subject, LinkedList<PolicyParser.PrincipalEntry> linkedList, URL uRL, Certificate[] certificateArray) {
        super(uRL, certificateArray);
        this.subject = subject;
        this.principals = linkedList == null ? new LinkedList() : new LinkedList<PolicyParser.PrincipalEntry>(linkedList);
        this.sysClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    LinkedList<PolicyParser.PrincipalEntry> getPrincipals() {
        return this.principals;
    }

    Subject getSubject() {
        return this.subject;
    }

    @Override
    public boolean implies(CodeSource codeSource) {
        LinkedList<PolicyParser.PrincipalEntry> linkedList = null;
        if (codeSource == null || !(codeSource instanceof SubjectCodeSource) || !super.implies(codeSource)) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 1");
            }
            return false;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        if (this.principals == null) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: PASS 1");
            }
            return true;
        }
        if (subjectCodeSource.getSubject() == null || subjectCodeSource.getSubject().getPrincipals().size() == 0) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 2");
            }
            return false;
        }
        ListIterator<PolicyParser.PrincipalEntry> listIterator = this.principals.listIterator(0);
        while (listIterator.hasNext()) {
            Principal principal;
            Constructor<?> constructor;
            PolicyParser.PrincipalEntry principalEntry = listIterator.next();
            try {
                Class<?> clazz = Class.forName(principalEntry.principalClass, true, this.sysClassLoader);
                if (!Principal.class.isAssignableFrom(clazz)) {
                    throw new ClassCastException(principalEntry.principalClass + " is not a Principal");
                }
                constructor = clazz.getConstructor(PARAMS);
                principal = (Principal)constructor.newInstance(principalEntry.principalName);
                if (!principal.implies(subjectCodeSource.getSubject())) {
                    if (debug != null) {
                        debug.println("\tSubjectCodeSource.implies: FAILURE 3");
                    }
                    return false;
                }
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: PASS 2");
                }
                return true;
            }
            catch (Exception exception) {
                if (linkedList == null) {
                    if (subjectCodeSource.getSubject() == null) {
                        if (debug != null) {
                            debug.println("\tSubjectCodeSource.implies: FAILURE 4");
                        }
                        return false;
                    }
                    constructor = subjectCodeSource.getSubject().getPrincipals().iterator();
                    linkedList = new LinkedList<PolicyParser.PrincipalEntry>();
                    while (constructor.hasNext()) {
                        principal = (Principal)constructor.next();
                        PolicyParser.PrincipalEntry principalEntry2 = new PolicyParser.PrincipalEntry(principal.getClass().getName(), principal.getName());
                        linkedList.add(principalEntry2);
                    }
                }
                if (this.subjectListImpliesPrincipalEntry(linkedList, principalEntry)) continue;
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: FAILURE 5");
                }
                return false;
            }
        }
        if (debug != null) {
            debug.println("\tSubjectCodeSource.implies: PASS 3");
        }
        return true;
    }

    private boolean subjectListImpliesPrincipalEntry(LinkedList<PolicyParser.PrincipalEntry> linkedList, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator<PolicyParser.PrincipalEntry> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = listIterator.next();
            if (!principalEntry.getPrincipalClass().equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.getPrincipalClass().equals(principalEntry2.getPrincipalClass()) || !principalEntry.getPrincipalName().equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.getPrincipalName().equals(principalEntry2.getPrincipalName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SubjectCodeSource)) {
            return false;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)object;
        try {
            if (this.getSubject() != subjectCodeSource.getSubject()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        if (this.principals == null && subjectCodeSource.principals != null || this.principals != null && subjectCodeSource.principals == null) {
            return false;
        }
        return this.principals == null || subjectCodeSource.principals == null || this.principals.containsAll(subjectCodeSource.principals) && subjectCodeSource.principals.containsAll(this.principals);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        Object object;
        String string = super.toString();
        if (this.getSubject() != null) {
            if (debug != null) {
                object = this.getSubject();
                string = string + "\n" + AccessController.doPrivileged(new PrivilegedAction<String>((Subject)object){
                    final /* synthetic */ Subject val$finalSubject;
                    {
                        this.val$finalSubject = subject;
                    }

                    @Override
                    public String run() {
                        return this.val$finalSubject.toString();
                    }
                });
            } else {
                string = string + "\n" + this.getSubject().toString();
            }
        }
        if (this.principals != null) {
            object = this.principals.listIterator();
            while (object.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object.next();
                string = string + rb.getString("NEWLINE") + principalEntry.getPrincipalClass() + " " + principalEntry.getPrincipalName();
            }
        }
        return string;
    }
}

