/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.logging.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.testkit.jarjar.org.gradle.api.logging.LogLevel;
import org.gradle.testkit.jarjar.org.gradle.logging.StyledTextOutput;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.AbstractLineChoppingStyledTextOutput;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.OutputEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.OutputEventListener;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.RenderableOutputEvent;

public class StyledTextOutputBackedRenderer
implements OutputEventListener {
    private final OutputEventTextOutputImpl textOutput;
    private boolean debugOutput;
    private RenderableOutputEvent lastEvent;

    public StyledTextOutputBackedRenderer(StyledTextOutput textOutput) {
        this.textOutput = new OutputEventTextOutputImpl(textOutput);
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof LogLevelChangeEvent) {
            LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
            boolean bl = this.debugOutput = changeEvent.getNewLogLevel() == LogLevel.DEBUG;
        }
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent outputEvent = (RenderableOutputEvent)event;
            this.textOutput.style(outputEvent.getLogLevel() == LogLevel.ERROR ? StyledTextOutput.Style.Error : StyledTextOutput.Style.Normal);
            if (this.debugOutput && (this.textOutput.atEndOfLine || this.lastEvent == null || !this.lastEvent.getCategory().equals(outputEvent.getCategory()))) {
                if (!this.textOutput.atEndOfLine) {
                    this.textOutput.println();
                }
                this.textOutput.text(new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(outputEvent.getTimestamp())));
                this.textOutput.text(" [");
                this.textOutput.text((Object)outputEvent.getLogLevel());
                this.textOutput.text("] [");
                this.textOutput.text(outputEvent.getCategory());
                this.textOutput.text("] ");
            }
            outputEvent.render(this.textOutput);
            this.lastEvent = outputEvent;
            this.textOutput.style(StyledTextOutput.Style.Normal);
        }
    }

    private class OutputEventTextOutputImpl
    extends AbstractLineChoppingStyledTextOutput {
        private final StyledTextOutput textOutput;
        private boolean atEndOfLine = true;

        public OutputEventTextOutputImpl(StyledTextOutput textOutput) {
            this.textOutput = textOutput;
        }

        protected void doStyleChange(StyledTextOutput.Style style) {
            this.textOutput.style(style);
        }

        protected void doLineText(CharSequence text, boolean terminatesLine) {
            this.textOutput.text(text);
            this.atEndOfLine = terminatesLine;
        }
    }
}

