/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.platform.internal;

import org.gradle.api.JavaVersion;
import org.gradle.jvm.platform.JavaPlatform;

public class DefaultJavaPlatform
implements JavaPlatform {
    private final String name;
    private JavaVersion targetCompatibility;

    public DefaultJavaPlatform(JavaVersion javaVersion) {
        this.name = DefaultJavaPlatform.generateName(javaVersion);
        this.targetCompatibility = javaVersion;
    }

    public static JavaPlatform current() {
        return new DefaultJavaPlatform(JavaVersion.current());
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public String getDisplayName() {
        return String.format("Java SE %s", this.targetCompatibility.getMajorVersion());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void setTargetCompatibility(JavaVersion targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    private static String generateName(JavaVersion javaVersion) {
        return "java" + javaVersion.getMajorVersion();
    }
}

