/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrWorkerClient;
import org.gradle.api.plugins.antlr.internal.AntlrWorkerClientProtocol;
import org.gradle.api.plugins.antlr.internal.AntlrWorkerServer;
import org.gradle.internal.Factory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrWorkerManager {
    public AntlrResult runWorker(File workingDir, Factory<WorkerProcessBuilder> workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        WorkerProcess process = this.createWorkerProcess(workingDir, workerFactory, antlrClasspath, spec);
        process.start();
        AntlrWorkerClient clientCallBack = new AntlrWorkerClient();
        process.getConnection().addIncoming(AntlrWorkerClientProtocol.class, (Object)clientCallBack);
        process.getConnection().connect();
        process.waitForStop();
        return clientCallBack.getResult();
    }

    private WorkerProcess createWorkerProcess(File workingDir, Factory<WorkerProcessBuilder> workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        WorkerProcessBuilder builder = (WorkerProcessBuilder)workerFactory.create();
        builder.setBaseName("Gradle ANTLR Worker");
        if (antlrClasspath != null) {
            builder.applicationClasspath((Iterable)antlrClasspath);
        }
        builder.sharedPackages(new String[]{"antlr", "org.antlr"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir((Object)workingDir);
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.systemProperty("ANTLR_DO_NOT_EXIT", (Object)"true");
        javaCommand.redirectErrorStream();
        return builder.worker((Action)new AntlrWorkerServer(spec)).build();
    }
}

