/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeElementComparator;
import org.gradle.api.internal.file.FileTreeElementHasher;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.testing.DefaultJUnitXmlReport;
import org.gradle.api.internal.tasks.testing.DefaultTestTaskReports;
import org.gradle.api.internal.tasks.testing.NoMatchingTestsReporter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestExecuter;
import org.gradle.api.internal.tasks.testing.detection.TestExecuter;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junit.report.DefaultTestReport;
import org.gradle.api.internal.tasks.testing.junit.report.TestReporter;
import org.gradle.api.internal.tasks.testing.junit.result.Binary2JUnitXmlReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.InMemoryTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputAssociation;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestReportDataCollector;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultSerializer;
import org.gradle.api.internal.tasks.testing.logging.DefaultTestLoggingContainer;
import org.gradle.api.internal.tasks.testing.logging.FullExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.ShortExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestCountLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.internal.tasks.testing.results.StateTrackingTestResultProcessor;
import org.gradle.api.internal.tasks.testing.results.TestListenerAdapter;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.logging.ConsoleRenderer;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParallelizableTask
public class Test
extends ConventionTask
implements JavaForkOptions,
PatternFilterable,
VerificationTask,
Reporting<TestTaskReports> {
    private final ListenerBroadcast<TestListener> testListenerBroadcaster;
    private final ListenerBroadcast<TestOutputListener> testOutputListenerBroadcaster;
    private final ListenerBroadcast<TestListenerInternal> testListenerInternalBroadcaster;
    private final TestLoggingContainer testLogging;
    private final DefaultJavaForkOptions forkOptions;
    private final DefaultTestFilter filter;
    private TestExecuter testExecuter;
    private List<File> testSrcDirs = new ArrayList<File>();
    private File testClassesDir;
    private File binResultsDir;
    private PatternFilterable patternSet = (PatternFilterable)this.getFileResolver().getPatternSetFactory().create();
    private boolean ignoreFailures;
    private FileCollection classpath;
    private TestFramework testFramework;
    private boolean scanForTestClasses = true;
    private long forkEvery;
    private int maxParallelForks = 1;
    private TestReporter testReporter;
    @Nested
    private final DefaultTestTaskReports reports;

    public Test() {
        ListenerManager listenerManager = this.getListenerManager();
        this.testListenerInternalBroadcaster = listenerManager.createAnonymousBroadcaster(TestListenerInternal.class);
        this.testListenerBroadcaster = listenerManager.createAnonymousBroadcaster(TestListener.class);
        this.testOutputListenerBroadcaster = listenerManager.createAnonymousBroadcaster(TestOutputListener.class);
        this.forkOptions = new DefaultJavaForkOptions(this.getFileResolver());
        this.forkOptions.setEnableAssertions(true);
        Instantiator instantiator = this.getInstantiator();
        this.testLogging = (TestLoggingContainer)instantiator.newInstance(DefaultTestLoggingContainer.class, new Object[]{instantiator});
        this.reports = (DefaultTestTaskReports)instantiator.newInstance(DefaultTestTaskReports.class, new Object[]{this});
        this.reports.getJunitXml().setEnabled(true);
        this.reports.getHtml().setEnabled(true);
        this.filter = (DefaultTestFilter)instantiator.newInstance(DefaultTestFilter.class, new Object[0]);
        this.addCandidateClassFilesHashProperty();
    }

    @Inject
    protected ProgressLoggerFactory getProgressLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ActorFactory getActorFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ClassLoaderCache getClassLoaderCache() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Factory<WorkerProcessBuilder> getProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    void setTestReporter(TestReporter testReporter) {
        this.testReporter = testReporter;
    }

    void setTestExecuter(TestExecuter testExecuter) {
        this.testExecuter = testExecuter;
    }

    ListenerBroadcast<TestListener> getTestListenerBroadcaster() {
        return this.testListenerBroadcaster;
    }

    ListenerBroadcast<TestListenerInternal> getTestListenerInternalBroadcaster() {
        return this.testListenerInternalBroadcaster;
    }

    ListenerBroadcast<TestOutputListener> getTestOutputListenerBroadcaster() {
        return this.testOutputListenerBroadcaster;
    }

    @Input
    public File getWorkingDir() {
        return this.forkOptions.getWorkingDir();
    }

    public void setWorkingDir(Object dir) {
        this.forkOptions.setWorkingDir(dir);
    }

    public Test workingDir(Object dir) {
        this.forkOptions.workingDir(dir);
        return this;
    }

    @Input
    public String getExecutable() {
        return this.forkOptions.getExecutable();
    }

    public Test executable(Object executable) {
        this.forkOptions.executable(executable);
        return this;
    }

    public void setExecutable(Object executable) {
        this.forkOptions.setExecutable(executable);
    }

    @Input
    public Map<String, Object> getSystemProperties() {
        return this.forkOptions.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.forkOptions.setSystemProperties(properties);
    }

    public Test systemProperties(Map<String, ?> properties) {
        this.forkOptions.systemProperties(properties);
        return this;
    }

    public Test systemProperty(String name, Object value) {
        this.forkOptions.systemProperty(name, value);
        return this;
    }

    @Input
    public FileCollection getBootstrapClasspath() {
        return this.forkOptions.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.forkOptions.setBootstrapClasspath(classpath);
    }

    public Test bootstrapClasspath(Object ... classpath) {
        this.forkOptions.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.forkOptions.getMinHeapSize();
    }

    public String getDefaultCharacterEncoding() {
        return this.forkOptions.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.forkOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public void setMinHeapSize(String heapSize) {
        this.forkOptions.setMinHeapSize(heapSize);
    }

    public String getMaxHeapSize() {
        return this.forkOptions.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.forkOptions.setMaxHeapSize(heapSize);
    }

    @Input
    public List<String> getJvmArgs() {
        return this.forkOptions.getJvmArgs();
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setJvmArgs(arguments);
    }

    public Test jvmArgs(Iterable<?> arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    public Test jvmArgs(Object ... arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    @Input
    public boolean getEnableAssertions() {
        return this.forkOptions.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.forkOptions.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.forkOptions.getDebug();
    }

    @Option(option="debug-jvm", description="Enable debugging for the test process. The process is started suspended and listening on port 5005. [INCUBATING]")
    public void setDebug(boolean enabled) {
        this.forkOptions.setDebug(enabled);
    }

    public List<String> getAllJvmArgs() {
        return this.forkOptions.getAllJvmArgs();
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setAllJvmArgs(arguments);
    }

    public Map<String, Object> getEnvironment() {
        return this.forkOptions.getEnvironment();
    }

    public Test environment(Map<String, ?> environmentVariables) {
        this.forkOptions.environment(environmentVariables);
        return this;
    }

    public Test environment(String name, Object value) {
        this.forkOptions.environment(name, value);
        return this;
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.forkOptions.setEnvironment(environmentVariables);
    }

    public Test copyTo(ProcessForkOptions target) {
        this.forkOptions.copyTo(target);
        return this;
    }

    public Test copyTo(JavaForkOptions target) {
        this.forkOptions.copyTo(target);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void executeTests() {
        InMemoryTestResultsProvider testResultsProvider;
        TestCountLogger testCountLogger;
        block12: {
            LogLevel currentLevel = this.getCurrentLogLevel();
            TestLogging levelLogging = this.testLogging.get(currentLevel);
            TestExceptionFormatter exceptionFormatter = this.getExceptionFormatter(levelLogging);
            TestEventLogger eventLogger = new TestEventLogger(this.getTextOutputFactory(), currentLevel, levelLogging, exceptionFormatter);
            this.addTestListener((TestListener)eventLogger);
            this.addTestOutputListener((TestOutputListener)eventLogger);
            if (this.getFilter().isFailOnNoMatchingTests() && !this.getFilter().getIncludePatterns().isEmpty()) {
                this.addTestListener((TestListener)new NoMatchingTestsReporter("No tests found for given includes: " + this.getFilter().getIncludePatterns()));
            }
            File binaryResultsDir = this.getBinResultsDir();
            this.getProject().delete(new Object[]{binaryResultsDir});
            this.getProject().mkdir((Object)binaryResultsDir);
            HashMap<String, TestClassResult> results = new HashMap<String, TestClassResult>();
            TestOutputStore testOutputStore = new TestOutputStore(binaryResultsDir);
            TestOutputStore.Writer outputWriter = testOutputStore.writer();
            TestReportDataCollector testReportDataCollector = new TestReportDataCollector(results, outputWriter);
            this.addTestListener(testReportDataCollector);
            this.addTestOutputListener(testReportDataCollector);
            testCountLogger = new TestCountLogger(this.getProgressLoggerFactory());
            this.addTestListener((TestListener)testCountLogger);
            this.testListenerInternalBroadcaster.add((Object)new TestListenerAdapter((TestListener)this.testListenerBroadcaster.getSource(), (TestOutputListener)this.testOutputListenerBroadcaster.getSource()));
            StateTrackingTestResultProcessor resultProcessor = new StateTrackingTestResultProcessor((TestListenerInternal)this.testListenerInternalBroadcaster.getSource());
            if (this.testExecuter == null) {
                this.testExecuter = new DefaultTestExecuter(this.getProcessBuilderFactory(), this.getActorFactory());
            }
            try {
                this.testExecuter.execute(this, (TestResultProcessor)resultProcessor);
            }
            finally {
                this.testExecuter = null;
                this.testListenerBroadcaster.removeAll();
                this.testOutputListenerBroadcaster.removeAll();
                this.testListenerInternalBroadcaster.removeAll();
                outputWriter.close();
            }
            new TestResultSerializer(binaryResultsDir).write(results.values());
            testResultsProvider = new InMemoryTestResultsProvider(results.values(), testOutputStore.reader());
            try {
                DirectoryReport html;
                DefaultJUnitXmlReport junitXml;
                if (this.testReporter == null) {
                    this.testReporter = new DefaultTestReport();
                }
                if ((junitXml = this.reports.getJunitXml()).isEnabled()) {
                    TestOutputAssociation outputAssociation = junitXml.isOutputPerTestCase() ? TestOutputAssociation.WITH_TESTCASE : TestOutputAssociation.WITH_SUITE;
                    Binary2JUnitXmlReportGenerator binary2JUnitXmlReportGenerator = new Binary2JUnitXmlReportGenerator(junitXml.getDestination(), testResultsProvider, outputAssociation);
                    binary2JUnitXmlReportGenerator.generate();
                }
                if (!(html = this.reports.getHtml()).isEnabled()) {
                    this.getLogger().info("Test report disabled, omitting generation of the HTML test report.");
                    break block12;
                }
                this.testReporter.generateReport(testResultsProvider, html.getDestination());
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{testResultsProvider}).stop();
                this.testReporter = null;
                this.testFramework = null;
                throw throwable;
            }
        }
        CompositeStoppable.stoppable((Object[])new Object[]{testResultsProvider}).stop();
        this.testReporter = null;
        this.testFramework = null;
        if (testCountLogger.hadFailures()) {
            this.handleTestFailures();
        }
    }

    public void addTestListener(TestListener listener) {
        this.testListenerBroadcaster.add((Object)listener);
    }

    public void addTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerBroadcaster.add((Object)listener);
    }

    public void removeTestListener(TestListener listener) {
        this.testListenerBroadcaster.remove((Object)listener);
    }

    public void removeTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerBroadcaster.remove((Object)listener);
    }

    public void beforeSuite(Closure closure) {
        this.testListenerBroadcaster.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeSuite", closure));
    }

    public void afterSuite(Closure closure) {
        this.testListenerBroadcaster.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterSuite", closure));
    }

    public void beforeTest(Closure closure) {
        this.testListenerBroadcaster.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeTest", closure));
    }

    public void afterTest(Closure closure) {
        this.testListenerBroadcaster.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterTest", closure));
    }

    public void onOutput(Closure closure) {
        this.testOutputListenerBroadcaster.add((Dispatch)new ClosureBackedMethodInvocationDispatch("onOutput", closure));
    }

    public Test include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public Test include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public Test include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public Test include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public Test exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public Test exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public Test exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public Test exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Option(option="tests", description="Sets test class or method name to be included, '*' is supported.")
    @Incubating
    public Test setTestNameIncludePattern(String testNamePattern) {
        this.filter.setIncludePatterns(new String[]{testNamePattern});
        return this;
    }

    public File getTestClassesDir() {
        return this.testClassesDir;
    }

    public void setTestClassesDir(File testClassesDir) {
        this.testClassesDir = testClassesDir;
    }

    @OutputDirectory
    @Incubating
    public File getBinResultsDir() {
        return this.binResultsDir;
    }

    @Incubating
    public void setBinResultsDir(File binResultsDir) {
        this.binResultsDir = binResultsDir;
    }

    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public Test setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public Test setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public TestFramework getTestFramework() {
        return this.testFramework(null);
    }

    public TestFramework testFramework(Closure testFrameworkConfigure) {
        if (this.testFramework == null) {
            this.useJUnit(testFrameworkConfigure);
        }
        return this.testFramework;
    }

    @Nested
    public TestFrameworkOptions getOptions() {
        return this.options(null);
    }

    public TestFrameworkOptions options(Closure testFrameworkConfigure) {
        TestFrameworkOptions options = this.getTestFramework().getOptions();
        ConfigureUtil.configure((Closure)testFrameworkConfigure, (Object)options);
        return options;
    }

    TestFramework useTestFramework(TestFramework testFramework) {
        return this.useTestFramework(testFramework, null);
    }

    private TestFramework useTestFramework(TestFramework testFramework, Closure testFrameworkConfigure) {
        if (testFramework == null) {
            throw new IllegalArgumentException("testFramework is null!");
        }
        this.testFramework = testFramework;
        if (testFrameworkConfigure != null) {
            ConfigureUtil.configure((Closure)testFrameworkConfigure, (Object)this.testFramework.getOptions());
        }
        return this.testFramework;
    }

    public void useJUnit() {
        this.useJUnit(null);
    }

    public void useJUnit(Closure testFrameworkConfigure) {
        this.useTestFramework(new JUnitTestFramework(this, this.filter, this.getClassLoaderCache()), testFrameworkConfigure);
    }

    public void useTestNG() {
        this.useTestNG(null);
    }

    public void useTestNG(Closure testFrameworkConfigure) {
        this.useTestFramework(new TestNGTestFramework(this, this.filter, this.getInstantiator(), this.getClassLoaderCache()), testFrameworkConfigure);
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @InputFiles
    public List<File> getTestSrcDirs() {
        return this.testSrcDirs;
    }

    public void setTestSrcDirs(List<File> testSrcDir) {
        this.testSrcDirs = testSrcDir;
    }

    @Input
    public boolean isScanForTestClasses() {
        return this.scanForTestClasses;
    }

    public void setScanForTestClasses(boolean scanForTestClasses) {
        this.scanForTestClasses = scanForTestClasses;
    }

    public long getForkEvery() {
        return this.forkEvery;
    }

    public void setForkEvery(Long forkEvery) {
        if (forkEvery != null && forkEvery < 0L) {
            throw new IllegalArgumentException("Cannot set forkEvery to a value less than 0.");
        }
        this.forkEvery = forkEvery == null ? 0L : forkEvery;
    }

    public int getMaxParallelForks() {
        return this.getDebug() ? 1 : this.maxParallelForks;
    }

    public void setMaxParallelForks(int maxParallelForks) {
        if (maxParallelForks < 1) {
            throw new IllegalArgumentException("Cannot set maxParallelForks to a value less than 1.");
        }
        this.maxParallelForks = maxParallelForks;
    }

    @InputFiles
    public FileTree getCandidateClassFiles() {
        return this.getProject().fileTree((Object)this.getTestClassesDir()).matching(this.patternSet);
    }

    private void addCandidateClassFilesHashProperty() {
        this.getInputs().property("candidateClassFilesHash", (Object)new Callable<Integer>(){
            Integer candidateClassFilesHash;

            @Override
            public Integer call() throws Exception {
                if (this.candidateClassFilesHash == null) {
                    this.candidateClassFilesHash = Test.this.calculateCandidateClassFilesHash();
                }
                return this.candidateClassFilesHash;
            }
        });
    }

    private Integer calculateCandidateClassFilesHash() {
        final TreeSet sortedFiles = new TreeSet(FileTreeElementComparator.INSTANCE);
        this.getCandidateClassFiles().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                sortedFiles.add(fileDetails);
            }
        });
        return FileTreeElementHasher.calculateHashForFilePaths(sortedFiles);
    }

    public TestLoggingContainer getTestLogging() {
        return this.testLogging;
    }

    public void testLogging(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.testLogging);
    }

    public TestTaskReports getReports() {
        return this.reports;
    }

    public TestTaskReports reports(Closure closure) {
        this.reports.configure(closure);
        return this.reports;
    }

    @Incubating
    @Nested
    public TestFilter getFilter() {
        return this.filter;
    }

    @Incubating
    public void filter(Action<TestFilter> action) {
        action.execute((Object)this.filter);
    }

    private LogLevel getCurrentLogLevel() {
        for (LogLevel level : LogLevel.values()) {
            if (!this.getLogger().isEnabled(level)) continue;
            return level;
        }
        throw new AssertionError((Object)"could not determine current log level");
    }

    private TestExceptionFormatter getExceptionFormatter(TestLogging testLogging) {
        switch (testLogging.getExceptionFormat()) {
            case SHORT: {
                return new ShortExceptionFormatter(testLogging);
            }
            case FULL: {
                return new FullExceptionFormatter(testLogging);
            }
        }
        throw new AssertionError();
    }

    private void handleTestFailures() {
        String message = "There were failing tests";
        DirectoryReport htmlReport = this.reports.getHtml();
        if (htmlReport.isEnabled()) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(htmlReport.getEntryPoint());
            message = message.concat(". See the report at: " + reportUrl);
        } else {
            DefaultJUnitXmlReport junitXmlReport = this.reports.getJunitXml();
            if (junitXmlReport.isEnabled()) {
                String resultsUrl = new ConsoleRenderer().asClickableFileUrl(junitXmlReport.getEntryPoint());
                message = message.concat(". See the results at: " + resultsUrl);
            }
        }
        if (!this.getIgnoreFailures()) {
            throw new GradleException(message);
        }
        this.getLogger().warn(message);
    }
}

