/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BuildInitTestFramework {
    NONE,
    SPOCK,
    TESTNG;


    public static BuildInitTestFramework fromName(String name) {
        if (name == null) {
            return NONE;
        }
        for (BuildInitTestFramework testFramework : BuildInitTestFramework.values()) {
            if (!testFramework.getId().equals(name)) continue;
            return testFramework;
        }
        throw new GradleException("The requested test framework '" + name + "' is not supported.");
    }

    public static List<String> listSupported() {
        ArrayList<String> result = new ArrayList<String>();
        for (BuildInitTestFramework testFramework : BuildInitTestFramework.values()) {
            if (testFramework == NONE) continue;
            result.add(testFramework.getId());
        }
        return result;
    }

    public String getId() {
        return this.name().toLowerCase();
    }
}

