/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputPropertiesTaskStateChanges
extends SimpleTaskStateChanges {
    private final Map<String, Object> properties;
    private final TaskExecution previousExecution;
    private final TaskInternal task;

    public InputPropertiesTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        this.properties = new HashMap<String, Object>(task.getInputs().getProperties());
        currentExecution.setInputProperties(this.properties);
        this.previousExecution = previousExecution;
        this.task = task;
    }

    @Override
    protected void addAllChanges(final List<TaskStateChange> changes) {
        DiffUtil.diff(this.properties, this.previousExecution.getInputProperties(), new ChangeListener<Map.Entry<String, Object>>(){

            @Override
            public void added(Map.Entry<String, Object> element) {
                changes.add(new DescriptiveChange("Input property '%s' has been added for %s", element.getKey(), InputPropertiesTaskStateChanges.this.task));
            }

            @Override
            public void removed(Map.Entry<String, Object> element) {
                changes.add(new DescriptiveChange("Input property '%s' has been removed for %s", element.getKey(), InputPropertiesTaskStateChanges.this.task));
            }

            @Override
            public void changed(Map.Entry<String, Object> element) {
                changes.add(new DescriptiveChange("Value of input property '%s' has changed for %s", element.getKey(), InputPropertiesTaskStateChanges.this.task));
            }
        });
    }
}

