/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.GFileUtils;

public class SyncCopyActionDecorator
implements CopyAction {
    private final File baseDestDir;
    private final CopyAction delegate;

    public SyncCopyActionDecorator(File baseDestDir, CopyAction delegate) {
        this.baseDestDir = baseDestDir;
        this.delegate = delegate;
    }

    public WorkResult execute(final CopyActionProcessingStream stream) {
        final HashSet visited = new HashSet();
        WorkResult didWork = this.delegate.execute(new CopyActionProcessingStream(){

            public void process(final CopyActionProcessingStreamAction action) {
                stream.process(new CopyActionProcessingStreamAction(){

                    public void processFile(FileCopyDetailsInternal details) {
                        visited.add(details.getRelativePath());
                        action.processFile(details);
                    }
                });
            }
        });
        SyncCopyActionDecoratorFileVisitor fileVisitor = new SyncCopyActionDecoratorFileVisitor(visited);
        DirectoryFileTree walker = new DirectoryFileTree(this.baseDestDir).postfix();
        walker.visit(fileVisitor);
        visited.clear();
        return new SimpleWorkResult(didWork.getDidWork() || fileVisitor.didWork);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncCopyActionDecoratorFileVisitor
    implements FileVisitor {
        private final Set<RelativePath> visited;
        private boolean didWork;

        private SyncCopyActionDecoratorFileVisitor(Set<RelativePath> visited) {
            this.visited = visited;
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            this.maybeDelete(dirDetails, true);
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            this.maybeDelete(fileDetails, false);
        }

        private void maybeDelete(FileVisitDetails fileDetails, boolean isDir) {
            RelativePath path = fileDetails.getRelativePath();
            if (!this.visited.contains(path)) {
                if (isDir) {
                    GFileUtils.deleteDirectory(fileDetails.getFile());
                } else {
                    GFileUtils.deleteQuietly(fileDetails.getFile());
                }
                this.didWork = true;
            }
        }
    }
}

