/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.util.SingleMessageLogger;

public class DefaultBuildConfigurer
implements BuildConfigurer {
    private final ProjectConfigurer projectConfigurer;

    public DefaultBuildConfigurer(ProjectConfigurer projectConfigurer) {
        this.projectConfigurer = projectConfigurer;
    }

    public void configure(GradleInternal gradle) {
        this.maybeInformAboutIncubatingMode(gradle.getStartParameter());
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
        }
    }

    private void maybeInformAboutIncubatingMode(StartParameter startParameter) {
        if (startParameter.isParallelProjectExecutionEnabled() && startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed("Parallel execution with configuration on demand");
        } else if (startParameter.isParallelProjectExecutionEnabled()) {
            SingleMessageLogger.incubatingFeatureUsed("Parallel execution");
        } else if (startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed("Configuration on demand");
        }
    }
}

