/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.StartParameter;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private Map<String, String> overrideProperties = new HashMap<String, String>();
    private final StartParameter startParameter;

    public DefaultGradlePropertiesLoader(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public void loadProperties(File settingsDir) {
        this.loadProperties(settingsDir, this.startParameter, this.getAllSystemProperties(), this.getAllEnvProperties());
    }

    void loadProperties(File settingsDir, StartParameter startParameter, Map<String, String> systemProperties, Map<String, String> envProperties) {
        this.defaultProperties.clear();
        this.overrideProperties.clear();
        this.addGradleProperties(this.defaultProperties, new File(settingsDir, "gradle.properties"));
        this.addGradleProperties(this.overrideProperties, new File(startParameter.getGradleUserHomeDir(), "gradle.properties"));
        this.setSystemProperties(startParameter.getSystemPropertiesArgs());
        this.overrideProperties.putAll(this.getEnvProjectProperties(envProperties));
        this.overrideProperties.putAll(this.getSystemProjectProperties(systemProperties));
        this.overrideProperties.putAll(startParameter.getProjectProperties());
    }

    Map getAllSystemProperties() {
        return System.getProperties();
    }

    Map<String, String> getAllEnvProperties() {
        return System.getenv();
    }

    private void addGradleProperties(Map<String, String> target, File ... files) {
        for (File propertyFile : files) {
            if (!propertyFile.isFile()) continue;
            Properties properties = GUtil.loadProperties((File)propertyFile);
            target.putAll(new HashMap<Object, Object>(properties));
        }
    }

    @Override
    public Map<String, String> mergeProperties(Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.defaultProperties);
        result.putAll(properties);
        result.putAll(this.overrideProperties);
        return result;
    }

    private Map<String, String> getSystemProjectProperties(Map<String, String> systemProperties) {
        HashMap<String, String> systemProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            if (!entry.getKey().startsWith("org.gradle.project.") || entry.getKey().length() <= "org.gradle.project.".length()) continue;
            systemProjectProperties.put(entry.getKey().substring("org.gradle.project.".length()), entry.getValue());
        }
        logger.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    private Map<String, String> getEnvProjectProperties(Map<String, String> envProperties) {
        HashMap<String, String> envProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envProperties.entrySet()) {
            if (!entry.getKey().startsWith("ORG_GRADLE_PROJECT_") || entry.getKey().length() <= "ORG_GRADLE_PROJECT_".length()) continue;
            envProjectProperties.put(entry.getKey().substring("ORG_GRADLE_PROJECT_".length()), entry.getValue());
        }
        logger.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    private void setSystemProperties(Map<String, String> properties) {
        this.addSystemPropertiesFromGradleProperties(this.defaultProperties);
        this.addSystemPropertiesFromGradleProperties(this.overrideProperties);
        System.getProperties().putAll(properties);
    }

    private void addSystemPropertiesFromGradleProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (!key.startsWith("systemProp.")) continue;
            System.setProperty(key.substring("systemProp.".length()), properties.get(key));
        }
    }
}

