/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.WatchServiceFileWatcherBacking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk7FileWatcherFactory
implements FileWatcherFactory {
    private final ListeningExecutorService executor;

    public Jdk7FileWatcherFactory(ExecutorService executor) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
    }

    @Override
    public FileWatcher watch(Action<? super Throwable> onError, FileWatcherListener listener) {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            WatchServiceFileWatcherBacking backing = new WatchServiceFileWatcherBacking(onError, listener, watchService);
            return backing.start(this.executor);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

