/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeType;

public class DefaultInclude
implements Include {
    private final String value;
    private final boolean isImport;
    private final IncludeType type;

    public DefaultInclude(String value, boolean isImport, IncludeType type) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.value = value;
        this.isImport = isImport;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public IncludeType getType() {
        return this.type;
    }

    public static Include parse(String value, boolean isImport) {
        if (value.startsWith("<") && value.endsWith(">")) {
            return new DefaultInclude(DefaultInclude.strip(value), isImport, IncludeType.SYSTEM);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return new DefaultInclude(DefaultInclude.strip(value), isImport, IncludeType.QUOTED);
        }
        return new DefaultInclude(value, isImport, IncludeType.MACRO);
    }

    private static String strip(String include) {
        return include.substring(1, include.length() - 1);
    }

    public String toString() {
        return this.value.concat(":").concat(this.type.toString()).concat(":").concat(String.valueOf(this.isImport));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInclude that = (DefaultInclude)o;
        if (this.isImport != that.isImport) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.isImport ? 1 : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

