/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jna;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.os.OperatingSystem;

public class JnaBootPathConfigurer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(File storageDir) {
        String nativePrefix = OperatingSystem.current().getNativePrefix();
        File tmpDir = new File(storageDir, String.format("jna/%s", nativePrefix));
        tmpDir.mkdirs();
        String jnaLibName = OperatingSystem.current().isMacOsX() ? "libjnidispatch.jnilib" : System.mapLibraryName("jnidispatch");
        File libFile = new File(tmpDir, jnaLibName);
        if (!libFile.exists()) {
            String resourceName = "/com/sun/jna/" + nativePrefix + "/" + jnaLibName;
            try {
                InputStream lib = this.getClass().getResourceAsStream(resourceName);
                if (lib == null) {
                    return;
                }
                try {
                    FileOutputStream outputStream = new FileOutputStream(libFile);
                    try {
                        IOUtils.copy((InputStream)lib, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    lib.close();
                }
            }
            catch (IOException e) {
                throw new NativeIntegrationException(String.format("Could not create JNA native library '%s'.", libFile), e);
            }
        }
        System.setProperty("jna.boot.library.path", tmpDir.getAbsolutePath());
    }
}

