/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.filters;

import java.util.ArrayList;
import java.util.List;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.gradleplugin.foundation.filters.ProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.foundation.settings.SettingsSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProjectAndTaskFilter
implements ProjectAndTaskFilter,
SettingsSerializable {
    private static final String BASIC_PROJECT_AND_TASK_FILTER = "basic-project-and-task-filter";
    private static final String FILTERED_OUT_PROJECTS = "filtered-out-projects";
    private static final String FILTERED_OUT_TASKS = "filtered-out-tasks";
    private static final String FILTER_OUT_TASKS_WITH_NO_DESCRIPTION = "filter-out-tasks-with-no-description";
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    private List<String> filteredOutProjectNames = new ArrayList<String>();
    private List<String> filteredOutTaskNames = new ArrayList<String>();
    private boolean filterOutTasksWithNoDescription;

    public BasicProjectAndTaskFilter(List<String> filteredOutProjectNames, List<String> filteredOutTaskNames, boolean filterOutTasksWithNoDescription) {
        this.filterOutTasksWithNoDescription = filterOutTasksWithNoDescription;
        this.filteredOutProjectNames.addAll(filteredOutProjectNames);
        this.filteredOutTaskNames.addAll(filteredOutTaskNames);
    }

    public BasicProjectAndTaskFilter() {
    }

    public List<String> getFilteredOutProjectNames() {
        return this.filteredOutProjectNames;
    }

    void setFilteredOutProjectNames(List<String> filteredOutProjectNames) {
        this.filteredOutProjectNames = filteredOutProjectNames;
    }

    public List<String> getFilteredOutTaskNames() {
        return this.filteredOutTaskNames;
    }

    void setFilteredOutTaskNames(List<String> filteredOutTaskNames) {
        this.filteredOutTaskNames = filteredOutTaskNames;
    }

    public boolean filterOutTasksWithNoDescription() {
        return this.filterOutTasksWithNoDescription;
    }

    void setFilterOutTasksWithNoDescription(boolean filterOutTasksWithNoDescription) {
        this.filterOutTasksWithNoDescription = filterOutTasksWithNoDescription;
    }

    @Override
    public boolean doesAllowProject(ProjectView project) {
        return !this.filteredOutProjectNames.contains(project.getName());
    }

    @Override
    public boolean doesAllowTask(TaskView task) {
        return BasicProjectAndTaskFilter.doesAllowTask(task, this.filteredOutTaskNames, this.filterOutTasksWithNoDescription);
    }

    public static boolean doesAllowTask(TaskView task, List<String> filteredOutTasks, boolean filterOutTasksWithNoDescription) {
        if (filterOutTasksWithNoDescription && !task.hasDescription()) {
            return false;
        }
        return !filteredOutTasks.contains(task.getName());
    }

    @Override
    public void serializeOut(SettingsNode settings) {
        SettingsNode rootNode = settings.addChildIfNotPresent(BASIC_PROJECT_AND_TASK_FILTER);
        rootNode.removeAllChildren();
        rootNode.setValueOfChildAsBoolean(FILTER_OUT_TASKS_WITH_NO_DESCRIPTION, this.filterOutTasksWithNoDescription);
        SettingsNode filteredOutProjectsNode = rootNode.addChild(FILTERED_OUT_PROJECTS);
        this.serializeOutStringList(filteredOutProjectsNode, this.filteredOutProjectNames);
        SettingsNode filteredOutTasksNode = rootNode.addChild(FILTERED_OUT_TASKS);
        this.serializeOutStringList(filteredOutTasksNode, this.filteredOutTaskNames);
    }

    private void serializeOutStringList(SettingsNode parentNode, List<String> strings) {
        for (String item : strings) {
            SettingsNode itemNode = parentNode.addChild(ITEM);
            itemNode.setValue(item);
        }
    }

    @Override
    public void serializeIn(SettingsNode settings) {
        SettingsNode filteredOutTasksNode;
        this.filteredOutProjectNames.clear();
        this.filteredOutTaskNames.clear();
        SettingsNode rootNode = settings.getChildNode(BASIC_PROJECT_AND_TASK_FILTER);
        if (rootNode == null) {
            return;
        }
        this.filterOutTasksWithNoDescription = rootNode.getValueOfChildAsBoolean(FILTER_OUT_TASKS_WITH_NO_DESCRIPTION, this.filterOutTasksWithNoDescription);
        SettingsNode filteredOutProjectsNode = rootNode.getChildNode(FILTERED_OUT_PROJECTS);
        if (filteredOutProjectsNode != null) {
            this.serializeInStringList(filteredOutProjectsNode, this.filteredOutProjectNames);
        }
        if ((filteredOutTasksNode = rootNode.getChildNode(FILTERED_OUT_TASKS)) != null) {
            this.serializeInStringList(filteredOutTasksNode, this.filteredOutTaskNames);
        }
    }

    private void serializeInStringList(SettingsNode parentNode, List<String> strings) {
        for (SettingsNode itemNode : parentNode.getChildNodes(ITEM)) {
            String item = itemNode.getValue();
            if (item == null) continue;
            strings.add(item);
        }
    }
}

