/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import javajs.api.ZInputStream;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptManager;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptQueueThread;
import org.jmol.thread.JmolThread;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class ScriptManager
implements JmolScriptManager {
    private Viewer vwr;
    private ScriptEval eval;
    private JmolScriptEvaluator evalTemp;
    private Thread[] queueThreads = new Thread[2];
    private boolean[] scriptQueueRunning = new boolean[2];
    private JmolThread commandWatcherThread;
    public Lst<Lst<Object>> scriptQueue = new Lst();
    private boolean useCommandWatcherThread = false;
    private int scriptIndex;
    private boolean isScriptQueued = true;
    private static int prevCovalentVersion = 1;

    @Override
    public Lst<Lst<Object>> getScriptQueue() {
        return this.scriptQueue;
    }

    @Override
    public boolean isScriptQueued() {
        return this.isScriptQueued;
    }

    @Override
    public JmolScriptEvaluator setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.eval = this.newScriptEvaluator();
        this.eval.setCompiler();
        return this.eval;
    }

    private ScriptEval newScriptEvaluator() {
        return ((ScriptEval)Interface.getInterface("org.jmol.script.ScriptEval", this.vwr, "setOptions")).setViewer(this.vwr);
    }

    @Override
    public void clear(boolean bl) {
        if (!bl) {
            this.evalTemp = null;
            return;
        }
        this.startCommandWatcher(false);
        this.interruptQueueThreads();
    }

    @Override
    public String addScript(String string, boolean bl) {
        return (String)this.addScr("String", string, "", bl);
    }

    private Object addScr(String string, String string2, String string3, boolean bl) {
        if (!this.vwr.g.useScriptQueue) {
            this.clearQueue();
            this.vwr.haltScriptExecution();
        }
        if (this.commandWatcherThread == null && this.useCommandWatcherThread) {
            this.startCommandWatcher(true);
        }
        if (this.commandWatcherThread != null && string2.indexOf("/*SPLIT*/") >= 0) {
            String[] stringArray = PT.split(string2, "/*SPLIT*/");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addScr(string, stringArray[i], string3, bl);
            }
            return "split into " + stringArray.length + " sections for processing";
        }
        boolean bl2 = this.commandWatcherThread != null && (string2.indexOf("javascript") < 0 || string2.indexOf("#javascript ") >= 0);
        Lst<Object> lst = new Lst<Object>();
        lst.addLast(string2);
        lst.addLast(string3);
        lst.addLast(string);
        lst.addLast(bl ? Boolean.TRUE : Boolean.FALSE);
        lst.addLast(Integer.valueOf(bl2 ? -1 : 1));
        this.scriptQueue.addLast(lst);
        this.startScriptQueue(false);
        return "pending";
    }

    @Override
    public void clearQueue() {
        this.scriptQueue.clear();
    }

    @Override
    public void waitForQueue() {
        if (this.vwr.isSingleThreaded) {
            return;
        }
        int n = 0;
        while (this.isQueueProcessing()) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.debugging) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size() + " thread=" + Thread.currentThread().getName());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isQueueProcessing() {
        return this.queueThreads[0] != null || this.queueThreads[1] != null;
    }

    private synchronized void flushQueue(String string) {
        int n = this.scriptQueue.size();
        while (--n >= 0) {
            String string2 = (String)((Lst)this.scriptQueue.get(n)).get(0);
            if (string2.indexOf(string) != 0) continue;
            this.scriptQueue.remove(n);
            if (!Logger.debugging) continue;
            Logger.debug(this.scriptQueue.size() + " scripts; removed: " + string2);
        }
    }

    private void startScriptQueue(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.scriptQueueRunning[n]) {
            return;
        }
        this.scriptQueueRunning[n] = true;
        this.queueThreads[n] = new ScriptQueueThread(this, this.vwr, bl, n);
        this.queueThreads[n].start();
    }

    @Override
    public Lst<Object> getScriptItem(boolean bl, boolean bl2) {
        if (this.vwr.isSingleThreaded && this.vwr.queueOnHold) {
            return null;
        }
        Lst lst = (Lst)this.scriptQueue.get(0);
        int n = (Integer)lst.get(4);
        boolean bl3 = bl ? n < 0 : (bl2 ? n == 0 : n == 1);
        return bl3 ? lst : null;
    }

    @Override
    public synchronized void startCommandWatcher(boolean bl) {
        this.useCommandWatcherThread = bl;
        if (bl) {
            if (this.commandWatcherThread != null) {
                return;
            }
            this.commandWatcherThread = (JmolThread)Interface.getInterface("org.jmol.script.CommandWatcherThread", this.vwr, "setOptions");
            this.commandWatcherThread.setManager(this, this.vwr, null);
            this.commandWatcherThread.start();
        } else {
            if (this.commandWatcherThread == null) {
                return;
            }
            this.clearCommandWatcherThread();
        }
        if (Logger.debugging) {
            Logger.debug("command watcher " + (bl ? "started" : "stopped") + this.commandWatcherThread);
        }
    }

    void interruptQueueThreads() {
        for (int i = 0; i < this.queueThreads.length; ++i) {
            if (this.queueThreads[i] == null) continue;
            this.queueThreads[i].interrupt();
        }
    }

    public void clearCommandWatcherThread() {
        if (this.commandWatcherThread == null) {
            return;
        }
        this.commandWatcherThread.interrupt();
        this.commandWatcherThread = null;
    }

    @Override
    public void queueThreadFinished(int n) {
        this.queueThreads[n].interrupt();
        this.scriptQueueRunning[n] = false;
        this.queueThreads[n] = null;
        this.vwr.setSyncDriver(4);
        this.vwr.queueOnHold = false;
    }

    public void runScriptNow() {
        Lst<Object> lst;
        if (this.scriptQueue.size() > 0 && (lst = this.getScriptItem(true, true)) != null) {
            lst.set(4, 0);
            this.startScriptQueue(true);
        }
    }

    @Override
    public String evalFile(String string) {
        int n = string.indexOf(" -noqueue");
        if (n >= 0) {
            return (String)this.evalStringWaitStatusQueued("String", "script " + PT.esc(string.substring(0, n)), "", false, false);
        }
        return this.addScript("script " + PT.esc(string), false);
    }

    @Override
    public Object evalStringWaitStatusQueued(String string, String string2, String string3, boolean bl, boolean bl2) {
        boolean bl3;
        if (string2 == null) {
            return null;
        }
        String string4 = this.checkScriptExecution(string2, false);
        if (string4 != null) {
            return string4;
        }
        SB sB = string3 == null || string3.equals("output") ? new SB() : null;
        String string5 = this.vwr.sm.statusList;
        this.vwr.getStatusChanged(string3);
        if (this.vwr.isSyntaxCheck) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl4 = bl3 = string2.indexOf(")") == 0;
        if (bl3) {
            string2 = string2.substring(1);
        }
        bl3 = bl3 || !bl2;
        this.vwr.setErrorMessage(null, null);
        boolean bl5 = this.eval.compileScriptString(string2, bl);
        String string6 = this.eval.getErrorMessage();
        String string7 = this.eval.getErrorMessageUntranslated();
        this.vwr.setErrorMessage(string6, string7);
        this.vwr.refresh(7, "script complete");
        if (bl5) {
            this.isScriptQueued = bl2;
            if (!bl) {
                this.vwr.setScriptStatus(null, string2, -2 - ++this.scriptIndex, null);
            }
            this.eval.evaluateCompiledScript(this.vwr.isSyntaxCheck, this.vwr.isSyntaxAndFileCheck, bl3, this.vwr.listCommands, sB, bl2 || !this.vwr.isSingleThreaded);
        } else {
            this.vwr.scriptStatus(string6);
            this.vwr.setScriptStatus("Jmol script terminated", string6, 1, string7);
            if (this.eval.isStateScript()) {
                ScriptManager.setStateScriptVersion(this.vwr, null);
            }
        }
        if (string6 != null && this.vwr.autoExit) {
            this.vwr.exitJmol();
        }
        if (this.vwr.isSyntaxCheck) {
            if (string6 == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + string7);
            }
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (string.equalsIgnoreCase("String")) {
            return string7;
        }
        if (sB != null) {
            return string7 == null ? sB.toString() : string7;
        }
        Object object = this.vwr.getProperty(string, "jmolStatus", string3);
        this.vwr.getStatusChanged(string5);
        return object;
    }

    private String checkScriptExecution(String string, boolean bl) {
        String string2 = string;
        if (string2.indexOf("\u0001##") >= 0) {
            string2 = string2.substring(0, string2.indexOf("\u0001##"));
        }
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkStepping(string2)) {
            return "script processing stepped";
        }
        if (this.checkHalt(string2, bl)) {
            return "script execution halted";
        }
        return null;
    }

    private boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.vwr.setScriptStatus("", "execution resumed", 0, null);
            this.eval.resumePausedExecution();
            return true;
        }
        return false;
    }

    private boolean checkStepping(String string) {
        if (string.equalsIgnoreCase("step")) {
            this.eval.stepPausedExecution();
            return true;
        }
        if (string.equalsIgnoreCase("?")) {
            this.vwr.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    @Override
    public String evalStringQuietSync(String string, boolean bl, boolean bl2) {
        String string2;
        boolean bl3;
        if (bl2 && this.vwr.sm.syncingScripts && string.indexOf("#NOSYNC;") < 0) {
            this.vwr.syncScript(string + " #NOSYNC;", null, 0);
        }
        if (this.eval.isPaused() && string.charAt(0) != '!') {
            string = '!' + PT.trim(string, "\n\r\t ");
        }
        boolean bl4 = bl3 = string.length() > 0 && string.charAt(0) == '!';
        if (bl3) {
            string = string.substring(1);
        }
        if ((string2 = this.checkScriptExecution(string, bl3)) != null) {
            return string2;
        }
        if (this.vwr.isScriptExecuting() && (bl3 || this.eval.isPaused())) {
            this.vwr.setInsertedCommand(string);
            if (string.indexOf("moveto ") == 0) {
                this.flushQueue("moveto ");
            }
            return "!" + string;
        }
        this.vwr.setInsertedCommand("");
        if (bl) {
            string = string + "\u0001## EDITOR_IGNORE ##";
        }
        return this.addScript(string, bl && !this.vwr.getBoolean(603979880));
    }

    @Override
    public boolean checkHalt(String string, boolean bl) {
        if (string.equalsIgnoreCase("pause")) {
            this.vwr.pauseScriptExecution();
            if (this.vwr.scriptEditorVisible) {
                this.vwr.setScriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        if (string.equalsIgnoreCase("menu")) {
            this.vwr.getProperty("DATA_API", "getPopupMenu", "\u0000");
            return true;
        }
        string = string.toLowerCase();
        boolean bl2 = false;
        String string2 = null;
        if (string.startsWith("exit")) {
            this.vwr.haltScriptExecution();
            this.vwr.clearScriptQueue();
            this.vwr.clearTimeouts();
            string2 = "exit";
            bl2 = string.equals("exit");
        } else if (string.startsWith("quit")) {
            this.vwr.haltScriptExecution();
            string2 = "quit";
            bl2 = string.equals("quit");
        }
        if (string2 == null) {
            return false;
        }
        if (bl) {
            this.vwr.clearThreads();
            this.vwr.queueOnHold = false;
        }
        if (bl || this.vwr.g.waitForMoveTo) {
            this.vwr.tm.stopMotion();
        }
        Logger.info(this.vwr.isSyntaxCheck ? string2 + " -- stops script checking" : (bl ? "!" : "") + string2 + " received");
        this.vwr.isSyntaxCheck = false;
        return bl2;
    }

    @Override
    public BS getAtomBitSetEval(JmolScriptEvaluator jmolScriptEvaluator, Object object) {
        if (jmolScriptEvaluator == null && (jmolScriptEvaluator = this.evalTemp) == null) {
            jmolScriptEvaluator = this.evalTemp = this.newScriptEvaluator();
        }
        return this.vwr.slm.excludeAtoms(jmolScriptEvaluator.getAtomBitSet(object), false);
    }

    @Override
    public Object scriptCheckRet(String string, boolean bl) {
        if (string.indexOf(")") == 0 || string.indexOf("!") == 0) {
            string = string.substring(1);
        }
        ScriptContext scriptContext = this.newScriptEvaluator().checkScriptSilent(string);
        return bl || scriptContext.errorMessage == null ? scriptContext : scriptContext.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFileAsync(String string, int n) {
        block20: {
            String string2;
            boolean bl;
            block18: {
                block19: {
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    block16: {
                        block17: {
                            bl = (n & 2) == 2;
                            bl4 = (n & 4) == 4;
                            bl3 = (n & 1) == 1 && !bl4;
                            string2 = null;
                            if ((string = string.trim()).startsWith("\t")) {
                                bl = true;
                                string = string.substring(1);
                            }
                            string = string.replace('\\', '/');
                            bl2 = string.startsWith("cache://");
                            if (this.vwr.isApplet && string.indexOf("://") < 0) {
                                string = "file://" + (string.startsWith("/") ? "" : "/") + string;
                            }
                            try {
                                if (!string.endsWith(".pse")) break block16;
                                string2 = (bl2 ? "" : "zap;") + "load SYNC " + PT.esc(string) + (this.vwr.isApplet ? "" : " filter 'DORESIZE'");
                                if (string2 == null) break block17;
                                this.vwr.evalString(string2);
                            }
                            catch (Throwable throwable) {
                                if (string2 != null) {
                                    this.vwr.evalString(string2);
                                }
                                throw throwable;
                            }
                        }
                        return;
                    }
                    if (string.endsWith("jvxl")) {
                        string2 = "isosurface ";
                        break block18;
                    }
                    if (string.toLowerCase().endsWith(".spt")) break block18;
                    String string3 = this.getDragDropFileTypeName(string);
                    if (string3 == null) {
                        string3 = FileManager.determineSurfaceTypeIs(this.vwr.getBufferedInputStream(string));
                        if (string3 != null) {
                            string2 = "if (_filetype == 'Pdb') { isosurface sigma 1.0 within 2.0 {*} " + PT.esc(string) + " mesh nofill }; else; { isosurface " + PT.esc(string) + "}";
                        }
                        break block18;
                    }
                    if (string3.equals("Jmol")) {
                        string2 = "script ";
                        break block18;
                    }
                    if (string3.equals("Cube")) {
                        string2 = "isosurface sign red blue ";
                        break block18;
                    }
                    if (string3.equals("spt")) break block18;
                    string2 = this.vwr.g.defaultDropScript;
                    string2 = PT.rep(string2, "%FILE", string);
                    if ((string2 = PT.rep(string2, "%ALLOWCARTOONS", "" + bl3)).toLowerCase().startsWith("zap") && (bl2 || bl4)) {
                        string2 = string2.substring(3);
                    }
                    if (bl4) {
                        string2 = PT.rep(string2, "load SYNC", "load append");
                    }
                    if (string2 == null) break block19;
                    this.vwr.evalString(string2);
                }
                return;
            }
            if (!bl && this.vwr.scriptEditorVisible && string2 == null) {
                this.vwr.showEditor(new String[]{string, this.vwr.getFileAsString3(string, true, null)});
            } else {
                string2 = (string2 == null ? "script " : string2) + PT.esc(string);
            }
            if (string2 == null) break block20;
            this.vwr.evalString(string2);
        }
    }

    private String getDragDropFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        if (string.startsWith("=")) {
            return "pdb";
        }
        Object object = this.vwr.fm.getUnzippedReaderOrStreamFromName(string, null, true, false, true, true, null);
        if (object instanceof BufferedReader) {
            return this.vwr.getModelAdapter().getFileTypeName(object);
        }
        if (object instanceof ZInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            if (string2.indexOf("JmolManifest") >= 0) {
                return "Jmol";
            }
            return this.vwr.getModelAdapter().getFileTypeName(Rdr.getBR(string2));
        }
        if (AU.isAS(object)) {
            return ((String[])object)[0];
        }
        return null;
    }

    private String getZipDirectoryAsString(String string) {
        Object object = this.vwr.fm.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null, false, true);
        return this.vwr.getJzt().getZipDirectoryAsStringAndClose((BufferedInputStream)object);
    }

    public static void setStateScriptVersion(Viewer viewer, String string) {
        if (string != null) {
            prevCovalentVersion = Elements.bondingVersion;
            String[] stringArray = PT.getTokens(string.replace('.', ' ').replace('_', ' '));
            try {
                int n = PT.parseInt(stringArray[0]);
                int n2 = PT.parseInt(stringArray[1]);
                int n3 = PT.parseInt(stringArray[2]);
                if (n3 == Integer.MIN_VALUE) {
                    n3 = 0;
                }
                if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                    viewer.stateScriptVersionInt = n * 10000 + n2 * 100 + n3;
                    int n4 = viewer.stateScriptVersionInt;
                    viewer.setBooleanProperty("legacyautobonding", n4 < 110924);
                    viewer.g.legacyHAddition = n4 < 130117;
                    viewer.setBooleanProperty("legacyjavafloat", n4 < 140206 || n4 >= 140300 && n4 < 140306);
                    viewer.setIntProperty("bondingVersion", n4 < 140111 ? 0 : 1);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        viewer.setIntProperty("bondingVersion", prevCovalentVersion);
        viewer.setBooleanProperty("legacyautobonding", false);
        viewer.g.legacyHAddition = false;
        viewer.stateScriptVersionInt = Integer.MAX_VALUE;
    }

    @Override
    public BS addHydrogensInline(BS bS, Lst<Atom> lst, P3[] p3Array) throws Exception {
        short s = this.vwr.ms.at[bS.nextSetBit((int)0)].mi;
        if (s != this.vwr.ms.mc - 1) {
            return new BS();
        }
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(s);
        this.vwr.g.appendNew = false;
        int n = this.vwr.ms.ac;
        int n2 = this.vwr.ms.getAtomCountInModel(s);
        SB sB = new SB();
        for (int i = 0; i < lst.size(); ++i) {
            Atom atom = (Atom)lst.get(i);
            sB.append(";  connect 0 100 ").append("({" + n++ + "}) ").append("({" + atom.i + "}) group;");
        }
        SB sB2 = new SB();
        sB2.appendI(p3Array.length).append("\n").append("Viewer.AddHydrogens").append("#noautobond").append("\n");
        for (int i = 0; i < p3Array.length; ++i) {
            sB2.append("H ").appendF(p3Array[i].x).append(" ").appendF(p3Array[i].y).append(" ").appendF(p3Array[i].z).append(" - - - - ").appendI(++n2).appendC('\n');
        }
        this.vwr.openStringInlineParamsAppend(sB2.toString(), null, true);
        this.eval.runScriptBuffer(sB.toString(), null, false);
        BS bS3 = this.vwr.getModelUndeletedAtomsBitSet(s);
        bS3.andNot(bS2);
        return bS3;
    }
}

