/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javajs.util.Lst;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.Widgets;

abstract class WebPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    protected String panelName;
    protected String htmlAppletTemplate;
    protected String listLabel;
    protected String appletInfoDivs;
    protected boolean useAppletJS;
    protected JSpinner appletSizeSpinnerW;
    protected JSpinner appletSizeSpinnerH;
    protected JSpinner appletSizeSpinnerP;
    private JScrollPane editorScrollPane;
    private JButton saveButton;
    private JButton viewButton;
    private JButton helpButton;
    private JButton addInstanceButton;
    private JButton deleteInstanceButton;
    private JButton showInstanceButton;
    private JTextField remoteAppletPath;
    private JTextField localAppletPath;
    private JTextField pageAuthorName;
    private JTextField webPageTitle;
    private JFileChooser fc;
    protected JList<JmolInstance> instanceList;
    protected Widgets theWidgets;
    protected int nWidgets;
    private Checkbox[] widgetCheckboxes;
    protected Viewer vwr;
    private int panelIndex;
    private WebPanel[] webPanels;
    private int errCount;
    private String htmlPath;

    abstract String getAppletDefs(int var1, String var2, StringBuilder var3, JmolInstance var4);

    abstract String fixHtml(String var1);

    abstract JPanel appletParamPanel();

    protected WebPanel(Viewer viewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        this.vwr = viewer;
        this.fc = jFileChooser;
        this.webPanels = webPanelArray;
        this.panelIndex = n;
        this.theWidgets = new Widgets();
        this.nWidgets = this.theWidgets.widgetList.length;
        this.widgetCheckboxes = new Checkbox[this.nWidgets];
        this.remoteAppletPath = new JTextField(20);
        this.remoteAppletPath.addActionListener(this);
        this.remoteAppletPath.setText(WebExport.getAppletPath(true));
        this.localAppletPath = new JTextField(20);
        this.localAppletPath.addActionListener(this);
        this.localAppletPath.setText(WebExport.getAppletPath(false));
        this.pageAuthorName = new JTextField(20);
        this.pageAuthorName.addActionListener(this);
        this.pageAuthorName.setText(WebExport.getPageAuthorName());
        this.webPageTitle = new JTextField(20);
        this.webPageTitle.addActionListener(this);
        this.webPageTitle.setText(GT._("A web page containing Jmol applets"));
    }

    JPanel getPanel(int n, int n2) {
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(1);
        this.instanceList.setTransferHandler(new ArrayListTransferHandler(this));
        this.instanceList.setCellRenderer(new InstanceCellRenderer());
        this.instanceList.setDragEnabled(true);
        this.instanceList.setPreferredSize(new Dimension(350, 200));
        this.instanceList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.instanceList);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(this.listLabel), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)new JLabel(GT._("click and drag to reorder")), "South");
        this.addInstanceButton = new JButton(GT._("Add Present Jmol State as Instance..."));
        this.addInstanceButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(350, 50));
        this.deleteInstanceButton = new JButton(GT._("Delete Selected"));
        this.deleteInstanceButton.addActionListener(this);
        jPanel2.add(this.deleteInstanceButton);
        JPanel jPanel3 = this.appletParamPanel();
        jPanel3.setMaximumSize(new Dimension(350, 70));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.addInstanceButton);
        jPanel4.setSize(300, 70);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel2, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setMinimumSize(new Dimension(350, 350));
        jPanel7.setMaximumSize(new Dimension(350, 1000));
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "Center");
        jPanel7.setBorder(BorderFactory.createTitledBorder(GT._("Jmol Instances:")));
        JPanel jPanel8 = new JPanel();
        jPanel8.setMinimumSize(new Dimension(150, 150));
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.setBorder(BorderFactory.createTitledBorder(GT._("Select widgets:")));
        for (int i = 0; i < this.nWidgets; ++i) {
            this.widgetCheckboxes[i] = new Checkbox(this.theWidgets.widgetList[i].name);
            this.widgetCheckboxes[i].addItemListener(this);
            jPanel8.add(this.widgetCheckboxes[i]);
        }
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        JPanel jPanel10 = this.getLeftPanel(n, n2);
        jPanel10.setMaximumSize(new Dimension(350, 1000));
        jPanel9.add((Component)jPanel10, "West");
        jPanel9.add((Component)jPanel7, "Center");
        this.enableButtons(this.instanceList);
        return jPanel9;
    }

    protected JList<JmolInstance> getInstanceList() {
        return this.instanceList;
    }

    private JPanel getLeftPanel(int n, int n2) {
        this.helpButton = new JButton(GT._("Help/Instructions"));
        this.helpButton.addActionListener(this);
        String string = this.panelName + ".png";
        URL uRL = GuiMap.getResource(this, string);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, GT._("Cartoon of Page"));
        } else {
            System.err.println("Error Loading Page Cartoon Image " + string);
        }
        JLabel jLabel = new JLabel(imageIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(GT._("Cartoon of Page") + ":"));
        jPanel.add(jLabel);
        this.saveButton = new JButton(GT._("Save HTML as..."));
        this.saveButton.addActionListener(this);
        this.viewButton = new JButton(GT._("View HTML"));
        this.viewButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.saveButton);
        jPanel2.add(this.viewButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(GT._("Relative server path to jar files:")));
        jPanel3.add((Component)this.remoteAppletPath, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(GT._("Relative local path to jar files:")));
        jPanel4.add((Component)this.localAppletPath, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(GT._("Author (your name):")));
        jPanel5.add((Component)this.pageAuthorName, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(GT._("Browser window title for this web page:")));
        jPanel6.add((Component)this.webPageTitle, "North");
        jPanel6.add((Component)jPanel2, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel4, "South");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        jPanel8.add((Component)jPanel5, "Center");
        jPanel8.add((Component)jPanel6, "South");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.helpButton, "North");
        jPanel9.add((Component)jPanel, "Center");
        jPanel9.add((Component)jPanel8, "South");
        return jPanel9;
    }

    int getInfoWidth() {
        return this.editorScrollPane.getWidth();
    }

    int getInfoHeight() {
        return this.editorScrollPane.getHeight();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        int[] nArray = this.instanceList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[0]);
        Object object = itemEvent.getSource();
        int n = itemEvent.getStateChange();
        for (int i = 0; i < this.nWidgets; ++i) {
            if (object != this.widgetCheckboxes[i]) continue;
            if (n == 1) {
                jmolInstance.addWidget(i);
            }
            if (n != 2) continue;
            jmolInstance.deleteWidget(i);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            HelpDialog helpDialog = new HelpDialog(WebExport.getFrame(), GuiMap.getHtmlResource(this, this.panelName + "_instructions"));
            helpDialog.setVisible(true);
            helpDialog.setDefaultCloseOperation(2);
            return;
        }
        if (actionEvent.getSource() == this.remoteAppletPath) {
            String string = this.remoteAppletPath.getText();
            WebExport.setAppletPath(string, true);
            return;
        }
        if (actionEvent.getSource() == this.localAppletPath) {
            String string = this.localAppletPath.getText();
            WebExport.setAppletPath(string, false);
            return;
        }
        if (actionEvent.getSource() == this.addInstanceButton) {
            JmolInstance jmolInstance;
            String string = this.instanceList.getSelectedIndices().length != 1 ? "" : this.getInstanceName(-1);
            String string2 = JOptionPane.showInputDialog(GT._("Give the occurrence of Jmol a name:"), (Object)string);
            if (string2 == null || string2.length() == 0) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int n = 300;
            int n2 = 300;
            if (this.appletSizeSpinnerH != null) {
                n = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
                n2 = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            }
            if ((jmolInstance = JmolInstance.getInstance(this.vwr, string2, n, n2, this.nWidgets)) == null) {
                LogPanel.log(GT._("Error creating new instance containing script(s) and image."));
                return;
            }
            int n3 = this.instanceList.getModel().getSize();
            while (--n3 >= 0 && !this.getInstanceName(n3).equals(jmolInstance.name)) {
            }
            String string3 = GT._("added Instance {0}");
            if (n3 < 0) {
                n3 = defaultListModel.getSize();
                defaultListModel.addElement(jmolInstance);
                LogPanel.log(GT.o(string3, jmolInstance.name));
            } else {
                defaultListModel.setElementAt(jmolInstance, n3);
                LogPanel.log(GT.o(string3, jmolInstance.name));
            }
            this.instanceList.setSelectedIndex(n3);
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.deleteInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[i]);
                try {
                    jmolInstance.delete();
                    continue;
                }
                catch (IOException iOException) {
                    LogPanel.log(iOException.getMessage());
                }
            }
            defaultListModel.removeRange(nArray[0], nArray[nArray.length - 1]);
            this.syncLists();
            return;
        }
        if (actionEvent.getSource() == this.showInstanceButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
            int[] nArray = this.instanceList.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            JmolInstance jmolInstance = (JmolInstance)defaultListModel.get(nArray[0]);
            this.vwr.evalStringQuiet(")" + jmolInstance.script);
            return;
        }
        if (actionEvent.getSource() == this.viewButton) {
            this.vwr.showUrl(this.htmlPath);
        } else if (actionEvent.getSource() == this.saveButton) {
            this.fc.setDialogTitle(GT._("Select a directory to create or an HTML file to save"));
            int n = this.fc.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = this.fc.getSelectedFile();
            this.htmlPath = "file:///" + file.getAbsolutePath().replace('\\', '/');
            String string = null;
            this.errCount = 0;
            try {
                String string4 = this.remoteAppletPath.getText();
                WebExport.setAppletPath(string4, true);
                string4 = this.localAppletPath.getText();
                WebExport.setAppletPath(string4, false);
                String string5 = this.pageAuthorName.getText();
                WebExport.setWebPageAuthor(string5);
                string = this.fileWriter(file, this.instanceList);
                this.viewButton.setEnabled(true);
            }
            catch (IOException iOException) {
                LogPanel.log(iOException.getMessage());
                ++this.errCount;
            }
            if (string != null) {
                LogPanel.log(GT.o(GT._("file {0} created"), string));
            } else {
                LogPanel.log(GT._("Call to FileWriter unsuccessful."));
                ++this.errCount;
            }
            if (this.errCount > 0) {
                LogPanel.log(GT._("Errors occurred during web page creation.  See Log Tab!"));
            }
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.isSelectionEmpty()) {
            return;
        }
        if (jList.getMinSelectionIndex() != jList.getMaxSelectionIndex()) {
            return;
        }
        int n = jList.getSelectedIndex();
        JmolInstance jmolInstance = (JmolInstance)jList.getModel().getElementAt(n);
        int n2 = jmolInstance.width;
        int n3 = jmolInstance.height;
        if (this.appletSizeSpinnerW != null) {
            this.appletSizeSpinnerW.getModel().setValue(n2);
        }
        if (this.appletSizeSpinnerH != null) {
            this.appletSizeSpinnerH.getModel().setValue(n3);
        }
        this.vwr.evalStringQuiet(")" + jmolInstance.script);
        for (int i = 0; i < this.nWidgets; ++i) {
            this.widgetCheckboxes[i].setState(jmolInstance.whichWidgets.get(i));
        }
    }

    String getInstanceName(int n) {
        JmolInstance jmolInstance;
        if (n < 0) {
            n = this.instanceList.getSelectedIndex();
        }
        return (jmolInstance = this.instanceList.getModel().getElementAt(n)) == null ? "" : jmolInstance.name;
    }

    String fileWriter(File file, JList<JmolInstance> jList) throws IOException {
        String string;
        Object object;
        String string2;
        this.useAppletJS = WebPanel.checkOption(this.vwr.getP("webMakerCreateJS"));
        String string3 = file.getPath().replace('\\', '/');
        String string4 = file.getName();
        if (string4.indexOf(".htm") < 0) {
            File file2 = new File(string3 + ".html");
            if (file2.exists()) {
                string4 = string4 + ".html";
                file = file2;
            } else {
                file2 = new File(string3 + ".htm");
                if (file2.exists()) {
                    string4 = string4 + ".htm";
                    file = file2;
                }
            }
        }
        if (string4.indexOf(".htm") > 0) {
            string2 = string4;
            string3 = file.getParent();
            file = new File(string3);
            string4 = file.getName();
        } else {
            string2 = string4 + ".html";
        }
        string3 = string3.replace('\\', '/');
        string2 = string3 + "/" + string2;
        boolean bl = file.exists() && file.isDirectory() || file.mkdir();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        LogPanel.log("");
        if (bl) {
            Object object2;
            int n;
            Object object3;
            Object object4;
            Object object5;
            LogPanel.log(GT.o(GT._("Using directory {0}"), string3));
            LogPanel.log("  " + GT.o(GT._("adding {0}"), "JmolPopIn.js"));
            this.vwr.writeTextFile(string3 + "/JmolPopIn.js", GuiMap.getResourceString(this, "JmolPopIn.js"));
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                Object object6;
                object5 = (JmolInstance)defaultListModel.getElementAt(i);
                object4 = ((JmolInstance)object5).javaname;
                String string5 = ((JmolInstance)object5).script;
                LogPanel.log("  ...jmolApplet" + i);
                LogPanel.log("      ..." + GT.o(GT._("adding {0}"), (String)object4 + ".png"));
                ((JmolInstance)object5).movepict(string3);
                object3 = new Lst();
                object = this.localAppletPath.getText();
                if (((String)object).equals(".") || this.remoteAppletPath.getText().equals(".")) {
                    try {
                        object6 = this.jmolJarPath().substring(0, this.jmolJarPath().lastIndexOf("/"));
                        ((Lst)object3).addLast((String)object6 + "/jsmol.zip");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        LogPanel.log(GT._("There was an error in the text encoding so the path to jsmol.zip is unknown."));
                    }
                }
                FileManager.getFileReferences(string5, (Lst<String>)object3);
                object6 = new ArrayList();
                n = ((ArrayList)object3).size();
                for (int j = 0; j < n; ++j) {
                    object2 = this.copyBinaryFile((String)((ArrayList)object3).get(j), string3);
                    ((ArrayList)object6).add(((String)object2).substring(((String)object2).lastIndexOf(47) + 1));
                }
                string5 = WebPanel.replaceQuotedStrings(string5, (ArrayList<String>)object3, (ArrayList<String>)object6);
                LogPanel.log("      ..." + GT.o(GT._("adding {0}"), (String)object4 + ".spt"));
                this.vwr.writeTextFile(string3 + "/" + (String)object4 + ".spt", string5);
            }
            string = GuiMap.getResourceString(this, this.panelName + "_template");
            string = this.fixHtml(string);
            object5 = "";
            object4 = this.allSelectedWidgets();
            for (int i = 0; i < this.nWidgets; ++i) {
                int n2;
                if (!((BS)object4).get(i)) continue;
                object3 = this.theWidgets.widgetList[i].getJavaScriptFileName();
                if (!((String)object3).equalsIgnoreCase("none")) {
                    object5 = (String)object5 + "\n<script src=\"" + (String)object3 + "\" type=\"text/javascript\"></script>";
                    LogPanel.log("  " + GT.o(GT._("adding {0}"), object3));
                    this.vwr.writeTextFile(string3 + "/" + (String)object3 + "", GuiMap.getResourceString(this, (String)object3));
                }
                if ((n2 = ((String[])(object = this.theWidgets.widgetList[i].getSupportFileNames())).length) == 0) continue;
                for (n = 0; n < n2; ++n) {
                    URL uRL;
                    Object object7;
                    object2 = object7 = object[n];
                    if (((String)object7).lastIndexOf("/") != -1) {
                        object2 = ((String)object7).substring(((String)object7).lastIndexOf("/") + 1);
                    }
                    if ((uRL = GuiMap.getResource(this, (String)object7)) == null) {
                        LogPanel.log("    " + GT.o(GT._("Unable to load resource {0}"), object7));
                        ++this.errCount;
                        continue;
                    }
                    InputStream inputStream = uRL.openConnection().getInputStream();
                    FileOutputStream fileOutputStream = new FileOutputStream(string3 + "/" + (String)object2);
                    int n3 = inputStream.read();
                    while (n3 != -1) {
                        fileOutputStream.write(n3);
                        n3 = inputStream.read();
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    LogPanel.log("  " + GT.o(GT._("adding {0}"), object2));
                }
            }
            string = PT.rep(string, "@WIDGETJSFILES@", (String)object5);
            this.appletInfoDivs = "";
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.useAppletJS) {
                this.htmlAppletTemplate = GuiMap.getResourceString(this, this.panelName + "_template2");
            }
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                string = this.getAppletDefs(i, string, stringBuilder, (JmolInstance)defaultListModel.getElementAt(i));
            }
            string = PT.rep(string, "@AUTHOR@", GT.escapeHTML(this.pageAuthorName.getText()));
            string = PT.rep(string, "@TITLE@", GT.escapeHTML(this.webPageTitle.getText()));
            string = PT.rep(string, "@REMOTEAPPLETPATH@", this.remoteAppletPath.getText());
            String string6 = this.localAppletPath.getText();
            if (string6.contentEquals(".")) {
                string6 = "jsmol";
            }
            string = PT.rep(string, "@LOCALAPPLETPATH@", string6);
            string = PT.rep(string, "@DATADIRNAME@", string4);
            if (this.appletInfoDivs.length() > 0) {
                this.appletInfoDivs = "\n<div style='display:none'>\n" + this.appletInfoDivs + "\n</div>\n";
            }
            object = stringBuilder.toString();
            if (this.useAppletJS) {
                object = "<script type='text/javascript'>\n" + (String)object + "\n</script>";
            }
        } else {
            IOException iOException = new IOException(GT._("Error creating directory: ") + string3);
            throw iOException;
        }
        string = PT.rep(string, "@APPLETINFO@", this.appletInfoDivs);
        string = PT.rep(string, "@APPLETDEFS@", (String)object);
        string = PT.rep(string, "@CREATIONDATA@", GT.escapeHTML(WebExport.TimeStamp_WebLink()));
        string = PT.rep(string, "@AUTHORDATA@", GT.escapeHTML(GT._("Based on template by A. Herr&#x00E1;ez as modified by J. Gutow")));
        string = PT.rep(string, "@LOGDATA@", "<pre>\n" + LogPanel.getText() + "\n</pre>\n");
        LogPanel.log("      ..." + GT.o(GT._("creating {0}"), string2));
        this.vwr.writeTextFile(string2, string);
        return string2;
    }

    public static String replaceQuotedStrings(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = arrayList.get(i);
            String string3 = arrayList2.get(i);
            if (string3.equals(string2)) continue;
            string = PT.rep(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
        }
        return string;
    }

    public BS allSelectedWidgets() {
        BS bS = BS.newN(this.nWidgets);
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            JmolInstance jmolInstance = (JmolInstance)defaultListModel.getElementAt(i);
            bS.or(jmolInstance.whichWidgets);
        }
        return bS;
    }

    private String copyBinaryFile(String string, String string2) {
        String string3 = string.substring(string.lastIndexOf(47) + 1).replace('|', '_');
        if (string3.contentEquals("jsmol.zip")) {
            LogPanel.log(GT.o(GT._("copying and unzipping jsmol.zip directory into {0}"), string2));
            String string4 = this.copyandUnzip(string, string2, string3);
            return string4;
        }
        string3 = string2 + "/" + string3;
        String string5 = string3 + ".gz";
        File file = new File(string3);
        File file2 = new File(string5);
        if (file.exists()) {
            return string3;
        }
        if (file2.exists()) {
            return string5;
        }
        try {
            Object object = this.vwr.fm.getFileAsBytes(string, null);
            if (object instanceof String) {
                LogPanel.log(GT.o(GT._("Could not find or open:\n{0}\nPlease check that you are using a Jmol.jar that is part of a full Jmol distribution."), string));
                ++this.errCount;
            } else {
                LogPanel.log("      ..." + GT.o(GT._("copying\n{0}\n         to"), string));
                byte[] byArray = (byte[])object;
                String[] stringArray = new String[]{string3};
                int n = string3.indexOf(".js") >= 0 ? Integer.MAX_VALUE : 100000;
                String string6 = WebPanel.writeFileZipped(stringArray, byArray, n);
                if (!stringArray[0].equals(string3)) {
                    string3 = stringArray[0];
                    LogPanel.log("      ..." + GT._("compressing large data file to") + "\n" + string3);
                }
                LogPanel.log(string3);
                if (string6 != null) {
                    LogPanel.log(string6);
                    ++this.errCount;
                }
            }
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
            ++this.errCount;
        }
        return string3;
    }

    private static String writeFileZipped(String[] stringArray, byte[] byArray, int n) {
        String string = null;
        try {
            boolean bl = false;
            if (byArray.length > n) {
                bl = true;
                for (int i = 0; i < 10; ++i) {
                    if (byArray[i] >= 10) continue;
                    bl = false;
                }
            }
            if (bl) {
                stringArray[0] = stringArray[0] + ".gz";
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(stringArray[0]));
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.flush();
                gZIPOutputStream.close();
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        return string;
    }

    private String copyandUnzip(String string, String string2, String string3) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            File file = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray = new byte[1024];
            while (enumeration.hasMoreElements()) {
                block12: {
                    try {
                        fileOutputStream = null;
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.getName().endsWith(".htm") || zipEntry.getName().contains("data" + File.separator) || zipEntry.getName().contains(".html")) break block12;
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        file = new File(string2 + File.separator + zipEntry.getName());
                        if (zipEntry.isDirectory()) {
                            Logger.info("creating directory " + file);
                            file.mkdirs();
                        } else {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                            fileOutputStream = new FileOutputStream(file);
                            int n = 0;
                            while ((n = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Logger.error(iOException.getMessage());
                        break;
                    }
                }
                if (fileOutputStream == null) continue;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            LogPanel.log(GT._("Error encountered while openning zip file. You may not have\na complete copy of the Jmol distribution.  Check for the file jsmol.zip.\n" + iOException.getMessage()));
            ++this.errCount;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    private URL jmolJarURL() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    private String jmolJarPath() throws UnsupportedEncodingException {
        String string = null;
        URL uRL = this.jmolJarURL();
        string = URLDecoder.decode(uRL.toString(), System.getProperty("file.encoding"));
        string = string.substring(string.indexOf(":") + 1, string.length());
        return string;
    }

    void syncLists() {
        DefaultListModel defaultListModel = (DefaultListModel)this.instanceList.getModel();
        for (int i = 0; i < this.webPanels.length; ++i) {
            if (i == this.panelIndex) continue;
            JList<JmolInstance> jList = this.webPanels[i].instanceList;
            DefaultListModel defaultListModel2 = (DefaultListModel)jList.getModel();
            defaultListModel2.clear();
            int n = defaultListModel.getSize();
            for (int j = 0; j < n; ++j) {
                defaultListModel2.addElement(defaultListModel.get(j));
            }
            jList.setSelectedIndices(new int[0]);
            this.webPanels[i].enableButtons(jList);
        }
        this.enableButtons(this.instanceList);
    }

    void enableButtons(JList<?> jList) {
        int n = jList.getSelectedIndices().length;
        int n2 = jList.getModel().getSize();
        this.saveButton.setEnabled(n2 > 0);
        this.viewButton.setEnabled(false);
        this.deleteInstanceButton.setEnabled(n > 0);
    }

    public static boolean checkOption(Object object) {
        return object instanceof Boolean && (Boolean)object != false || object instanceof Integer && (Integer)object != 0;
    }

    class InstanceCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        InstanceCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(" " + ((JmolInstance)object).name);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            WebPanel.this.enableButtons(jList);
            return this;
        }
    }
}

