/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.zip.DeflaterInputStream;
import org.sejda.io.SeekableSource;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.PdfStreamSource;
import org.sejda.model.input.PdfURLSource;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;

public class ReadOnlyFilteredCOSStream
extends COSStream {
    private InputStream stream;
    private long length;
    private COSDictionary wrapped;

    ReadOnlyFilteredCOSStream(COSDictionary existingDictionary, InputStream stream, long length) {
        super(Optional.ofNullable(existingDictionary).orElseThrow(() -> new IllegalArgumentException("wrapped dictionary cannot be null")));
        RequireUtils.requireNotNullArg(stream, "input stream cannot be null");
        this.stream = stream;
        this.length = length;
        this.wrapped = existingDictionary;
    }

    @Override
    protected InputStream doGetFilteredStream() {
        return this.stream;
    }

    @Override
    public long getFilteredLength() throws IOException {
        RequireUtils.requireIOCondition(this.length >= 0L, "Filtered length cannot be requested");
        return this.length;
    }

    @Override
    public long getUnfilteredLength() throws IOException {
        throw new IOException("Unfiltered length cannot be requested");
    }

    @Override
    public InputStream getUnfilteredStream() throws IOException {
        throw new IOException("getUnfilteredStream  cannot be requested");
    }

    @Override
    public SeekableSource getUnfilteredSource() throws IOException {
        throw new IOException("getUnfilteredSource  cannot be requested");
    }

    @Override
    public OutputStream createFilteredStream() {
        throw new SejdaRuntimeException("createFilteredStream cannot be called on this stream");
    }

    @Override
    public OutputStream createFilteredStream(COSBase filters) {
        throw new SejdaRuntimeException("createFilteredStream cannot be called on this stream");
    }

    @Override
    public void setFilters(COSBase filters) {
        throw new SejdaRuntimeException("setFilters cannot be called on this stream");
    }

    @Override
    public void addCompression() {
    }

    @Override
    public boolean encryptable() {
        return true;
    }

    @Override
    public void encryptable(boolean encryptable) {
    }

    @Override
    public OutputStream createUnfilteredStream() {
        throw new SejdaRuntimeException("createUnfilteredStream cannot be called on this stream");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean indirectLength() {
        return true;
    }

    @Override
    public void indirectLength(boolean indirectLength) {
    }

    @Override
    public IndirectCOSObjectIdentifier id() {
        return this.wrapped.id();
    }

    @Override
    public void idIfAbsent(IndirectCOSObjectIdentifier id) {
        this.wrapped.idIfAbsent(id);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.stream);
    }

    public static ReadOnlyFilteredCOSStream readOnly(COSStream existing) throws IOException {
        RequireUtils.requireNotNullArg(existing, "input stream cannot be null");
        existing.setEncryptor(null);
        return new ReadOnlyFilteredCOSStream(existing, existing.getFilteredStream(), existing.getFilteredLength());
    }

    public static ReadOnlyFilteredCOSStream readOnlyJpegImage(File imageFile, int width, int height, int bitsPerComponent, PDColorSpace colorSpace) throws FileNotFoundException {
        RequireUtils.requireNotNullArg(imageFile, "input file cannot be null");
        RequireUtils.requireNotNullArg(colorSpace, "color space cannot be null");
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        dictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dictionary.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dictionary.setInt(COSName.BITS_PER_COMPONENT, bitsPerComponent);
        dictionary.setInt(COSName.HEIGHT, height);
        dictionary.setInt(COSName.WIDTH, width);
        Optional.of(colorSpace).map(PDColorSpace::getCOSObject).ifPresent(cs -> dictionary.setItem(COSName.COLORSPACE, (COSBase)cs));
        return new ReadOnlyFilteredCOSStream(dictionary, new FileInputStream(imageFile), imageFile.length());
    }

    public static final ReadOnlyFilteredCOSStream readOnlyEmbeddedFile(PdfSource<?> source) throws TaskIOException {
        final COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.FILTER, (COSBase)COSName.FLATE_DECODE);
        return source.open(new PdfSourceOpener<ReadOnlyFilteredCOSStream>(){

            @Override
            public ReadOnlyFilteredCOSStream open(PdfURLSource source) throws TaskIOException {
                try {
                    return new ReadOnlyFilteredCOSStream(dictionary, new DeflaterInputStream(source.getSource().openStream()), -1L);
                }
                catch (IOException e) {
                    throw new TaskIOException(e);
                }
            }

            @Override
            public ReadOnlyFilteredCOSStream open(PdfFileSource source) throws TaskIOException {
                try {
                    ReadOnlyFilteredCOSStream retVal = new ReadOnlyFilteredCOSStream(dictionary, new DeflaterInputStream(new FileInputStream(source.getSource())), -1L);
                    retVal.setEmbeddedInt(COSName.PARAMS.getName(), COSName.SIZE, source.getSource().length());
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTimeInMillis(source.getSource().lastModified());
                    retVal.setEmbeddedDate(COSName.PARAMS.getName(), COSName.MOD_DATE, (Calendar)calendar);
                    return retVal;
                }
                catch (FileNotFoundException e) {
                    throw new TaskIOException(e);
                }
            }

            @Override
            public ReadOnlyFilteredCOSStream open(PdfStreamSource source) {
                return new ReadOnlyFilteredCOSStream(dictionary, new DeflaterInputStream(source.getSource()), -1L);
            }
        });
    }
}

