/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;

public class StateInvariant
implements LifelineOccurrence {
    private static final double ROUND_PART_WIDTH = 20.0;
    private static final double ROUND_PART_TEXT_PERCENTAGE = 0.3;
    private static final double VERTICAL_BORDER_PADDING = 5.0;
    private static final double CURLY_BRACKETS_Y_PADDING = 2.0;
    private static final double MIN_WIDTH = 50.0;
    private final String[] lines;
    private final StateInvariantStyle style;

    public StateInvariant(String text, StateInvariantStyle style) {
        this.style = style;
        this.lines = style == StateInvariantStyle.CURLY_BRACKETS ? ("{" + text + "}").split("\n") : text.split("\n");
    }

    @Override
    public Line1D draw(DrawHandler drawHandler, PointDouble topLeft, PointDouble size) {
        double height = this.getHeight(drawHandler, size.x);
        double topY = topLeft.y + (size.y - height) / 2.0;
        Line1D interruptedLifeline = new Line1D(topY, topY + height);
        if (this.style == StateInvariantStyle.STATE) {
            drawHandler.drawArc(topLeft.x, topY, 40.0, height, 90.0, 180.0, true);
            drawHandler.drawArc(topLeft.x + size.x - 40.0, topY, 40.0, height, 270.0, 180.0, true);
            drawHandler.drawLine(topLeft.x + 20.0, topY, topLeft.x + size.x - 20.0, topY);
            drawHandler.drawLine(topLeft.x + 20.0, topY + height, topLeft.x + size.x - 20.0, topY + height);
            TextSplitter.drawText(drawHandler, this.lines, topLeft.x + 14.0, topY, size.x - 28.0, height, AlignHorizontal.CENTER, AlignVertical.CENTER);
        } else if (this.style == StateInvariantStyle.CURLY_BRACKETS) {
            TextSplitter.drawText(drawHandler, this.lines, topLeft.x, topY, size.x, height, AlignHorizontal.CENTER, AlignVertical.CENTER);
        }
        return interruptedLifeline;
    }

    @Override
    public double getMinWidth(DrawHandler drawHandler) {
        double minWidth = Math.max(50.0, TextSplitter.getTextMinWidth(this.lines, drawHandler));
        if (this.style == StateInvariantStyle.CURLY_BRACKETS) {
            return minWidth;
        }
        return minWidth + 28.0;
    }

    @Override
    public double getAdditionalYHeight(DrawHandler drawHandler, PointDouble size) {
        return this.getHeight(drawHandler, size.x) - size.y;
    }

    private double getHeight(DrawHandler drawHandler, double totalWidth) {
        if (this.style == StateInvariantStyle.STATE) {
            totalWidth -= 28.0;
        }
        if (this.style == StateInvariantStyle.CURLY_BRACKETS) {
            return TextSplitter.getSplitStringHeight(this.lines, totalWidth, drawHandler) + 4.0;
        }
        return TextSplitter.getSplitStringHeight(this.lines, totalWidth, drawHandler) + 10.0;
    }

    public static enum StateInvariantStyle {
        STATE,
        CURLY_BRACKETS;

    }
}

