/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.Sanitizable;
import com.ubnt.data.TestPattern;
import com.ubnt.data.X;
import com.ubnt.service.B.N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Device
extends X
implements Sanitizable {
    private static final Logger o\u00d20000;
    public static TestPattern \u00d2\u00d20000;
    public static String[] O\u00d20000;
    public static String[] innerClasses;
    public static final String[] interfacesuper;

    public static String name() {
        return "device";
    }

    public static int mask() {
        return \u00d5O0000 | supersuper;
    }

    @Override
    public void sanitize(X x) {
        \u00d2\u00d20000.matchPattern(x);
    }

    public static String getStateName(int n) {
        return interfacesuper[n];
    }

    public void setState(int n) {
        this.put("state", (Object)n);
        if (n == 2) {
            this.put("adopt_status", (Object)0);
        }
    }

    public int getState() {
        return this.getInt("state", 0);
    }

    public static boolean consideredConnected(int n) {
        return n == 1 || n == 5;
    }

    public boolean consideredConnected() {
        return Device.consideredConnected(this.getState());
    }

    public boolean isBusy() {
        int n = this.getState();
        return n == 7 || n == 5 || n == 4 || n == 8;
    }

    public static String getDeviceType(String string) {
        Device device = new Device();
        device.put("model", (Object)string);
        return device.getType();
    }

    public String getType() {
        if (this.isAtherosAP() || this.isBroadcomAP()) {
            return "uap";
        }
        if (this.isBroadcomSwitch() || this.isAtherosSwitch()) {
            return "usw";
        }
        if (this.isCaviumRouter()) {
            return "ugw";
        }
        if (this.isVoipPhone()) {
            return "uph";
        }
        return "unknown";
    }

    public String getMgmtDev() {
        if (this.isAtherosAP() || this.isBroadcomAP()) {
            return "br0";
        }
        if (this.isCaviumRouter()) {
            return this.getInterfaceName("wan");
        }
        return "eth0";
    }

    public int getFwupdateTimeRequired() {
        return this.getFwupdateTimeRequired(true);
    }

    public int getFwupdateTimeRequired(boolean bl) {
        if (this.isBroadcomAP()) {
            return 120;
        }
        if (this.isBroadcomSwitch()) {
            return 300;
        }
        if (this.isCaviumRouter()) {
            return 600;
        }
        if (this.isVoipPhone()) {
            return bl ? 900 : 120;
        }
        return 120;
    }

    public boolean isSafeForAutoUpgrade() {
        if (this.getType().equals("uph")) {
            return true;
        }
        if (!this.getType().equals("uap")) {
            return false;
        }
        return !this.supportVwire() || !StringUtils.isNotEmpty((String)this.getString("uplink_ap_mac")) && this.getVwireCount("ng") + this.getVwireCount("na") <= 0;
    }

    public boolean isAtherosAP() {
        String string = this.getString("model", "UNKNOWN");
        return "BZ2".equals(string) || "BZ2LR".equals(string) || "U2M".equals(string) || "U2S48".equals(string) || "U2L48".equals(string) || "U2O".equals(string) || "U5O".equals(string) || "U2HSR".equals(string) || "p2N".equals(string) || "U7P".equals(string) || "U2Sv2".equals(string) || "U2Lv2".equals(string) || "U2IW".equals(string) || "U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string);
    }

    public boolean isAtherosSwitch() {
        String string = this.getString("model", "UNKNOWN");
        return "SW24P".equals(string);
    }

    public boolean isBroadcomSwitch() {
        String string = this.getString("model", "UNKNOWN");
        return "US24".equals(string) || "US24P250".equals(string) || "US24P500".equals(string) || "US48".equals(string) || "US48P500".equals(string) || "US48P750".equals(string) || "US8P150".equals(string);
    }

    public boolean isCaviumRouter() {
        String string = this.getString("model", "UNKNOWN");
        return "UGW3".equals(string) || "UGW4".equals(string) || "UGW8".equals(string);
    }

    public boolean hasEightPorts() {
        String string = this.getString("model", "UNKNOWN");
        return "UGW8".equals(string);
    }

    public boolean isVoipPhone() {
        String string = this.getString("model", "UNKNOWN");
        return "UP4".equals(string) || "UP5".equals(string) || "UP5t".equals(string) || "UP7".equals(string) || "UP5c".equals(string) || "UP5tc".equals(string) || "UP7c".equals(string);
    }

    public boolean supportIPSecVti() {
        boolean bl = false;
        if (this.isCaviumRouter()) {
            String[] stringArray = this.getString("version", "0.0.0").split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            if (n == 4 && n2 >= 3 || n >= 5) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean supportCustomisedRadiusPort() {
        boolean bl = false;
        if (this.isCaviumRouter()) {
            String[] stringArray = this.getString("version", "0.0.0").split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[3]);
            if (n == 4 && n2 >= 3 && n3 >= 4740876 || n >= 5) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean supportDNSMasqExceptInterface() {
        boolean bl = false;
        if (this.isCaviumRouter()) {
            int n;
            String[] stringArray = this.getString("version", "0.0.0").split("\\.");
            int n2 = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 0;
            int n3 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
            int n4 = n = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 0;
            if (n2 == 4 && n3 >= 2 && n >= 4787553 || n2 == 4 && n3 >= 3 || n2 >= 5) {
                bl = true;
            }
        }
        return bl;
    }

    public List<X> seedPortTable() {
        String string = this.getString("model", "UNKNOWN");
        ArrayList<X> arrayList = new ArrayList<X>();
        if ("UGW3".equals(string)) {
            arrayList.add(new X("name", "wan", "ifname", "eth0"));
            arrayList.add(new X("name", "lan", "ifname", "eth1"));
            arrayList.add(new X("name", "voip", "ifname", "eth2"));
        } else if ("UGW4".equals(string)) {
            arrayList.add(new X("name", "lan", "ifname", "eth0"));
            arrayList.add(new X("name", "voip", "ifname", "eth1"));
            arrayList.add(new X("name", "wan", "ifname", "eth2"));
            arrayList.add(new X("name", "wan2", "ifname", "eth3"));
        } else if ("UGW8".equals(string)) {
            arrayList.add(new X("name", "lan", "ifname", "eth0"));
            arrayList.add(new X("name", "lan2", "ifname", "eth1"));
            arrayList.add(new X("name", "lan3", "ifname", "eth2"));
            arrayList.add(new X("name", "lan4", "ifname", "eth3"));
            arrayList.add(new X("name", "lan5", "ifname", "eth4"));
            arrayList.add(new X("name", "voip", "ifname", "eth5"));
            arrayList.add(new X("name", "wan", "ifname", "eth6"));
            arrayList.add(new X("name", "wan2", "ifname", "eth7"));
        } else if (this.isBroadcomSwitch() || this.isAtherosSwitch()) {
            for (int i = 1; i <= this.getPortNum(); ++i) {
                arrayList.add(new X("port_idx", i));
            }
        }
        return arrayList;
    }

    public boolean isBroadcomAP() {
        String string = this.getString("model", "UNKNOWN");
        return "U7E".equals(string) || "U7O".equals(string) || "U7Ev2".equals(string);
    }

    public boolean isMediumTxPowerDesired() {
        return this.isBroadcomAP();
    }

    public boolean hasStationStat() {
        return this.getType() == "ugw" || this.getType() == "uap";
    }

    public int getPortNum() {
        String string = this.getString("model", "UNKNOWN");
        if ("U7P".equals(string) || this.isBroadcomAP() || this.hasEth1()) {
            return 2;
        }
        if ("US24".equals(string) || "US24P250".equals(string) || "US24P500".equals(string)) {
            return 26;
        }
        if ("US48".equals(string) || "US48P500".equals(string) || "US48P750".equals(string)) {
            return 52;
        }
        if ("US8P150".equals(string)) {
            return 10;
        }
        if ("UGW3".equals(string)) {
            return 3;
        }
        if ("UGW4".equals(string)) {
            return 4;
        }
        if ("UGW8".equals(string)) {
            return 8;
        }
        return 1;
    }

    public int getMaxMirrorSession() {
        if (this.isBroadcomSwitch()) {
            return 1;
        }
        return 0;
    }

    public int getMaxAggregation() {
        if (this.isBroadcomSwitch()) {
            return 6;
        }
        return 0;
    }

    public boolean hasRadio(String string) {
        if ("ng".equals(string)) {
            return this.hasRadioNG();
        }
        if ("na".equals(string)) {
            return this.hasRadioNA();
        }
        return false;
    }

    public boolean hasRadioNA() {
        String string = this.getString("model", "UNKNOWN");
        if (!"uap".equals(this.getType())) {
            return false;
        }
        if ("U5O".equals(string) || "U7P".equals(string)) {
            return true;
        }
        if ("U7E".equals(string) || "U7O".equals(string) || "U7Ev2".equals(string)) {
            return true;
        }
        return "U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string);
    }

    public boolean hasRadioNG() {
        String string = this.getString("model", "UNKNOWN");
        if (!"uap".equals(this.getType())) {
            return false;
        }
        return !"U5O".equals(string);
    }

    public int getRadioNum() {
        return (this.hasRadioNA() ? 1 : 0) + (this.hasRadioNG() ? 1 : 0);
    }

    public int getWlanNum() {
        return this.getRadioNum() * 4;
    }

    public boolean supportVwire() {
        return this.isAtherosAP();
    }

    public boolean supportSpectrumScan() {
        String string = this.getString("model", "UNKNOWN");
        return "U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string);
    }

    public boolean supportZeroHandoff() {
        String string = this.getString("model", "UNKNOWN");
        if ("U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string)) {
            return false;
        }
        return this.isAtherosAP();
    }

    public boolean supportATFConfig() {
        String string = this.getString("model", "UNKNOWN");
        if ("U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string)) {
            return false;
        }
        return false;
    }

    public boolean supportBandsteering() {
        String string = this.getString("model", "UNKNOWN");
        if ("U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string)) {
            return true;
        }
        if ("U7O".equals(string) || "U7E".equals(string) || "U7Ev2".equals(string)) {
            return false;
        }
        return "U7P".equals(string);
    }

    public boolean supportVapBasedBandsteering() {
        String string = this.getString("model", "UNKNOWN");
        if ("U7O".equals(string) || "U7E".equals(string) || "U7Ev2".equals(string)) {
            return false;
        }
        return "U7P".equals(string);
    }

    public boolean isConfigCloneableFrom(Device device) {
        if (this.isBroadcomSwitch() && device.isBroadcomSwitch()) {
            if (X.equals((X)this, (X)device, "model")) {
                return true;
            }
            if (this.getPortNum() == device.getPortNum()) {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSshUpgrade() {
        return !"uph".equals(this.getType());
    }

    public boolean supportsUpgradeExternal() {
        return !"uph".equals(this.getType());
    }

    public static int getMediaMaxSpeed(String string) {
        if ("FE".equals(string)) {
            return 100;
        }
        if ("GE".equals(string)) {
            return 1000;
        }
        if ("SFP".equals(string)) {
            return 1000;
        }
        if ("SFP+".equals(string)) {
            return 10000;
        }
        return 1000;
    }

    public String getDefaultPortName(int n) {
        String string = this.getString("model", "UNKNOWN");
        if ("US48".equals(string) || "US48P500".equals(string) || "US48P750".equals(string)) {
            if (n > 50) {
                return "SFP " + (n - 50);
            }
            if (n > 48) {
                return "SFP+ " + (n - 48);
            }
        } else if ("US24".equals(string) || "US24P250".equals(string) || "US24P500".equals(string)) {
            if (n > 24) {
                return "SFP " + (n - 24);
            }
        } else if ("US8P150".equals(string) && n > 8) {
            return "SFP " + (n - 8);
        }
        return "Port " + n;
    }

    public int ethMaxSpeed() {
        String string = this.getString("model", "UNKNOWN");
        if (this.isBroadcomAP()) {
            return 1000;
        }
        if (this.isAtherosAP()) {
            if ("U7P".equals(string)) {
                return 1000;
            }
            if ("U7PG2".equals(string) || "U7EDU".equals(string) || "U7LR".equals(string) || "U7LT".equals(string)) {
                return 1000;
            }
        }
        if ("uap".equals(this.getType())) {
            return 100;
        }
        return 1000;
    }

    public int wifiMaxSpeed(String string) {
        String string2 = this.getString("model", "UNKNOWN");
        if (this.isBroadcomAP()) {
            return "na".equals(string) ? 1300 : 450;
        }
        if (this.isAtherosAP()) {
            if ("U7P".equals(string2)) {
                return "na".equals(string) ? 300 : 450;
            }
            if ("p2N".equals(string2) || "U2M".equals(string2) || "U2IW".equals(string2)) {
                return 150;
            }
            if ("U7PG2".equals(string2) || "U7EDU".equals(string2)) {
                return "na".equals(string) ? 1300 : 450;
            }
            if ("U7LR".equals(string2)) {
                return "na".equals(string) ? 867 : 450;
            }
            if ("U7LT".equals(string2)) {
                return "na".equals(string) ? 867 : 300;
            }
            return 300;
        }
        return 0;
    }

    public boolean hasEth1() {
        String string = this.getString("model", "UNKNOWN");
        return this.isAtherosAP() && ("U2O".equals(string) || "U5O".equals(string) || "U2HSR".equals(string));
    }

    public int getAdoptState() {
        return this.getInt("adopt_state", 0);
    }

    public int getAdoptTries() {
        return this.getInt("adopt_tries", 0);
    }

    public String getPortIpAddr(String string) {
        List<X> list = this.getList("port_table", this.seedPortTable());
        X x = X.findOne(list, "name", string);
        return x != null ? x.getString("ip") : null;
    }

    public String getInterfaceName(String string) {
        List<X> list = this.getList("port_table", this.seedPortTable());
        X x = X.findOne(list, "name", string);
        return x != null ? x.getString("ifname") : null;
    }

    public String getWanInterfaceName(String string) {
        String string2 = this.getInterfaceName(string);
        X x = null;
        String string3 = null;
        String string4 = null;
        if (string == null || string2 == null) {
            return null;
        }
        if (string.equals("wan")) {
            x = this.getX("config_network_wan", null);
            string3 = "pppoe0";
            string4 = "pppoe2";
        } else if (string.equals("wan2")) {
            x = this.getX("config_network_wan2", null);
            string3 = "pppoe1";
            string4 = "pppoe3";
        }
        if (x != null) {
            String string5 = x.getString("type", "dhcp");
            if ("disabled".equals(string5)) {
                return null;
            }
            if (x.is("vlan_enabled", false)) {
                if ("pppoe".equals(string5)) {
                    return string4;
                }
                return String.format("%s.%d", string2, x.getInt("vlan", 1));
            }
            if ("pppoe".equals(string5)) {
                return string3;
            }
            return string2;
        }
        return null;
    }

    public List<String> getWanInterfaceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(this.getWanInterfaceName("wan"), this.getWanInterfaceName("wan2")));
        for (String string : arrayList2) {
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public X getDefaultNetworkConfig() {
        return X.newInstanceWithoutNullValue("type", "dhcp", "ip", this.getString("ip", null));
    }

    public boolean exceedAdoptTries() {
        int n = this.getAdoptTries();
        int n2 = this.getAdoptState();
        return n >= 3 && n2 == 2 | n2 == 3;
    }

    public void incAdoptTries() {
        this.put("adopt_tries", (Object)(this.getAdoptTries() + 1));
    }

    public void resetAdoptState() {
        this.setAdoptState(0);
    }

    public void setAdoptState(int n) {
        this.put("adopt_state", (Object)n);
        if (n == 0) {
            this.put("adopt_tries", (Object)0);
        }
    }

    public X getRadioNG() {
        return X.findOne(this.getList("radio_table", X.\u00d2O0000), "radio", "ng");
    }

    public X getRadioNA() {
        return X.findOne(this.getList("radio_table", X.\u00d2O0000), "radio", "na");
    }

    public X getRadio(String string) {
        return X.findOne(this.getList("radio_table", X.\u00d2O0000), "radio", string);
    }

    public boolean hasVwireTo(String string) {
        if (!this.containsField("vwire_table")) {
            return false;
        }
        return X.findOne(this.getList("vwire_table", X.\u00d2O0000), "ap_mac", string) != null;
    }

    public int getVwireCount(String string) {
        return X.find(this.getList("vwire_table", X.\u00d2O0000), "radio", string).size();
    }

    public boolean isMaxVwireConfigured(String string) {
        if (!this.supportVwire()) {
            return true;
        }
        return this.getVwireCount(string) == 4;
    }

    public boolean isWiredUplink() {
        X x = this.getX("uplink", X.\u00f400000);
        return "wire".equals(x.getString("type", "wireless"));
    }

    public boolean isWirelessUplink() {
        X x = this.getX("uplink", X.\u00f400000);
        return "wireless".equals(x.getString("type", "wire"));
    }

    public String getWirelessUplinkApMac() {
        X x = this.getX("uplink", X.\u00f400000);
        return x.getString("ap_mac", "none");
    }

    static {
        int n;
        o\u00d20000 = N.\u00d4o0000;
        \u00d2\u00d20000 = TestPattern.getPattern(Device.class.getSimpleName());
        O\u00d20000 = new String[]{"mac", "name", "x_fingerprint", "x_authkey", "x_vwirekey", "map_id", "x", "y", "locked", "model", "type", "version", "ip", "serial", "first_seen", "inform_url", "inform_ip", "atf_enabled", "bandsteering_mode", "dpi_enabled", "mgmt_network_id", "jumboframe_enabled", "flowctrl_enabled"};
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < 4; ++n) {
            hashSet.add("radio_table." + n);
        }
        for (n = 0; n < 52; ++n) {
            hashSet.add("port_table." + n);
        }
        for (n = 0; n < 52; ++n) {
            hashSet.add("port_overrides." + n);
        }
        for (n = 0; n < 16; ++n) {
            hashSet.add("vwire_table." + n);
        }
        for (n = 0; n < 16; ++n) {
            hashSet.add("wlan_overrides." + n);
        }
        for (n = 0; n < 8; ++n) {
            hashSet.add("ethernet_table." + n);
        }
        hashSet.add("config_network");
        hashSet.add("config_network_wan");
        hashSet.add("config_network_wan2");
        hashSet.add("uplink");
        for (n = 0; n < 16; ++n) {
            hashSet.add("downlink_table." + n);
        }
        innerClasses = hashSet.toArray(new String[0]);
        interfacesuper = new String[]{"UNKNOWN", "CONNECTED", "PENDING", "FIRMWARE_MISMATCH", "UPGRADING", "PROVISIONING", "HEARTBEAT_MISSED", "ADOPTING", "DELETING", "INFORM_ERROR", "ADOPT_FAILED", "ISOLATED"};
    }
}

