#ifndef _EFL_GFX_BASE_EO_LEGACY_H_
#define _EFL_GFX_BASE_EO_LEGACY_H_

#ifndef _EFL_GFX_BASE_EO_CLASS_TYPE
#define _EFL_GFX_BASE_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Base;

#endif

#ifndef _EFL_GFX_BASE_EO_TYPES
#define _EFL_GFX_BASE_EO_TYPES

typedef enum
{
  EFL_GFX_COLORSPACE_ARGB8888 = 0, /** ARGB 32 bits per pixel, high-byte is
                                    * Alpha, accessed one 32-bit word at a time
                                    */
  EFL_GFX_COLORSPACE_GRY8 = 4 /* 0 */ /** 8-bit gray image, or alpha only */
} Efl_Gfx_Colorspace;

typedef enum
{
  EFL_GFX_RENDER_OP_BLEND = 0, /** Alpha blending onto destination (default); d
                                * = d*(1-sa) + s */
  EFL_GFX_RENDER_OP_COPY = 1 /* 0 */, /** Copy source to destination; d = s */
  EFL_GFX_RENDER_OP_LAST
} Efl_Gfx_Render_Op;

typedef enum
{
  EFL_GFX_COLOR_TYPE_BITS8 = 0, /** Color is encoded in the top 8 bits of the
                                 * unsigned short as a unsigned char. */
  EFL_GFX_COLOR_TYPE_BITS16, /** Color is encoded in the 16 bits as an unsigned
                              * char. */
  EFL_GFX_COLOR_TYPE_LAST
} Efl_Gfx_Color_Type;

/** Define an RGBA color.
 *
 * @ingroup Efl_Gfx
 */
typedef struct _Efl_Gfx_Color
{
  unsigned short r; /** The red component. */
  unsigned short g; /** The green component. */
  unsigned short b; /** The blue component. */
  unsigned short a; /** The alpha component. */
  Efl_Gfx_Color_Type type;
} Efl_Gfx_Color;


#endif

#endif
