/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;

final class BlockCipherParamsCore {
    private int block_size = 0;
    private byte[] iv = null;

    BlockCipherParamsCore(int blksize) {
        this.block_size = blksize;
    }

    void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] tmpIv = ((IvParameterSpec)paramSpec).getIV();
        if (tmpIv.length != this.block_size) {
            throw new InvalidParameterSpecException("IV not " + this.block_size + " bytes long");
        }
        this.iv = (byte[])tmpIv.clone();
    }

    void init(byte[] encoded) throws IOException {
        DerInputStream der = new DerInputStream(encoded);
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (tmpIv.length != this.block_size) {
            throw new IOException("IV not " + this.block_size + " bytes long");
        }
        this.iv = tmpIv;
    }

    void init(byte[] encoded, String decodingMethod) throws IOException {
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.init(encoded);
    }

    AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (IvParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    byte[] getEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        return out.toByteArray();
    }

    byte[] getEncoded(String encodingMethod) throws IOException {
        return this.getEncoded();
    }

    public String toString() {
        String LINE_SEP = System.getProperty("line.separator");
        String ivString = LINE_SEP + "    iv:" + LINE_SEP + "[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]" + LINE_SEP;
        return ivString;
    }
}

