/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NameClassPairEnumeration
implements NamingEnumeration {
    private final String[] names;
    private int nextName;

    NameClassPairEnumeration(String[] names) {
        this.names = names;
        this.nextName = 0;
    }

    @Override
    public boolean hasMore() {
        return this.nextName < this.names.length;
    }

    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String name = this.names[this.nextName++];
        Name cname = new CompositeName().add(name);
        NameClassPair ncp = new NameClassPair(cname.toString(), "java.lang.Object");
        ncp.setNameInNamespace(name);
        return ncp;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException("javax.naming.NamingException was thrown");
        }
    }

    @Override
    public void close() {
        this.nextName = this.names.length;
    }
}

