/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import sun.reflect.BootstrapConstructorAccessorImpl;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ConstructorAccessorImpl;
import sun.reflect.DelegatingConstructorAccessorImpl;
import sun.reflect.DelegatingMethodAccessorImpl;
import sun.reflect.FieldAccessor;
import sun.reflect.InstantiationExceptionConstructorAccessorImpl;
import sun.reflect.LangReflectAccess;
import sun.reflect.MethodAccessor;
import sun.reflect.MethodAccessorGenerator;
import sun.reflect.NativeConstructorAccessorImpl;
import sun.reflect.NativeMethodAccessorImpl;
import sun.reflect.Reflection;
import sun.reflect.SerializationConstructorAccessorImpl;
import sun.reflect.UnsafeFieldAccessorFactory;

public class ReflectionFactory {
    private static boolean initted = false;
    private static final Permission reflectionFactoryAccessPerm = new RuntimePermission("reflectionFactoryAccess");
    private static final ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile LangReflectAccess langReflectAccess;
    private static boolean noInflation;
    private static int inflationThreshold;

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(reflectionFactoryAccessPerm);
        }
        return soleInstance;
    }

    public void setLangReflectAccess(LangReflectAccess access) {
        langReflectAccess = access;
    }

    public FieldAccessor newFieldAccessor(Field field, boolean override) {
        ReflectionFactory.checkInitted();
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, override);
    }

    public MethodAccessor newMethodAccessor(Method method) {
        ReflectionFactory.checkInitted();
        if (noInflation) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl acc = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl res = new DelegatingMethodAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor c) {
        ReflectionFactory.checkInitted();
        Class declaringClass = c.getDeclaringClass();
        if (Modifier.isAbstract(declaringClass.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (declaringClass == Class.class) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        if (Reflection.isSubclassOf(declaringClass, ConstructorAccessorImpl.class)) {
            return new BootstrapConstructorAccessorImpl(c);
        }
        if (noInflation) {
            return new MethodAccessorGenerator().generateConstructor(c.getDeclaringClass(), c.getParameterTypes(), c.getExceptionTypes(), c.getModifiers());
        }
        NativeConstructorAccessorImpl acc = new NativeConstructorAccessorImpl(c);
        DelegatingConstructorAccessorImpl res = new DelegatingConstructorAccessorImpl(acc);
        acc.setParent(res);
        return res;
    }

    public Field newField(Class<?> declaringClass, String name, Class<?> type, int modifiers, int slot, String signature, byte[] annotations) {
        return ReflectionFactory.langReflectAccess().newField(declaringClass, name, type, modifiers, slot, signature, annotations);
    }

    public Method newMethod(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault) {
        return ReflectionFactory.langReflectAccess().newMethod(declaringClass, name, parameterTypes, returnType, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations, annotationDefault);
    }

    public Constructor newConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations) {
        return ReflectionFactory.langReflectAccess().newConstructor(declaringClass, parameterTypes, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations);
    }

    public MethodAccessor getMethodAccessor(Method m) {
        return ReflectionFactory.langReflectAccess().getMethodAccessor(m);
    }

    public void setMethodAccessor(Method m, MethodAccessor accessor) {
        ReflectionFactory.langReflectAccess().setMethodAccessor(m, accessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor c) {
        return ReflectionFactory.langReflectAccess().getConstructorAccessor(c);
    }

    public void setConstructorAccessor(Constructor c, ConstructorAccessor accessor) {
        ReflectionFactory.langReflectAccess().setConstructorAccessor(c, accessor);
    }

    public Method copyMethod(Method arg) {
        return ReflectionFactory.langReflectAccess().copyMethod(arg);
    }

    public Field copyField(Field arg) {
        return ReflectionFactory.langReflectAccess().copyField(arg);
    }

    public <T> Constructor<T> copyConstructor(Constructor<T> arg) {
        return ReflectionFactory.langReflectAccess().copyConstructor(arg);
    }

    public Constructor newConstructorForSerialization(Class<?> classToInstantiate, Constructor constructorToCall) {
        if (constructorToCall.getDeclaringClass() == classToInstantiate) {
            return constructorToCall;
        }
        SerializationConstructorAccessorImpl acc = new MethodAccessorGenerator().generateSerializationConstructor(classToInstantiate, constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), constructorToCall.getDeclaringClass());
        Constructor c = this.newConstructor(constructorToCall.getDeclaringClass(), constructorToCall.getParameterTypes(), constructorToCall.getExceptionTypes(), constructorToCall.getModifiers(), ReflectionFactory.langReflectAccess().getConstructorSlot(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorSignature(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorAnnotations(constructorToCall), ReflectionFactory.langReflectAccess().getConstructorParameterAnnotations(constructorToCall));
        this.setConstructorAccessor(c, acc);
        return c;
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String val = System.getProperty("sun.reflect.noInflation");
                if (val != null && val.equals("true")) {
                    noInflation = true;
                }
                if ((val = System.getProperty("sun.reflect.inflationThreshold")) != null) {
                    try {
                        inflationThreshold = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        throw (RuntimeException)new RuntimeException("Unable to parse property sun.reflect.inflationThreshold").initCause(e);
                    }
                }
                initted = true;
                return null;
            }
        });
    }

    private static LangReflectAccess langReflectAccess() {
        if (langReflectAccess == null) {
            Modifier.isPublic(1);
        }
        return langReflectAccess;
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction<ReflectionFactory> {
        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

