/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    private final List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    private final Map<String, ImageryInfo> layerIds = new HashMap<String, ImageryInfo>();
    private static final List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    private static final Map<String, ImageryInfo> defaultLayerIds = new HashMap<String, ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Main.getJOSMWebsite() + "/maps"};

    public static Collection<String> getImageryLayersSites() {
        return Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES));
    }

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void clear() {
        this.layers.clear();
        this.layerIds.clear();
    }

    public void load(boolean bl) {
        this.clear();
        List<ImageryInfo.ImageryPreferenceEntry> list = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (list != null) {
            for (ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry : list) {
                try {
                    ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    this.add(imageryInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn("Unable to load imagery preference entry:" + illegalArgumentException);
                }
            }
            Collections.sort(this.layers);
        }
        this.loadDefaults(false, true, bl);
    }

    public void loadDefaults(boolean bl, boolean bl2, boolean bl3) {
        DefaultEntryLoader defaultEntryLoader = new DefaultEntryLoader(bl, bl3);
        if (bl2) {
            defaultEntryLoader.realRun();
            defaultEntryLoader.finish();
        } else {
            Main.worker.execute(new DefaultEntryLoader(bl, bl3));
        }
    }

    private static void buildIdMap(List<ImageryInfo> list, Map<String, ImageryInfo> map) {
        map.clear();
        HashSet<String> hashSet = new HashSet<String>();
        for (ImageryInfo object : list) {
            if (object.getId() == null) continue;
            if (map.containsKey(object.getId())) {
                hashSet.add(object.getId());
                Main.error("Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", object.getId(), object.getName(), map.get(object.getId()).getName());
                continue;
            }
            map.put(object.getId(), object);
        }
        for (String string : hashSet) {
            map.remove(string);
        }
    }

    public void updateEntriesFromDefaults() {
        boolean bl = false;
        Collection<String> collection = Main.pref.getCollection("imagery.layers.default");
        TreeSet<String> treeSet = new TreeSet<String>(collection);
        for (ImageryInfo object22 : defaultLayers) {
            if (!object22.isDefaultEntry()) continue;
            boolean bl2 = false;
            for (String string : collection) {
                if (!ImageryLayerInfo.isSimilar(string, object22.getUrl())) continue;
                bl2 = true;
                break;
            }
            boolean bl3 = false;
            if (!bl2) {
                treeSet.add(object22.getUrl());
                for (ImageryInfo imageryInfo : this.layers) {
                    if (!this.isSimilar(object22, imageryInfo)) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl2 || bl3) continue;
            this.add(new ImageryInfo(object22));
            bl = true;
        }
        Main.pref.putCollection("imagery.layers.default", treeSet);
        Collection<String> collection2 = Main.pref.getCollection("imagery.layers.addedIds");
        TreeSet<String> treeSet2 = new TreeSet<String>(collection2);
        for (ImageryInfo imageryInfo3 : this.layers) {
            for (ImageryInfo imageryInfo : defaultLayers) {
                if (!this.isSimilar(imageryInfo, imageryInfo3) || imageryInfo.getId() == null || collection2.contains(imageryInfo.getId()) || !defaultLayerIds.containsKey(imageryInfo.getId())) continue;
                treeSet2.add(imageryInfo.getId());
                if (imageryInfo3.getId() != null) continue;
                imageryInfo3.setId(imageryInfo.getId());
                bl = true;
            }
        }
        Main.pref.putCollection("imagery.layers.addedIds", treeSet2);
        for (int i = 0; i < this.layers.size(); ++i) {
            ImageryInfo imageryInfo;
            ImageryInfo imageryInfo2 = this.layers.get(i);
            if (imageryInfo2.getId() == null || (imageryInfo = defaultLayerIds.get(imageryInfo2.getId())) == null || imageryInfo.equalsPref(imageryInfo2)) continue;
            this.layers.set(i, imageryInfo);
            bl = true;
        }
        if (bl) {
            this.save();
        }
    }

    private boolean isSimilar(ImageryInfo imageryInfo, ImageryInfo imageryInfo2) {
        if (imageryInfo == null) {
            return false;
        }
        if (!imageryInfo.getImageryType().equals((Object)imageryInfo2.getImageryType())) {
            return false;
        }
        if (imageryInfo.getId() != null && imageryInfo2.getId() != null) {
            return imageryInfo.getId().equals(imageryInfo2.getId());
        }
        return ImageryLayerInfo.isSimilar(imageryInfo.getUrl(), imageryInfo2.getUrl());
    }

    private static boolean isSimilar(String string, String string2) {
        return Objects.equals(string, string2) || string != null && string2 != null && !string.isEmpty() && !string2.isEmpty() && (string.contains(string2) || string2.contains(string));
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> arrayList = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo imageryInfo : this.layers) {
            arrayList.add(new ImageryInfo.ImageryPreferenceEntry(imageryInfo));
        }
        Main.pref.putListOfStructs("imagery.entries", arrayList, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> collection) {
        for (ImageryInfo imageryInfo : collection) {
            instance.add(imageryInfo);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }

    public String getUniqueId(ImageryInfo imageryInfo) {
        if (imageryInfo.getId() != null && this.layerIds.get(imageryInfo.getId()) == imageryInfo) {
            return imageryInfo.getId();
        }
        return null;
    }

    class DefaultEntryLoader
    extends PleaseWaitRunnable {
        private final boolean clearCache;
        private final boolean fastFail;
        private final List<ImageryInfo> newLayers;
        private ImageryReader reader;
        private boolean canceled;

        DefaultEntryLoader(boolean bl, boolean bl2) {
            super(I18n.tr("Update default entries", new Object[0]));
            this.newLayers = new ArrayList<ImageryInfo>();
            this.clearCache = bl;
            this.fastFail = bl2;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.reader);
        }

        @Override
        protected void realRun() {
            for (String string : ImageryLayerInfo.getImageryLayersSites()) {
                if (this.canceled) {
                    return;
                }
                this.loadSource(string);
            }
        }

        protected void loadSource(String string) {
            boolean bl = true;
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
            }
            catch (OfflineAccessException offlineAccessException) {
                Main.warn(offlineAccessException.getMessage());
                bl = false;
            }
            if (this.clearCache && bl) {
                CachedFile.cleanup(string);
            }
            try {
                this.reader = new ImageryReader(string);
                this.reader.setFastFail(this.fastFail);
                List<ImageryInfo> list = this.reader.parse();
                this.newLayers.addAll(list);
            }
            catch (IOException iOException) {
                Main.error(iOException, false);
            }
            catch (SAXException sAXException) {
                Main.error(sAXException);
            }
        }

        @Override
        protected void finish() {
            defaultLayers.clear();
            defaultLayers.addAll(this.newLayers);
            defaultLayerIds.clear();
            Collections.sort(defaultLayers);
            ImageryLayerInfo.buildIdMap(defaultLayers, defaultLayerIds);
            ImageryLayerInfo.this.updateEntriesFromDefaults();
            ImageryLayerInfo.buildIdMap(ImageryLayerInfo.this.layers, ImageryLayerInfo.this.layerIds);
        }
    }
}

