/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.io;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XMLRepository<T> {
    protected static final String FILE_EXTENSION = ".xml";
    protected File _baseDir;

    protected XMLRepository(File baseDir) {
        if (baseDir != null && !baseDir.exists()) {
            baseDir.mkdirs();
        }
        this._baseDir = baseDir;
    }

    protected T read(Class<T> clazz, String fileName) {
        Object obj = null;
        try {
            Unmarshaller um = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
            obj = um.unmarshal((Reader)new FileReader(this.getCompleteFileName(fileName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(T obj, String fileName) {
        Writer w = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            w = new FileWriter(this.getCompleteFileName(fileName));
            m.marshal(obj, w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                w.close();
            }
            catch (Exception e) {}
        }
    }

    protected String getCompleteFileName(String fileName) {
        return this._baseDir.getPath() + File.separator + this.getFileName(fileName);
    }

    public boolean fileExists(String filename) {
        return this.getRealFile(filename).exists();
    }

    protected File getRealFile(String filename) {
        return new File(this._baseDir, this.getFileName(filename));
    }

    protected String getFileName(String fileName) {
        return fileName + FILE_EXTENSION;
    }
}

