/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackTraceSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int threadSerialNumberOffset;
    final int stackTraceSerialNumberOffset;
    final int lengthOffset;
    final int framesListOffset;
    final int numberOfFramesOffset;
    final int timeOffset;

    StackTraceSegment(HprofHeap hprofHeap, long l, long l2) {
        super(5, l, l2);
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackTraceSerialNumberOffset = this.lengthOffset + 4;
        this.threadSerialNumberOffset = this.stackTraceSerialNumberOffset + 4;
        this.numberOfFramesOffset = this.threadSerialNumberOffset + 4;
        this.framesListOffset = this.numberOfFramesOffset + 4;
    }

    StackTrace getStackTraceBySerialNumber(long l) {
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l2 = lArray[0];
            long l3 = this.readStackTraceTag(lArray);
            if (l3 != l) continue;
            return new StackTrace(this, l2);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
        return hprofByteBuffer;
    }

    private int readStackTraceTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 5) {
            return 0;
        }
        return this.getDumpBuffer().getInt(l + (long)this.stackTraceSerialNumberOffset);
    }
}

